/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.ml.Probabilistic;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeChunkerME
implements Chunker,
Probabilistic,
AutoCloseable {
    private final ChunkerModel model;
    private final ThreadLocal<ChunkerME> threadLocal = new ThreadLocal();

    public ThreadSafeChunkerME(ChunkerModel model) {
        this.model = model;
    }

    private ChunkerME getChunker() {
        ChunkerME c = this.threadLocal.get();
        if (c == null) {
            c = new ChunkerME(this.model);
            this.threadLocal.set(c);
        }
        return c;
    }

    public String[] chunk(String[] toks, String[] tags) {
        return this.getChunker().chunk(toks, tags);
    }

    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        return this.getChunker().chunkAsSpans(toks, tags);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.getChunker().topKSequences(sentence, tags);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.getChunker().topKSequences(sentence, tags, minSequenceScore);
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }

    public double[] probs() {
        return this.getChunker().probs();
    }
}

