/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.DenseLiveDocs;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.SparseLiveDocs;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=3, time=2)
@Measurement(iterations=5, time=3)
@Fork(value=1, jvmArgsAppend={"-Xmx2g", "-Xms2g"})
public class LiveDocsBenchmark {
    @Param(value={"100000", "1000000", "10000000"})
    int maxDoc;
    @Param(value={"0.001", "0.01", "0.05", "0.10", "0.20", "0.30"})
    double deletionRate;
    @Param(value={"RANDOM", "CLUSTERED", "UNIFORM"})
    String deletionPattern;
    private SparseLiveDocs sparseLiveDocs;
    private DenseLiveDocs denseLiveDocs;
    private int[] randomDocIds;
    private static final int RANDOM_ACCESS_SIZE = 10000;
    private long sparseBytes;
    private long denseBytes;
    private double overheadPct;
    private int deleted;

    @Setup(value=Level.Trial)
    public void setup() {
        Random random = new Random(42L);
        int numDeleted = (int)((double)this.maxDoc * this.deletionRate);
        if (numDeleted == 0) {
            throw new IllegalStateException("Benchmark requires at least one deletion. Current parameters: maxDoc=" + this.maxDoc + ", deletionRate=" + this.deletionRate + " result in zero deletions.");
        }
        SparseFixedBitSet sparseSet = new SparseFixedBitSet(this.maxDoc);
        FixedBitSet fixedSet = new FixedBitSet(this.maxDoc);
        fixedSet.set(0, this.maxDoc);
        switch (this.deletionPattern) {
            case "RANDOM": {
                int docId;
                HashSet<Integer> deletedSet = new HashSet<Integer>();
                while (deletedSet.size() < numDeleted) {
                    deletedSet.add(random.nextInt(this.maxDoc));
                }
                Iterator iterator = deletedSet.iterator();
                while (iterator.hasNext()) {
                    docId = (Integer)iterator.next();
                    sparseSet.set(docId);
                    fixedSet.clear(docId);
                }
                break;
            }
            case "CLUSTERED": {
                for (int i = 0; i < numDeleted; ++i) {
                    sparseSet.set(i);
                    fixedSet.clear(i);
                }
                break;
            }
            case "UNIFORM": {
                int docId;
                for (int i = 0; i < numDeleted; ++i) {
                    docId = (int)((long)i * (long)this.maxDoc / (long)numDeleted);
                    sparseSet.set(docId);
                    fixedSet.clear(docId);
                }
                break;
            }
        }
        this.sparseLiveDocs = SparseLiveDocs.builder((SparseFixedBitSet)sparseSet, (int)this.maxDoc).build();
        this.denseLiveDocs = DenseLiveDocs.builder((FixedBitSet)fixedSet, (int)this.maxDoc).build();
        this.sparseBytes = this.sparseLiveDocs.ramBytesUsed();
        this.denseBytes = this.denseLiveDocs.ramBytesUsed();
        this.overheadPct = ((double)this.sparseBytes - (double)this.denseBytes) / (double)this.denseBytes * 100.0;
        this.deleted = (int)((double)this.maxDoc * this.deletionRate);
        this.randomDocIds = new int[10000];
        for (int i = 0; i < 10000; ++i) {
            this.randomDocIds[i] = random.nextInt(this.maxDoc);
        }
    }

    @Benchmark
    public void sparseRandomAccess(LiveDocsMetrics metrics, Blackhole blackhole) {
        this.fillMetrics(metrics);
        for (int docId : this.randomDocIds) {
            blackhole.consume(this.sparseLiveDocs.get(docId));
        }
    }

    @Benchmark
    public void denseRandomAccess(LiveDocsMetrics metrics, Blackhole blackhole) {
        this.fillMetrics(metrics);
        for (int docId : this.randomDocIds) {
            blackhole.consume(this.denseLiveDocs.get(docId));
        }
    }

    @Benchmark
    public int sparseIterateDeleted(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        DocIdSetIterator it = this.sparseLiveDocs.deletedDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int denseIterateDeleted(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        DocIdSetIterator it = this.denseLiveDocs.deletedDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int sparseIterateLiveDocs(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        DocIdSetIterator it = this.sparseLiveDocs.liveDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int denseIterateLiveDocs(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        DocIdSetIterator it = this.denseLiveDocs.liveDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int sparseIterateLiveDocsRange(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        int rangeStart = this.maxDoc / 4;
        int rangeEnd = this.maxDoc / 2;
        DocIdSetIterator it = this.sparseLiveDocs.liveDocsIterator();
        int count = 0;
        int doc = it.advance(rangeStart);
        while (doc < rangeEnd) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int denseIterateLiveDocsRange(LiveDocsMetrics metrics) throws IOException {
        this.fillMetrics(metrics);
        int rangeStart = this.maxDoc / 4;
        int rangeEnd = this.maxDoc / 2;
        DocIdSetIterator it = this.denseLiveDocs.liveDocsIterator();
        int count = 0;
        int doc = it.advance(rangeStart);
        while (doc < rangeEnd) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    private void fillMetrics(LiveDocsMetrics metrics) {
        metrics.deleted = this.deleted;
        metrics.sparseBytes = this.sparseBytes;
        metrics.denseBytes = this.denseBytes;
        metrics.overheadPct = this.overheadPct;
    }

    @AuxCounters(value=AuxCounters.Type.EVENTS)
    @State(value=Scope.Thread)
    public static class LiveDocsMetrics {
        public int deleted;
        public long sparseBytes;
        public long denseBytes;
        public double overheadPct;
    }
}

