/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.fst.FST;

final class ByteBlockPoolReverseBytesReader
extends FST.BytesReader {
    private final ByteBlockPool buf;
    private long posDelta;
    private long pos;

    public ByteBlockPoolReverseBytesReader(ByteBlockPool buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        return this.buf.readByte(this.pos--);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            b[offset + i] = this.buf.readByte(this.pos--);
        }
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        this.pos -= numBytes;
    }

    @Override
    public long getPosition() {
        return this.pos + this.posDelta;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = pos - this.posDelta;
    }

    public void setPosDelta(long posDelta) {
        this.posDelta = posDelta;
    }
}

