/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.EvaluationMonitor;

public abstract class Evaluator<T> {
    private final List<EvaluationMonitor<T>> listeners;

    @SafeVarargs
    public Evaluator(EvaluationMonitor<T> ... aListeners) {
        if (aListeners != null) {
            ArrayList<EvaluationMonitor<T>> listenersList = new ArrayList<EvaluationMonitor<T>>(aListeners.length);
            for (EvaluationMonitor<T> evaluationMonitor : aListeners) {
                if (evaluationMonitor == null) continue;
                listenersList.add(evaluationMonitor);
            }
            this.listeners = Collections.unmodifiableList(listenersList);
        } else {
            this.listeners = Collections.emptyList();
        }
    }

    protected abstract T processSample(T var1);

    public void evaluateSample(T sample) {
        block4: {
            T predicted = this.processSample(sample);
            if (this.listeners.isEmpty()) break block4;
            if (sample.equals(predicted)) {
                for (EvaluationMonitor<T> listener : this.listeners) {
                    listener.correctlyClassified(sample, predicted);
                }
            } else {
                for (EvaluationMonitor<T> listener : this.listeners) {
                    listener.misclassified(sample, predicted);
                }
            }
        }
    }

    public void evaluate(ObjectStream<T> samples) throws IOException {
        T sample;
        while ((sample = samples.read()) != null) {
            this.evaluateSample(sample);
        }
    }
}

