/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.CompetitiveImpactAccumulator;
import org.apache.lucene.codecs.MultiLevelSkipListWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class SimpleTextSkipWriter
extends MultiLevelSkipListWriter {
    static final int skipMultiplier = 3;
    static final int maxSkipLevels = 4;
    static final int BLOCK_SIZE = 8;
    private Map<Integer, Boolean> wroteHeaderPerLevelMap = new HashMap<Integer, Boolean>();
    private int curDoc;
    private long curDocFilePointer;
    private CompetitiveImpactAccumulator[] curCompetitiveFreqNorms;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    static final BytesRef SKIP_LIST = new BytesRef((CharSequence)"    skipList ");
    static final BytesRef LEVEL_LENGTH = new BytesRef((CharSequence)"      levelLength ");
    static final BytesRef LEVEL = new BytesRef((CharSequence)"      level ");
    static final BytesRef SKIP_DOC = new BytesRef((CharSequence)"        skipDoc ");
    static final BytesRef SKIP_DOC_FP = new BytesRef((CharSequence)"        skipDocFP ");
    static final BytesRef IMPACTS = new BytesRef((CharSequence)"        impacts ");
    static final BytesRef IMPACT = new BytesRef((CharSequence)"          impact ");
    static final BytesRef FREQ = new BytesRef((CharSequence)"            freq ");
    static final BytesRef NORM = new BytesRef((CharSequence)"            norm ");
    static final BytesRef IMPACTS_END = new BytesRef((CharSequence)"        impactsEnd ");
    static final BytesRef CHILD_POINTER = new BytesRef((CharSequence)"        childPointer ");

    SimpleTextSkipWriter(SegmentWriteState writeState) throws IOException {
        super(8, 3, 4, writeState.segmentInfo.maxDoc());
        this.curCompetitiveFreqNorms = new CompetitiveImpactAccumulator[4];
        for (int i = 0; i < 4; ++i) {
            this.curCompetitiveFreqNorms[i] = new CompetitiveImpactAccumulator();
        }
        this.resetSkip();
    }

    protected void writeSkipData(int level, DataOutput skipBuffer) throws IOException {
        Boolean wroteHeader = this.wroteHeaderPerLevelMap.get(level);
        if (wroteHeader == null || !wroteHeader.booleanValue()) {
            SimpleTextUtil.write(skipBuffer, LEVEL);
            SimpleTextUtil.write(skipBuffer, "" + level, this.scratch);
            SimpleTextUtil.writeNewline(skipBuffer);
            this.wroteHeaderPerLevelMap.put(level, true);
        }
        SimpleTextUtil.write(skipBuffer, SKIP_DOC);
        SimpleTextUtil.write(skipBuffer, "" + this.curDoc, this.scratch);
        SimpleTextUtil.writeNewline(skipBuffer);
        SimpleTextUtil.write(skipBuffer, SKIP_DOC_FP);
        SimpleTextUtil.write(skipBuffer, "" + this.curDocFilePointer, this.scratch);
        SimpleTextUtil.writeNewline(skipBuffer);
        CompetitiveImpactAccumulator competitiveFreqNorms = this.curCompetitiveFreqNorms[level];
        List impacts = competitiveFreqNorms.getCompetitiveFreqNormPairs();
        assert (impacts.size() > 0);
        if (level + 1 < this.numberOfSkipLevels) {
            this.curCompetitiveFreqNorms[level + 1].addAll(competitiveFreqNorms);
        }
        SimpleTextUtil.write(skipBuffer, IMPACTS);
        SimpleTextUtil.writeNewline(skipBuffer);
        for (Impact impact : impacts) {
            SimpleTextUtil.write(skipBuffer, IMPACT);
            SimpleTextUtil.writeNewline(skipBuffer);
            SimpleTextUtil.write(skipBuffer, FREQ);
            SimpleTextUtil.write(skipBuffer, "" + impact.freq, this.scratch);
            SimpleTextUtil.writeNewline(skipBuffer);
            SimpleTextUtil.write(skipBuffer, NORM);
            SimpleTextUtil.write(skipBuffer, "" + impact.norm, this.scratch);
            SimpleTextUtil.writeNewline(skipBuffer);
        }
        SimpleTextUtil.write(skipBuffer, IMPACTS_END);
        SimpleTextUtil.writeNewline(skipBuffer);
        competitiveFreqNorms.clear();
    }

    protected void resetSkip() {
        super.resetSkip();
        this.wroteHeaderPerLevelMap.clear();
        this.curDoc = -1;
        this.curDocFilePointer = -1L;
        for (CompetitiveImpactAccumulator acc : this.curCompetitiveFreqNorms) {
            acc.clear();
        }
    }

    public long writeSkip(IndexOutput output) throws IOException {
        long skipOffset = output.getFilePointer();
        SimpleTextUtil.write((DataOutput)output, SKIP_LIST);
        SimpleTextUtil.writeNewline((DataOutput)output);
        super.writeSkip(output);
        return skipOffset;
    }

    void bufferSkip(int doc, long docFilePointer, int numDocs, CompetitiveImpactAccumulator competitiveImpactAccumulator) throws IOException {
        assert (doc > this.curDoc);
        this.curDoc = doc;
        this.curDocFilePointer = docFilePointer;
        this.curCompetitiveFreqNorms[0].addAll(competitiveImpactAccumulator);
        this.bufferSkip(numDocs);
    }

    protected void writeLevelLength(long levelLength, IndexOutput output) throws IOException {
        SimpleTextUtil.write((DataOutput)output, LEVEL_LENGTH);
        SimpleTextUtil.write((DataOutput)output, "" + levelLength, this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)output);
    }

    protected void writeChildPointer(long childPointer, DataOutput skipBuffer) throws IOException {
        SimpleTextUtil.write(skipBuffer, CHILD_POINTER);
        SimpleTextUtil.write(skipBuffer, "" + childPointer, this.scratch);
        SimpleTextUtil.writeNewline(skipBuffer);
    }
}

