/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.codecs.simpletext.SimpleTextPointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.bkd.BKDConfig;

final class SimpleTextBKDReader
extends PointValues {
    private final byte[] splitPackedValues;
    final long[] leafBlockFPs;
    private final int leafNodeOffset;
    final BKDConfig config;
    final int bytesPerIndexEntry;
    final IndexInput in;
    final byte[] minPackedValue;
    final byte[] maxPackedValue;
    final long pointCount;
    final int docCount;
    final int version;

    public SimpleTextBKDReader(IndexInput in, int numDims, int numIndexDims, int maxPointsInLeafNode, int bytesPerDim, long[] leafBlockFPs, byte[] splitPackedValues, byte[] minPackedValue, byte[] maxPackedValue, long pointCount, int docCount) {
        this.in = in;
        this.config = new BKDConfig(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
        this.bytesPerIndexEntry = numIndexDims == 1 ? bytesPerDim : bytesPerDim + 1;
        this.leafNodeOffset = leafBlockFPs.length;
        this.leafBlockFPs = leafBlockFPs;
        this.splitPackedValues = splitPackedValues;
        this.minPackedValue = minPackedValue;
        this.maxPackedValue = maxPackedValue;
        this.pointCount = pointCount;
        this.docCount = docCount;
        this.version = 3;
        assert (minPackedValue.length == this.config.packedIndexBytesLength());
        assert (maxPackedValue.length == this.config.packedIndexBytesLength());
    }

    public PointValues.PointTree getPointTree() {
        return new SimpleTextPointTree(this.in.clone(), 1, 1, this.minPackedValue, this.maxPackedValue);
    }

    public byte[] getMinPackedValue() {
        return (byte[])this.minPackedValue.clone();
    }

    public byte[] getMaxPackedValue() {
        return (byte[])this.maxPackedValue.clone();
    }

    public int getNumDimensions() throws IOException {
        return this.config.numDims();
    }

    public int getNumIndexDimensions() throws IOException {
        return this.config.numIndexDims();
    }

    public int getBytesPerDimension() throws IOException {
        return this.config.bytesPerDim();
    }

    public long size() {
        return this.pointCount;
    }

    public int getDocCount() {
        return this.docCount;
    }

    private class SimpleTextPointTree
    implements PointValues.PointTree {
        final int[] scratchDocIDs;
        final byte[] scratchPackedValue;
        int nodeID;
        int level;
        final int rootNode;
        private final byte[] minPackedValue;
        private final byte[] maxPackedValue;
        private final byte[][] splitDimValueStack;
        private final int[] splitDims;
        private final IndexInput in;

        private SimpleTextPointTree(IndexInput in, int nodeID, int level, byte[] minPackedValue, byte[] maxPackedValue) {
            this.in = in;
            this.scratchDocIDs = new int[SimpleTextBKDReader.this.config.maxPointsInLeafNode()];
            this.scratchPackedValue = new byte[SimpleTextBKDReader.this.config.packedBytesLength()];
            this.nodeID = nodeID;
            this.rootNode = nodeID;
            this.level = level;
            this.maxPackedValue = (byte[])maxPackedValue.clone();
            this.minPackedValue = (byte[])minPackedValue.clone();
            int treeDepth = this.getTreeDepth(SimpleTextBKDReader.this.leafNodeOffset);
            this.splitDimValueStack = new byte[treeDepth + 1][];
            this.splitDims = new int[treeDepth + 1];
        }

        private int getTreeDepth(int numLeaves) {
            return MathUtil.log((long)numLeaves, (int)2) + 2;
        }

        public PointValues.PointTree clone() {
            SimpleTextPointTree index = new SimpleTextPointTree(this.in.clone(), this.nodeID, this.level, this.minPackedValue, this.maxPackedValue);
            if (!this.isLeafNode()) {
                index.splitDims[this.level] = this.splitDims[this.level];
                index.splitDimValueStack[this.level] = this.splitDimValueStack[this.level];
            }
            return index;
        }

        public boolean moveToChild() {
            if (this.isLeafNode()) {
                return false;
            }
            this.pushLeft();
            return true;
        }

        private void pushLeft() {
            int address = this.nodeID * SimpleTextBKDReader.this.bytesPerIndexEntry;
            this.splitDims[this.level] = SimpleTextBKDReader.this.config.numIndexDims() == 1 ? 0 : SimpleTextBKDReader.this.splitPackedValues[address++] & 0xFF;
            int splitDimPos = this.splitDims[this.level] * SimpleTextBKDReader.this.config.bytesPerDim();
            if (this.splitDimValueStack[this.level] == null) {
                this.splitDimValueStack[this.level] = new byte[SimpleTextBKDReader.this.config.bytesPerDim()];
            }
            System.arraycopy(this.maxPackedValue, splitDimPos, this.splitDimValueStack[this.level], 0, SimpleTextBKDReader.this.config.bytesPerDim());
            assert (Arrays.compareUnsigned(this.maxPackedValue, splitDimPos, splitDimPos + SimpleTextBKDReader.this.config.bytesPerDim(), SimpleTextBKDReader.this.splitPackedValues, address, address + SimpleTextBKDReader.this.config.bytesPerDim()) >= 0) : "config.bytesPerDim()=" + SimpleTextBKDReader.this.config.bytesPerDim() + " splitDim=" + this.splitDims[this.level] + " config.numIndexDims()=" + SimpleTextBKDReader.this.config.numIndexDims() + " config.numDims=" + SimpleTextBKDReader.this.config.numDims();
            this.nodeID *= 2;
            ++this.level;
            System.arraycopy(SimpleTextBKDReader.this.splitPackedValues, address, this.maxPackedValue, splitDimPos, SimpleTextBKDReader.this.config.bytesPerDim());
        }

        public boolean moveToSibling() {
            if (this.nodeID != this.rootNode && (this.nodeID & 1) == 0) {
                this.pop(true);
                this.pushRight();
                return true;
            }
            return false;
        }

        private void pushRight() {
            int address = this.nodeID * SimpleTextBKDReader.this.bytesPerIndexEntry;
            this.splitDims[this.level] = SimpleTextBKDReader.this.config.numIndexDims() == 1 ? 0 : SimpleTextBKDReader.this.splitPackedValues[address++] & 0xFF;
            int splitDimPos = this.splitDims[this.level] * SimpleTextBKDReader.this.config.bytesPerDim();
            assert (this.splitDimValueStack[this.level] != null);
            System.arraycopy(this.minPackedValue, splitDimPos, this.splitDimValueStack[this.level], 0, SimpleTextBKDReader.this.config.bytesPerDim());
            assert (Arrays.compareUnsigned(this.minPackedValue, splitDimPos, splitDimPos + SimpleTextBKDReader.this.config.bytesPerDim(), SimpleTextBKDReader.this.splitPackedValues, address, address + SimpleTextBKDReader.this.config.bytesPerDim()) <= 0) : "config.bytesPerDim()=" + SimpleTextBKDReader.this.config.bytesPerDim() + " splitDim=" + this.splitDims[this.level] + " config.numIndexDims()=" + SimpleTextBKDReader.this.config.numIndexDims() + " config.numDims=" + SimpleTextBKDReader.this.config.numDims();
            this.nodeID = 2 * this.nodeID + 1;
            ++this.level;
            System.arraycopy(SimpleTextBKDReader.this.splitPackedValues, address, this.minPackedValue, splitDimPos, SimpleTextBKDReader.this.config.bytesPerDim());
        }

        public boolean moveToParent() {
            if (this.nodeID == this.rootNode) {
                return false;
            }
            this.pop((this.nodeID & 1) == 0);
            return true;
        }

        private void pop(boolean isLeft) {
            this.nodeID /= 2;
            --this.level;
            if (isLeft) {
                System.arraycopy(this.splitDimValueStack[this.level], 0, this.maxPackedValue, this.splitDims[this.level] * SimpleTextBKDReader.this.config.bytesPerDim(), SimpleTextBKDReader.this.config.bytesPerDim());
            } else {
                System.arraycopy(this.splitDimValueStack[this.level], 0, this.minPackedValue, this.splitDims[this.level] * SimpleTextBKDReader.this.config.bytesPerDim(), SimpleTextBKDReader.this.config.bytesPerDim());
            }
        }

        public byte[] getMinPackedValue() {
            return (byte[])this.minPackedValue.clone();
        }

        public byte[] getMaxPackedValue() {
            return (byte[])this.maxPackedValue.clone();
        }

        public long size() {
            int leftMostLeafNode;
            for (leftMostLeafNode = this.nodeID; leftMostLeafNode < SimpleTextBKDReader.this.leafNodeOffset; leftMostLeafNode *= 2) {
            }
            int rightMostLeafNode = this.nodeID;
            while (rightMostLeafNode < SimpleTextBKDReader.this.leafNodeOffset) {
                rightMostLeafNode = rightMostLeafNode * 2 + 1;
            }
            int numLeaves = rightMostLeafNode >= leftMostLeafNode ? rightMostLeafNode - leftMostLeafNode + 1 : rightMostLeafNode - leftMostLeafNode + 1 + SimpleTextBKDReader.this.leafNodeOffset;
            assert (numLeaves == this.getNumLeavesSlow(this.nodeID)) : numLeaves + " " + this.getNumLeavesSlow(this.nodeID);
            return this.sizeFromBalancedTree(leftMostLeafNode, rightMostLeafNode);
        }

        private long sizeFromBalancedTree(int leftMostLeafNode, int rightMostLeafNode) {
            int extraPoints = Math.toIntExact((long)SimpleTextBKDReader.this.config.maxPointsInLeafNode() * (long)SimpleTextBKDReader.this.leafNodeOffset - SimpleTextBKDReader.this.pointCount);
            assert (extraPoints < SimpleTextBKDReader.this.leafNodeOffset) : "point excess should be lower than leafNodeOffset";
            int nodeOffset = SimpleTextBKDReader.this.leafNodeOffset - extraPoints;
            long count = 0L;
            for (int node = leftMostLeafNode; node <= rightMostLeafNode; ++node) {
                if (this.balanceTreeNodePosition(0, SimpleTextBKDReader.this.leafNodeOffset, node - SimpleTextBKDReader.this.leafNodeOffset, 0, 0) < nodeOffset) {
                    count += (long)SimpleTextBKDReader.this.config.maxPointsInLeafNode();
                    continue;
                }
                count += (long)(SimpleTextBKDReader.this.config.maxPointsInLeafNode() - 1);
            }
            return count;
        }

        private int balanceTreeNodePosition(int minNode, int maxNode, int node, int position, int level) {
            if (maxNode - minNode == 1) {
                return position;
            }
            int mid = minNode + maxNode + 1 >>> 1;
            if (mid > node) {
                return this.balanceTreeNodePosition(minNode, mid, node, position, level + 1);
            }
            return this.balanceTreeNodePosition(mid, maxNode, node, position + (1 << level), level + 1);
        }

        private int getNumLeavesSlow(int node) {
            if (node >= 2 * SimpleTextBKDReader.this.leafNodeOffset) {
                return 0;
            }
            if (node >= SimpleTextBKDReader.this.leafNodeOffset) {
                return 1;
            }
            int leftCount = this.getNumLeavesSlow(node * 2);
            int rightCount = this.getNumLeavesSlow(node * 2 + 1);
            return leftCount + rightCount;
        }

        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.addAll(visitor, false);
        }

        public void addAll(PointValues.IntersectVisitor visitor, boolean grown) throws IOException {
            long size;
            if (!grown && (size = this.size()) <= Integer.MAX_VALUE) {
                visitor.grow((int)size);
                grown = true;
            }
            if (this.isLeafNode()) {
                BytesRefBuilder scratch = new BytesRefBuilder();
                this.in.seek(SimpleTextBKDReader.this.leafBlockFPs[this.nodeID - SimpleTextBKDReader.this.leafNodeOffset]);
                this.readLine(this.in, scratch);
                int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
                for (int i = 0; i < count; ++i) {
                    this.readLine(this.in, scratch);
                    visitor.visit(this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID));
                }
            } else {
                this.pushLeft();
                this.addAll(visitor, grown);
                this.pop(true);
                this.pushRight();
                this.addAll(visitor, grown);
                this.pop(false);
            }
        }

        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            if (this.isLeafNode()) {
                int leafID = this.nodeID - SimpleTextBKDReader.this.leafNodeOffset;
                int count = this.readDocIDs(this.in, SimpleTextBKDReader.this.leafBlockFPs[leafID], this.scratchDocIDs);
                visitor.grow(count);
                assert (this.scratchPackedValue.length == SimpleTextBKDReader.this.config.packedBytesLength());
                BytesRefBuilder scratch = new BytesRefBuilder();
                for (int i = 0; i < count; ++i) {
                    this.readLine(this.in, scratch);
                    assert (this.startsWith(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
                    BytesRef br = SimpleTextUtil.fromBytesRefString(this.stripPrefix(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
                    assert (br.length == SimpleTextBKDReader.this.config.packedBytesLength());
                    System.arraycopy(br.bytes, br.offset, this.scratchPackedValue, 0, SimpleTextBKDReader.this.config.packedBytesLength());
                    visitor.visit(this.scratchDocIDs[i], this.scratchPackedValue);
                }
            } else {
                this.pushLeft();
                this.visitDocValues(visitor);
                this.pop(true);
                this.pushRight();
                this.visitDocValues(visitor);
                this.pop(false);
            }
        }

        int readDocIDs(IndexInput in, long blockFP, int[] docIDs) throws IOException {
            BytesRefBuilder scratch = new BytesRefBuilder();
            in.seek(blockFP);
            this.readLine(in, scratch);
            int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
            for (int i = 0; i < count; ++i) {
                this.readLine(in, scratch);
                docIDs[i] = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID);
            }
            return count;
        }

        public boolean isLeafNode() {
            return this.nodeID >= SimpleTextBKDReader.this.leafNodeOffset;
        }

        private int parseInt(BytesRefBuilder scratch, BytesRef prefix) {
            assert (this.startsWith(scratch, prefix));
            return Integer.parseInt(this.stripPrefix(scratch, prefix));
        }

        private String stripPrefix(BytesRefBuilder scratch, BytesRef prefix) {
            return new String(scratch.bytes(), prefix.length, scratch.length() - prefix.length, StandardCharsets.UTF_8);
        }

        private boolean startsWith(BytesRefBuilder scratch, BytesRef prefix) {
            return StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)prefix);
        }

        private void readLine(IndexInput in, BytesRefBuilder scratch) throws IOException {
            SimpleTextUtil.readLine((DataInput)in, scratch);
        }
    }
}

