/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockCharFilter;
import org.apache.lucene.tests.analysis.MockReaderWrapper;
import org.apache.lucene.tests.analysis.MockTokenizer;
import org.apache.lucene.tests.analysis.Token;
import org.apache.lucene.tests.analysis.TokenStreamToDot;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.Rethrow;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.tests.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.fst.Util;

public abstract class BaseTokenStreamTestCase
extends LuceneTestCase {
    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, Integer finalPosInc, boolean[] keywordAtts, boolean graphOffsetsAreCorrect, byte[][] payloads, int[] flags, float[] boost) throws IOException {
        BaseTokenStreamTestCase.assertNotNull((Object)output);
        CheckClearAttributesAttribute checkClearAtt = (CheckClearAttributesAttribute)ts.addAttribute(CheckClearAttributesAttribute.class);
        CharTermAttribute termAtt = null;
        if (output.length > 0) {
            BaseTokenStreamTestCase.assertTrue((String)"has no CharTermAttribute", (boolean)ts.hasAttribute(CharTermAttribute.class));
            termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
            BaseTokenStreamTestCase.assertTrue((String)"has no TermToBytesRefAttribute", (boolean)ts.hasAttribute(TermToBytesRefAttribute.class));
            TermToBytesRefAttribute bytesAtt = (TermToBytesRefAttribute)ts.getAttribute(TermToBytesRefAttribute.class);
            if (!Objects.equals(bytesAtt.getClass().getSimpleName(), "BytesRefBuilderTermAttributeImpl")) {
                BaseTokenStreamTestCase.assertSame((String)"TermToBytesRefAttribute must be implemented by same instance", (Object)termAtt, (Object)bytesAtt);
            }
        }
        OffsetAttribute offsetAtt = null;
        if (startOffsets != null || endOffsets != null || finalOffset != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no OffsetAttribute", (boolean)ts.hasAttribute(OffsetAttribute.class));
            offsetAtt = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
        }
        TypeAttribute typeAtt = null;
        if (types != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no TypeAttribute", (boolean)ts.hasAttribute(TypeAttribute.class));
            typeAtt = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
        }
        PositionIncrementAttribute posIncrAtt = null;
        if (posIncrements != null || finalPosInc != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PositionIncrementAttribute", (boolean)ts.hasAttribute(PositionIncrementAttribute.class));
            posIncrAtt = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
        }
        PositionLengthAttribute posLengthAtt = null;
        if (posLengths != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PositionLengthAttribute", (boolean)ts.hasAttribute(PositionLengthAttribute.class));
            posLengthAtt = (PositionLengthAttribute)ts.getAttribute(PositionLengthAttribute.class);
        }
        KeywordAttribute keywordAtt = null;
        if (keywordAtts != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no KeywordAttribute", (boolean)ts.hasAttribute(KeywordAttribute.class));
            keywordAtt = (KeywordAttribute)ts.getAttribute(KeywordAttribute.class);
        }
        PayloadAttribute payloadAtt = null;
        if (payloads != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PayloadAttribute", (boolean)ts.hasAttribute(PayloadAttribute.class));
            payloadAtt = (PayloadAttribute)ts.getAttribute(PayloadAttribute.class);
        }
        FlagsAttribute flagsAtt = null;
        if (flags != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no FlagsAttribute", (boolean)ts.hasAttribute(FlagsAttribute.class));
            flagsAtt = (FlagsAttribute)ts.getAttribute(FlagsAttribute.class);
        }
        BoostAttribute boostAtt = null;
        if (boost != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no BoostAttribute", (boolean)ts.hasAttribute(BoostAttribute.class));
            boostAtt = (BoostAttribute)ts.getAttribute(BoostAttribute.class);
        }
        HashMap<Integer, Integer> posToStartOffset = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> posToEndOffset = new HashMap<Integer, Integer>();
        ts.reset();
        int pos = -1;
        int lastStartOffset = 0;
        for (int i = 0; i < output.length; ++i) {
            ts.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
            if (offsetAtt != null) {
                offsetAtt.setOffset(14584724, 24683243);
            }
            if (typeAtt != null) {
                typeAtt.setType("bogusType");
            }
            if (posIncrAtt != null) {
                posIncrAtt.setPositionIncrement(45987657);
            }
            if (posLengthAtt != null) {
                posLengthAtt.setPositionLength(45987653);
            }
            if (keywordAtt != null) {
                keywordAtt.setKeyword((i & 1) == 0);
            }
            if (payloadAtt != null) {
                payloadAtt.setPayload(new BytesRef(new byte[]{0, -33, 18, -67, 36}));
            }
            if (flagsAtt != null) {
                flagsAtt.setFlags(-1);
            }
            if (boostAtt != null) {
                boostAtt.setBoost(-1.0f);
            }
            checkClearAtt.getAndResetClearCalled();
            BaseTokenStreamTestCase.assertTrue((String)("token " + i + " does not exist"), (boolean)ts.incrementToken());
            BaseTokenStreamTestCase.assertTrue((String)("clearAttributes() was not called correctly in TokenStream chain at token " + i), (boolean)checkClearAtt.getAndResetClearCalled());
            BaseTokenStreamTestCase.assertEquals((String)("term " + i), (Object)output[i], (Object)termAtt.toString());
            if (startOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("startOffset " + i + " term=" + String.valueOf(termAtt)), (long)startOffsets[i], (long)offsetAtt.startOffset());
            }
            if (endOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("endOffset " + i + " term=" + String.valueOf(termAtt)), (long)endOffsets[i], (long)offsetAtt.endOffset());
            }
            if (types != null) {
                BaseTokenStreamTestCase.assertEquals((String)("type " + i + " term=" + String.valueOf(termAtt)), (Object)types[i], (Object)typeAtt.type());
            }
            if (posIncrements != null) {
                BaseTokenStreamTestCase.assertEquals((String)("posIncrement " + i + " term=" + String.valueOf(termAtt)), (long)posIncrements[i], (long)posIncrAtt.getPositionIncrement());
            }
            if (posLengths != null) {
                BaseTokenStreamTestCase.assertEquals((String)("posLength " + i + " term=" + String.valueOf(termAtt)), (long)posLengths[i], (long)posLengthAtt.getPositionLength());
            }
            if (keywordAtts != null) {
                BaseTokenStreamTestCase.assertEquals((String)("keywordAtt " + i + " term=" + String.valueOf(termAtt)), (Object)keywordAtts[i], (Object)keywordAtt.isKeyword());
            }
            if (flagsAtt != null) {
                BaseTokenStreamTestCase.assertEquals((String)("flagsAtt " + i + " term=" + String.valueOf(termAtt)), (long)flags[i], (long)flagsAtt.getFlags());
            }
            if (boostAtt != null) {
                BaseTokenStreamTestCase.assertEquals((String)("boostAtt " + i + " term=" + String.valueOf(termAtt)), (double)boost[i], (double)boostAtt.getBoost(), (double)0.001);
            }
            if (payloads != null) {
                if (payloads[i] != null) {
                    BaseTokenStreamTestCase.assertEquals((String)("payloads " + i), (Object)new BytesRef(payloads[i]), (Object)payloadAtt.getPayload());
                } else {
                    BaseTokenStreamTestCase.assertNull((String)("payloads " + i), (Object)payloads[i]);
                }
            }
            if (posIncrAtt != null) {
                if (i == 0) {
                    BaseTokenStreamTestCase.assertTrue((String)"first posIncrement must be >= 1", (posIncrAtt.getPositionIncrement() >= 1 ? 1 : 0) != 0);
                } else {
                    BaseTokenStreamTestCase.assertTrue((String)"posIncrement must be >= 0", (posIncrAtt.getPositionIncrement() >= 0 ? 1 : 0) != 0);
                }
            }
            if (posLengthAtt != null) {
                BaseTokenStreamTestCase.assertTrue((String)("posLength must be >= 1; got: " + posLengthAtt.getPositionLength()), (posLengthAtt.getPositionLength() >= 1 ? 1 : 0) != 0);
            }
            if (offsetAtt == null) continue;
            int startOffset = offsetAtt.startOffset();
            int endOffset = offsetAtt.endOffset();
            if (finalOffset != null) {
                BaseTokenStreamTestCase.assertTrue((String)("startOffset (= " + startOffset + ") must be <= finalOffset (= " + finalOffset + ") term=" + String.valueOf(termAtt)), (startOffset <= finalOffset ? 1 : 0) != 0);
                BaseTokenStreamTestCase.assertTrue((String)("endOffset must be <= finalOffset: got endOffset=" + endOffset + " vs finalOffset=" + finalOffset + " term=" + String.valueOf(termAtt)), (endOffset <= finalOffset ? 1 : 0) != 0);
            }
            BaseTokenStreamTestCase.assertTrue((String)("offsets must not go backwards startOffset=" + startOffset + " is < lastStartOffset=" + lastStartOffset + " term=" + String.valueOf(termAtt)), (offsetAtt.startOffset() >= lastStartOffset ? 1 : 0) != 0);
            lastStartOffset = offsetAtt.startOffset();
            if (!graphOffsetsAreCorrect || posLengthAtt == null || posIncrAtt == null) continue;
            int posInc = posIncrAtt.getPositionIncrement();
            int posLength = posLengthAtt.getPositionLength();
            if (!posToStartOffset.containsKey(pos += posInc)) {
                posToStartOffset.put(pos, startOffset);
            } else {
                BaseTokenStreamTestCase.assertEquals((String)(i + " inconsistent startOffset: pos=" + pos + " posLen=" + posLength + " token=" + String.valueOf(termAtt)), (long)((Integer)posToStartOffset.get(pos)).intValue(), (long)startOffset);
            }
            int endPos = pos + posLength;
            if (!posToEndOffset.containsKey(endPos)) {
                posToEndOffset.put(endPos, endOffset);
                continue;
            }
            BaseTokenStreamTestCase.assertEquals((String)("inconsistent endOffset " + i + " pos=" + pos + " posLen=" + posLength + " token=" + String.valueOf(termAtt)), (long)((Integer)posToEndOffset.get(endPos)).intValue(), (long)endOffset);
        }
        if (ts.incrementToken()) {
            BaseTokenStreamTestCase.fail((String)("TokenStream has more tokens than expected (expected count=" + output.length + "); extra token=" + String.valueOf(ts.getAttribute(CharTermAttribute.class))));
        }
        ts.clearAttributes();
        if (termAtt != null) {
            termAtt.setEmpty().append("bogusTerm");
        }
        if (offsetAtt != null) {
            offsetAtt.setOffset(14584724, 24683243);
        }
        if (typeAtt != null) {
            typeAtt.setType("bogusType");
        }
        if (posIncrAtt != null) {
            posIncrAtt.setPositionIncrement(45987657);
        }
        if (posLengthAtt != null) {
            posLengthAtt.setPositionLength(45987653);
        }
        if (keywordAtt != null) {
            keywordAtt.setKeyword(true);
        }
        if (payloadAtt != null) {
            payloadAtt.setPayload(new BytesRef(new byte[]{0, -33, 18, -67, 36}));
        }
        if (flagsAtt != null) {
            flagsAtt.setFlags(-1);
        }
        if (boostAtt != null) {
            boostAtt.setBoost(-1.0f);
        }
        checkClearAtt.getAndResetClearCalled();
        ts.end();
        BaseTokenStreamTestCase.assertTrue((String)"super.end()/clearAttributes() was not called correctly in end()", (boolean)checkClearAtt.getAndResetClearCalled());
        if (finalOffset != null) {
            BaseTokenStreamTestCase.assertEquals((String)"finalOffset", (long)finalOffset.intValue(), (long)offsetAtt.endOffset());
        }
        if (offsetAtt != null) {
            BaseTokenStreamTestCase.assertTrue((String)"finalOffset must be >= 0", (offsetAtt.endOffset() >= 0 ? 1 : 0) != 0);
        }
        if (finalPosInc != null) {
            BaseTokenStreamTestCase.assertEquals((String)"finalPosInc", (long)finalPosInc.intValue(), (long)posIncrAtt.getPositionIncrement());
        }
        ts.close();
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, Integer finalPosInc, boolean[] keywordAtts, boolean graphOffsetsAreCorrect, byte[][] payloads, int[] flags) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, finalPosInc, keywordAtts, graphOffsetsAreCorrect, payloads, flags, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean[] keywordAtts, boolean graphOffsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, keywordAtts, graphOffsetsAreCorrect, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean[] keywordAtts, boolean graphOffsetsAreCorrect, float[] boost) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, null, keywordAtts, graphOffsetsAreCorrect, null, null, boost);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, Integer finalPosInc, boolean[] keywordAtts, boolean graphOffsetsAreCorrect, byte[][] payloads) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, finalPosInc, keywordAtts, graphOffsetsAreCorrect, payloads, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean graphOffsetsAreCorrect, float[] boost) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, null, graphOffsetsAreCorrect, boost);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean graphOffsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, null, graphOffsetsAreCorrect, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, true);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, float[] boost) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, true, boost);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, types, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements, int[] posLengths, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, posLengths, finalOffset);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, null, input.length());
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.checkAnalysisConsistency(BaseTokenStreamTestCase.random(), a, true, input);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, types, posIncrements, posLengths, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, float[] boost) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, posLengths, (Integer)input.length(), boost);
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.checkAnalysisConsistency(BaseTokenStreamTestCase.random(), a, true, input);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, boolean graphOffsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, posLengths, (Integer)input.length(), graphOffsetsAreCorrect);
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.checkAnalysisConsistency(BaseTokenStreamTestCase.random(), a, true, input, graphOffsetsAreCorrect);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, boolean graphOffsetsAreCorrect, byte[][] payloads) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, posLengths, input.length(), null, null, graphOffsetsAreCorrect, payloads);
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.checkAnalysisConsistency(BaseTokenStreamTestCase.random(), a, true, input, graphOffsetsAreCorrect);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, types, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, posIncrements, null);
    }

    public static void assertAnalyzesToPositions(Analyzer a, String input, String[] output, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, posIncrements, posLengths);
    }

    public static void assertAnalyzesToPositions(Analyzer a, String input, String[] output, String[] types, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, types, posIncrements, posLengths);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, posIncrements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkResetException(Analyzer a, String input) throws IOException {
        TokenStream ts = a.tokenStream("bogus", input);
        try {
            if (ts.incrementToken()) {
                BaseTokenStreamTestCase.fail((String)"didn't get expected exception when reset() not called");
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace(System.err);
            BaseTokenStreamTestCase.fail((String)("got wrong exception when reset() not called: " + String.valueOf(unexpected)));
        }
        finally {
            ts.reset();
            while (ts.incrementToken()) {
            }
            ts.end();
            ts.close();
        }
        ts = a.tokenStream("bogus", input);
        ts.reset();
        while (ts.incrementToken()) {
        }
        ts.end();
        try {
            ts = a.tokenStream("bogus", input);
            BaseTokenStreamTestCase.fail((String)"didn't get expected exception when close() not called");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            ts.close();
        }
    }

    public static void checkOneTerm(Analyzer a, String input, String expected) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, new String[]{expected});
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, 20, false, true);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, maxWordLength, false, true);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, boolean simple) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, 20, simple, true);
    }

    public static void assertStreamHasNumberOfTokens(TokenStream ts, int expectedCount) throws IOException {
        ts.reset();
        int count = 0;
        while (ts.incrementToken()) {
            ++count;
        }
        ts.end();
        BaseTokenStreamTestCase.assertEquals((String)"wrong number of tokens", (long)expectedCount, (long)count);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean simple) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, maxWordLength, simple, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean simple, boolean graphOffsetsAreCorrect) throws IOException {
        block13: {
            BaseDirectoryWrapper dir;
            block12: {
                boolean codecOk;
                BaseTokenStreamTestCase.checkResetException(a, "best effort");
                long seed = random.nextLong();
                boolean useCharFilter = random.nextBoolean();
                dir = null;
                RandomIndexWriter iw = null;
                String postingsFormat = TestUtil.getPostingsFormat("dummy");
                boolean bl = codecOk = iterations * maxWordLength < 100000 && !postingsFormat.equals("SimpleText");
                if (BaseTokenStreamTestCase.rarely(random) && codecOk) {
                    dir = BaseTokenStreamTestCase.newFSDirectory(BaseTokenStreamTestCase.createTempDir("bttc"));
                    iw = new RandomIndexWriter(new Random(seed), (Directory)dir, a);
                }
                boolean success = false;
                try {
                    int i;
                    BaseTokenStreamTestCase.checkRandomData(new Random(seed), a, iterations, maxWordLength, useCharFilter, simple, graphOffsetsAreCorrect, iw);
                    int numThreads = TestUtil.nextInt(random, 2, 4);
                    CountDownLatch startingGun = new CountDownLatch(1);
                    AnalysisThread[] threads = new AnalysisThread[numThreads];
                    for (i = 0; i < threads.length; ++i) {
                        threads[i] = new AnalysisThread(seed, startingGun, a, iterations, maxWordLength, useCharFilter, simple, graphOffsetsAreCorrect, iw);
                    }
                    for (i = 0; i < threads.length; ++i) {
                        threads[i].start();
                    }
                    startingGun.countDown();
                    for (i = 0; i < threads.length; ++i) {
                        try {
                            threads[i].join();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    for (i = 0; i < threads.length; ++i) {
                        if (!threads[i].failed) continue;
                        throw new RuntimeException("some thread(s) failed");
                    }
                    if (iw != null) {
                        iw.close();
                    }
                    if (!(success = true)) break block12;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{dir});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{dir});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{dir});
                break block13;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{dir});
        }
    }

    private static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean useCharFilter, boolean simple, boolean graphOffsetsAreCorrect, RandomIndexWriter iw) throws IOException {
        Document doc = null;
        Field field = null;
        Field currentField = null;
        StringReader bogus = new StringReader("");
        if (iw != null) {
            doc = new Document();
            FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
            if (random.nextBoolean()) {
                ft.setStoreTermVectors(true);
                ft.setStoreTermVectorOffsets(random.nextBoolean());
                ft.setStoreTermVectorPositions(random.nextBoolean());
                if (ft.storeTermVectorPositions()) {
                    ft.setStoreTermVectorPayloads(random.nextBoolean());
                }
            }
            if (random.nextBoolean()) {
                ft.setOmitNorms(true);
            }
            switch (random.nextInt(4)) {
                case 0: {
                    ft.setIndexOptions(IndexOptions.DOCS);
                    break;
                }
                case 1: {
                    ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
                    break;
                }
                case 2: {
                    ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                    break;
                }
                default: {
                    ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
                }
            }
            currentField = field = new Field("dummy", (Reader)bogus, (IndexableFieldType)ft);
            doc.add((IndexableField)currentField);
        }
        for (int i = 0; i < iterations; ++i) {
            String text = TestUtil.randomAnalysisString(random, maxWordLength, simple);
            try {
                BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, graphOffsetsAreCorrect, currentField);
                if (iw == null) continue;
                if (random.nextInt(7) == 0) {
                    IndexableFieldType ft = field.fieldType();
                    currentField = new Field("dummy", (Reader)bogus, ft);
                    doc.add((IndexableField)currentField);
                    continue;
                }
                iw.addDocument(doc);
                if (doc.getFields().size() <= 1) continue;
                currentField = field;
                doc.removeFields("dummy");
                doc.add((IndexableField)currentField);
                continue;
            }
            catch (Throwable t) {
                System.err.println("TEST FAIL: useCharFilter=" + useCharFilter + " text='" + BaseTokenStreamTestCase.escape(text) + "'");
                Rethrow.rethrow(t);
            }
        }
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int charUpto = 0; charUpto < s.length(); ++charUpto) {
            char c = s.charAt(charUpto);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c >= ' ' && c < '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append(String.format(Locale.ROOT, "\\u%04x", (int)c));
        }
        return sb.toString();
    }

    public static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text) throws IOException {
        BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, true);
    }

    public static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text, boolean graphOffsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, graphOffsetsAreCorrect, null);
    }

    private static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text, boolean graphOffsetsAreCorrect, Field field) throws IOException {
        if (VERBOSE) {
            System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: get first token stream now text=" + text);
        }
        int remainder = random.nextInt(10);
        Reader reader = new StringReader(text);
        TokenStream ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        CharTermAttribute termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)ts.getAttribute(PositionLengthAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        ArrayList<Integer> positionLengths = new ArrayList<Integer>();
        ArrayList<Integer> startOffsets = new ArrayList<Integer>();
        ArrayList<Integer> endOffsets = new ArrayList<Integer>();
        ts.reset();
        while (ts.incrementToken()) {
            BaseTokenStreamTestCase.assertNotNull((String)"has no CharTermAttribute", (Object)termAtt);
            tokens.add(termAtt.toString());
            if (typeAtt != null) {
                types.add(typeAtt.type());
            }
            if (posIncAtt != null) {
                positions.add(posIncAtt.getPositionIncrement());
            }
            if (posLengthAtt != null) {
                positionLengths.add(posLengthAtt.getPositionLength());
            }
            if (offsetAtt == null) continue;
            startOffsets.add(offsetAtt.startOffset());
            endOffsets.add(offsetAtt.endOffset());
        }
        ts.end();
        ts.close();
        if (!tokens.isEmpty() && text.length() != 0) {
            int evilness = random.nextInt(50);
            if (evilness == 17) {
                block35: {
                    if (VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis w/ exception");
                    }
                    MockReaderWrapper evilReader = new MockReaderWrapper(random, new StringReader(text));
                    evilReader.throwExcAfterChar(random.nextInt(text.length() + 1));
                    reader = evilReader;
                    try {
                        ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
                        ts.reset();
                        while (ts.incrementToken()) {
                        }
                        BaseTokenStreamTestCase.fail((String)"did not hit exception");
                    }
                    catch (RuntimeException re) {
                        BaseTokenStreamTestCase.assertTrue((boolean)MockReaderWrapper.isMyEvilException(re));
                    }
                    try {
                        ts.end();
                    }
                    catch (IllegalStateException ise) {
                        if (ise.getMessage().contains("end() called in wrong state=")) break block35;
                        throw ise;
                    }
                }
                ts.close();
            } else if (evilness == 7) {
                block36: {
                    int numTokensToRead = random.nextInt(tokens.size());
                    if (VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis, only consuming " + numTokensToRead + " of " + tokens.size() + " tokens");
                    }
                    reader = new StringReader(text);
                    ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
                    ts.reset();
                    for (int tokenCount = 0; tokenCount < numTokensToRead; ++tokenCount) {
                        BaseTokenStreamTestCase.assertTrue((boolean)ts.incrementToken());
                    }
                    try {
                        ts.end();
                    }
                    catch (IllegalStateException ise) {
                        if (ise.getMessage().contains("end() called in wrong state=")) break block36;
                        throw ise;
                    }
                }
                ts.close();
            }
        }
        if (VERBOSE) {
            System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis; " + tokens.size() + " tokens");
        }
        reader = new StringReader(text);
        long seed = random.nextLong();
        if ((random = new Random(seed)).nextInt(30) == 7) {
            if (VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: using spoon-feed reader");
            }
            reader = new MockReaderWrapper(random, reader);
        }
        ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        if (typeAtt != null && posIncAtt != null && posLengthAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), types.toArray(new String[types.size()]), BaseTokenStreamTestCase.toIntArray(positions), BaseTokenStreamTestCase.toIntArray(positionLengths), (Integer)text.length(), graphOffsetsAreCorrect);
        } else if (typeAtt != null && posIncAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), types.toArray(new String[types.size()]), BaseTokenStreamTestCase.toIntArray(positions), null, (Integer)text.length(), graphOffsetsAreCorrect);
        } else if (posIncAtt != null && posLengthAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, BaseTokenStreamTestCase.toIntArray(positions), BaseTokenStreamTestCase.toIntArray(positionLengths), (Integer)text.length(), graphOffsetsAreCorrect);
        } else if (posIncAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, BaseTokenStreamTestCase.toIntArray(positions), null, (Integer)text.length(), graphOffsetsAreCorrect);
        } else if (offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, null, null, (Integer)text.length(), graphOffsetsAreCorrect);
        } else {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]));
        }
        a.normalize("dummy", text);
        if (field != null) {
            reader = new StringReader(text);
            random = new Random(seed);
            if (random.nextInt(30) == 7) {
                if (VERBOSE) {
                    System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: indexing using spoon-feed reader");
                }
                reader = new MockReaderWrapper(random, reader);
            }
            field.setReaderValue((Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        }
    }

    protected String toDot(Analyzer a, String inputText) throws IOException {
        StringWriter sw = new StringWriter();
        TokenStream ts = a.tokenStream("field", inputText);
        ts.reset();
        new TokenStreamToDot(inputText, ts, new PrintWriter(sw)).toDot();
        return sw.toString();
    }

    protected void toDotFile(Analyzer a, String inputText, String localFileName) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(Paths.get(localFileName, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
        TokenStream ts = a.tokenStream("field", inputText);
        ts.reset();
        new TokenStreamToDot(inputText, ts, new PrintWriter(w)).toDot();
        ((Writer)w).close();
    }

    private static int[] toIntArray(List<Integer> list) {
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    protected static MockTokenizer whitespaceMockTokenizer(Reader input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader(input);
        return mockTokenizer;
    }

    protected static MockTokenizer whitespaceMockTokenizer(String input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader(new StringReader(input));
        return mockTokenizer;
    }

    protected static MockTokenizer keywordMockTokenizer(Reader input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
        mockTokenizer.setReader(input);
        return mockTokenizer;
    }

    protected static MockTokenizer keywordMockTokenizer(String input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
        mockTokenizer.setReader(new StringReader(input));
        return mockTokenizer;
    }

    public static AttributeFactory newAttributeFactory(Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                return TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY;
            }
            case 1: {
                return Token.TOKEN_ATTRIBUTE_FACTORY;
            }
            case 2: {
                return AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY;
            }
        }
        throw new AssertionError((Object)"Please fix the Random.nextInt() call above");
    }

    public static AttributeFactory newAttributeFactory() {
        return BaseTokenStreamTestCase.newAttributeFactory(BaseTokenStreamTestCase.random());
    }

    private static String toString(Set<String> strings) {
        ArrayList<String> stringsList = new ArrayList<String>(strings);
        Collections.sort(stringsList);
        StringBuilder b = new StringBuilder();
        for (String s : stringsList) {
            b.append("  ");
            b.append(s);
            b.append('\n');
        }
        return b.toString();
    }

    public static void assertGraphStrings(Analyzer analyzer, String text, String ... expectedStrings) throws IOException {
        BaseTokenStreamTestCase.checkAnalysisConsistency(BaseTokenStreamTestCase.random(), analyzer, true, text, true);
        try (TokenStream tokenStream = analyzer.tokenStream("dummy", text);){
            BaseTokenStreamTestCase.assertGraphStrings(tokenStream, expectedStrings);
        }
    }

    public static void assertGraphStrings(TokenStream tokenStream, String ... expectedStrings) throws IOException {
        Automaton automaton = new TokenStreamToAutomaton().toAutomaton(tokenStream);
        Set<IntsRef> actualStringPaths = AutomatonTestUtil.getFiniteStringsRecursive(automaton, -1);
        HashSet<String> expectedStringsSet = new HashSet<String>(Arrays.asList(expectedStrings));
        BytesRefBuilder scratchBytesRefBuilder = new BytesRefBuilder();
        HashSet<String> actualStrings = new HashSet<String>();
        for (IntsRef ir : actualStringPaths) {
            actualStrings.add(Util.toBytesRef((IntsRef)ir, (BytesRefBuilder)scratchBytesRefBuilder).utf8ToString().replace('\u001f', ' '));
        }
        for (String s : actualStrings) {
            BaseTokenStreamTestCase.assertTrue((String)("Analyzer created unexpected string path: " + s + "\nexpected:\n" + BaseTokenStreamTestCase.toString(expectedStringsSet) + "\nactual:\n" + BaseTokenStreamTestCase.toString(actualStrings)), (boolean)expectedStringsSet.contains(s));
        }
        for (Iterator<Object> iterator : expectedStrings) {
            BaseTokenStreamTestCase.assertTrue((String)("Analyzer created unexpected string path: " + iterator + "\nexpected:\n" + BaseTokenStreamTestCase.toString(expectedStringsSet) + "\nactual:\n" + BaseTokenStreamTestCase.toString(actualStrings)), (boolean)actualStrings.contains(iterator));
        }
    }

    public static Set<String> getGraphStrings(Analyzer analyzer, String text) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream("dummy", text);){
            Set<String> set = BaseTokenStreamTestCase.getGraphStrings(tokenStream);
            return set;
        }
    }

    public static Set<String> getGraphStrings(TokenStream tokenStream) throws IOException {
        Automaton automaton = new TokenStreamToAutomaton().toAutomaton(tokenStream);
        Set<IntsRef> actualStringPaths = AutomatonTestUtil.getFiniteStringsRecursive(automaton, -1);
        BytesRefBuilder scratchBytesRefBuilder = new BytesRefBuilder();
        HashSet<String> paths = new HashSet<String>();
        for (IntsRef ir : actualStringPaths) {
            paths.add(Util.toBytesRef((IntsRef)ir, (BytesRefBuilder)scratchBytesRefBuilder).utf8ToString().replace('\u001f', ' '));
        }
        return paths;
    }

    public static String toString(Analyzer analyzer, String text) throws IOException {
        try (TokenStream ts = analyzer.tokenStream("field", text);){
            StringBuilder b = new StringBuilder();
            CharTermAttribute termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
            PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)ts.getAttribute(PositionLengthAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
            BaseTokenStreamTestCase.assertNotNull((Object)offsetAtt);
            ts.reset();
            int pos = -1;
            while (ts.incrementToken()) {
                b.append((CharSequence)termAtt);
                b.append(" at pos=");
                b.append(pos += posIncAtt.getPositionIncrement());
                if (posLengthAtt != null) {
                    b.append(" to pos=");
                    b.append(pos + posLengthAtt.getPositionLength());
                }
                b.append(" offsets=");
                b.append(offsetAtt.startOffset());
                b.append('-');
                b.append(offsetAtt.endOffset());
                b.append('\n');
            }
            ts.end();
            String string = b.toString();
            return string;
        }
    }

    public static interface CheckClearAttributesAttribute
    extends Attribute {
        public boolean getAndResetClearCalled();
    }

    static class AnalysisThread
    extends Thread {
        final int iterations;
        final int maxWordLength;
        final long seed;
        final Analyzer a;
        final boolean useCharFilter;
        final boolean simple;
        final boolean graphOffsetsAreCorrect;
        final RandomIndexWriter iw;
        final CountDownLatch latch;
        public boolean failed;

        AnalysisThread(long seed, CountDownLatch latch, Analyzer a, int iterations, int maxWordLength, boolean useCharFilter, boolean simple, boolean graphOffsetsAreCorrect, RandomIndexWriter iw) {
            this.seed = seed;
            this.a = a;
            this.iterations = iterations;
            this.maxWordLength = maxWordLength;
            this.useCharFilter = useCharFilter;
            this.simple = simple;
            this.graphOffsetsAreCorrect = graphOffsetsAreCorrect;
            this.iw = iw;
            this.latch = latch;
        }

        @Override
        public void run() {
            boolean success = false;
            try {
                this.latch.await();
                BaseTokenStreamTestCase.checkRandomData(new Random(this.seed), this.a, this.iterations, this.maxWordLength, this.useCharFilter, this.simple, this.graphOffsetsAreCorrect, this.iw);
                success = true;
                this.failed = !success;
            }
            catch (Exception e) {
                try {
                    Rethrow.rethrow(e);
                    this.failed = !success;
                }
                catch (Throwable throwable) {
                    this.failed = !success;
                    throw throwable;
                }
            }
        }
    }

    public static final class CheckClearAttributesAttributeImpl
    extends AttributeImpl
    implements CheckClearAttributesAttribute {
        private boolean clearCalled = false;

        @Override
        public boolean getAndResetClearCalled() {
            try {
                boolean bl = this.clearCalled;
                return bl;
            }
            finally {
                this.clearCalled = false;
            }
        }

        public void clear() {
            this.clearCalled = true;
        }

        public boolean equals(Object other) {
            return other instanceof CheckClearAttributesAttributeImpl && ((CheckClearAttributesAttributeImpl)other).clearCalled == this.clearCalled;
        }

        public int hashCode() {
            return 0x489C2FD ^ Boolean.valueOf(this.clearCalled).hashCode();
        }

        public void copyTo(AttributeImpl target) {
            target.clear();
        }

        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(CheckClearAttributesAttribute.class, "clearCalled", (Object)this.clearCalled);
        }
    }
}

