/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.monitor.QueryIndex;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;

class TermsHashBuilder
extends SearcherFactory {
    private final Map<IndexReader.CacheKey, QueryIndex.QueryTermFilter> termFilters;

    TermsHashBuilder(Map<IndexReader.CacheKey, QueryIndex.QueryTermFilter> termFilters) {
        this.termFilters = termFilters;
    }

    public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
        IndexSearcher searcher = super.newSearcher(reader, previousReader);
        searcher.setQueryCache(null);
        this.termFilters.put(reader.getReaderCacheHelper().getKey(), new QueryIndex.QueryTermFilter(reader));
        reader.getReaderCacheHelper().addClosedListener(this.termFilters::remove);
        return searcher;
    }
}

