/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.server.quorum;

import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServer;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServerBean;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.Follower;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.FollowerMXBean;

public class FollowerBean
extends ZooKeeperServerBean
implements FollowerMXBean {
    private final Follower follower;

    public FollowerBean(Follower follower, ZooKeeperServer zks) {
        super(zks);
        this.follower = follower;
    }

    @Override
    public String getName() {
        return "Follower";
    }

    @Override
    public String getQuorumAddress() {
        return this.follower.sock.toString();
    }

    @Override
    public String getLastQueuedZxid() {
        return "0x" + Long.toHexString(this.follower.getLastQueued());
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.follower.getPendingRevalidationsCount();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.follower.self.getElectionTimeTaken();
    }
}

