/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.spi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.kyuubi.shade.dev.failsafe.ExecutionContext;
import org.apache.kyuubi.shade.dev.failsafe.Policy;
import org.apache.kyuubi.shade.dev.failsafe.internal.EventHandler;
import org.apache.kyuubi.shade.dev.failsafe.spi.AsyncExecutionInternal;
import org.apache.kyuubi.shade.dev.failsafe.spi.ExecutionInternal;
import org.apache.kyuubi.shade.dev.failsafe.spi.ExecutionResult;
import org.apache.kyuubi.shade.dev.failsafe.spi.FailsafeFuture;
import org.apache.kyuubi.shade.dev.failsafe.spi.FailurePolicy;
import org.apache.kyuubi.shade.dev.failsafe.spi.Scheduler;
import org.apache.kyuubi.shade.dev.failsafe.spi.SyncExecutionInternal;

public abstract class PolicyExecutor<R> {
    private final int policyIndex;
    private final FailurePolicy<R> failurePolicy;
    private final EventHandler<R> successHandler;
    private final EventHandler<R> failureHandler;

    protected PolicyExecutor(Policy<R> policy, int policyIndex) {
        this.policyIndex = policyIndex;
        this.failurePolicy = policy instanceof FailurePolicy ? (FailurePolicy)policy : null;
        this.successHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getSuccessListener());
        this.failureHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getFailureListener());
    }

    public int getPolicyIndex() {
        return this.policyIndex;
    }

    protected ExecutionResult<R> preExecute() {
        return null;
    }

    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        ExecutionResult<R> result = this.preExecute();
        return result == null ? null : CompletableFuture.completedFuture(result);
    }

    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ExecutionResult<R> result = this.preExecute();
            if (result != null) {
                execution.preExecute();
                return result;
            }
            return this.postExecute((ExecutionInternal<R>)execution, (ExecutionResult)innerFn.apply((SyncExecutionInternal<R>)execution));
        };
    }

    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> {
            CompletableFuture<ExecutionResult<R>> preResult;
            CompletableFuture promise = new CompletableFuture();
            Runnable runnable = () -> ((CompletableFuture)((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).thenCompose(r -> r == null ? ExecutionResult.nullFuture() : this.postExecuteAsync((AsyncExecutionInternal<R>)execution, (ExecutionResult<R>)r, scheduler, future))).whenComplete((postResult, postError) -> {
                if (postError != null) {
                    promise.completeExceptionally((Throwable)postError);
                } else {
                    promise.complete(postResult);
                }
            });
            if (!execution.isRecorded() && (preResult = this.preExecuteAsync(scheduler, future)) != null) {
                preResult.whenComplete((result, error) -> {
                    if (error != null) {
                        promise.completeExceptionally((Throwable)error);
                    } else if (result != null) {
                        if (result.isNonResult()) {
                            runnable.run();
                        } else {
                            execution.preExecute();
                            promise.complete(result);
                        }
                    } else {
                        promise.complete(null);
                    }
                });
                return promise;
            }
            runnable.run();
            return promise;
        };
    }

    public ExecutionResult<R> postExecute(ExecutionInternal<R> execution, ExecutionResult<R> result) {
        execution.recordAttempt();
        if (this.isFailure(result)) {
            result = this.onFailure(execution, result.withException());
            this.handleFailure(result, execution);
        } else {
            result = result.withSuccess();
            this.onSuccess(result);
            this.handleSuccess(result, execution);
        }
        return result;
    }

    protected synchronized CompletableFuture<ExecutionResult<R>> postExecuteAsync(AsyncExecutionInternal<R> execution, ExecutionResult<R> result, Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture<ExecutionResult<R>> postFuture = null;
        if (!execution.isAsyncExecution() || !execution.isPostExecuted(this.policyIndex)) {
            execution.recordAttempt();
            if (this.isFailure(result)) {
                postFuture = this.onFailureAsync(execution, result.withException(), scheduler, future).whenComplete((postResult, error) -> this.handleFailure((ExecutionResult<R>)postResult, execution));
            } else {
                result = result.withSuccess();
                this.onSuccess(result);
                this.handleSuccess(result, execution);
                postFuture = CompletableFuture.completedFuture(result);
            }
            if (execution.isAsyncExecution()) {
                execution.setPostExecuted(this.policyIndex);
            }
        }
        return postFuture;
    }

    protected boolean isFailure(ExecutionResult<R> result) {
        if (result.isNonResult()) {
            return false;
        }
        if (this.failurePolicy != null) {
            return this.failurePolicy.isFailure(result.getResult(), result.getException());
        }
        return result.getException() != null;
    }

    protected void onSuccess(ExecutionResult<R> result) {
    }

    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result) {
        return result;
    }

    protected CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> context, ExecutionResult<R> result, Scheduler scheduler, FailsafeFuture<R> future) {
        try {
            return CompletableFuture.completedFuture(this.onFailure(context, result));
        }
        catch (Throwable t) {
            CompletableFuture<ExecutionResult<R>> r = new CompletableFuture<ExecutionResult<R>>();
            r.completeExceptionally(t);
            return r;
        }
    }

    private void handleSuccess(ExecutionResult<R> result, ExecutionContext<R> context) {
        if (this.successHandler != null && result.isComplete()) {
            this.successHandler.handle(result, context);
        }
    }

    private void handleFailure(ExecutionResult<R> result, ExecutionContext<R> context) {
        if (this.failureHandler != null && result.isComplete()) {
            this.failureHandler.handle(result, context);
        }
    }
}

