/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.model.AbstractModelProposer;
import org.apache.kylin.rec.model.GreedyModelTreesBuilder;
import org.apache.kylin.rec.model.ModelTree;
import org.apache.kylin.rec.util.TableAliasGenerator;

public class JoinProposer
extends AbstractModelProposer {
    public JoinProposer(AbstractContext.ModelContext modelContext) {
        super(modelContext);
    }

    @Override
    public void execute(NDataModel modelDesc) {
        ModelTree modelTree = this.modelContext.getModelTree();
        HashMap<String, JoinTableDesc> joinTables = new HashMap<String, JoinTableDesc>();
        TableAliasGenerator.TableAliasDict dict = TableAliasGenerator.generateCommonDictForSpecificModel(this.project);
        Map<TableRef, String> uniqueTblAliasMap = GreedyModelTreesBuilder.TreeBuilder.getUniqueTblAliasBasedOnPosInGraph(modelDesc.getJoinsGraph(), dict);
        for (OlapContext olapContext : modelTree.getOlapContexts()) {
            if (olapContext == null || olapContext.getJoins().isEmpty() || !this.isValidOlapContext(olapContext)) continue;
            uniqueTblAliasMap.putAll(GreedyModelTreesBuilder.TreeBuilder.getUniqueTblAliasBasedOnPosInGraph(olapContext, dict));
        }
        HashMap originTblRefAlias = Maps.newHashMap();
        for (JoinTableDesc joinTable : modelDesc.getJoinTables()) {
            joinTables.put(joinTable.getAlias(), joinTable);
            originTblRefAlias.put(modelDesc.findTable(joinTable.getAlias()), joinTable.getAlias());
        }
        Map<TableRef, String> map = GreedyModelTreesBuilder.TreeBuilder.correctTblAliasAndKeepOriginAlias(uniqueTblAliasMap, modelDesc.getRootFactTable().getTableDesc(), originTblRefAlias);
        HashMap aliasRefMap = Maps.newHashMap();
        for (OlapContext ctx : modelTree.getOlapContexts()) {
            if (ctx == null || ctx.getJoins().isEmpty() || !this.isValidOlapContext(ctx)) continue;
            try {
                HashMap<String, JoinTableDesc> tmpJoinTablesMap = new HashMap<String, JoinTableDesc>();
                GreedyModelTreesBuilder.TreeBuilder.mergeContext(ctx, tmpJoinTablesMap, map, aliasRefMap);
                tmpJoinTablesMap.forEach((alias, joinTableDesc) -> {
                    JoinTableDesc oldJoinTable = (JoinTableDesc)joinTables.get(alias);
                    if (oldJoinTable != null) {
                        String flattenable = oldJoinTable.getFlattenable();
                        joinTableDesc.setFlattenable(flattenable);
                        joinTableDesc.getJoin().setType(oldJoinTable.getJoin().getType());
                    }
                });
                joinTables.putAll(tmpJoinTablesMap);
            }
            catch (Exception e) {
                Map<String, AccelerateInfo> accelerateInfoMap = this.modelContext.getProposeContext().getAccelerateInfoMap();
                accelerateInfoMap.get(ctx.getSql()).setFailedCause(e);
            }
        }
        modelDesc.setJoinTables(new ArrayList(joinTables.values()));
    }
}

