/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.table.InternalTableDesc;

public class InternalTableManager {
    private CachedCrudAssist<InternalTableDesc> internalTableCrud;
    private final KylinConfig config;
    private final String project;
    private ResourceStore resourceStore;

    public static InternalTableManager getInstance(KylinConfig config, String project) {
        return (InternalTableManager)config.getManager(project, InternalTableManager.class);
    }

    static InternalTableManager newInstance(KylinConfig config, String project) {
        return new InternalTableManager(config, project);
    }

    private InternalTableManager(KylinConfig config, String project) {
        this.config = config;
        this.project = project;
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        this.initInternalTableCrud();
    }

    private void initInternalTableCrud() {
        this.internalTableCrud = new CachedCrudAssist<InternalTableDesc>(this.resourceStore, MetadataType.INTERNAL_TABLE, this.project, InternalTableDesc.class){

            @Override
            protected InternalTableDesc initEntityAfterReload(InternalTableDesc entity, String resourceName) {
                entity.init(InternalTableManager.this.project);
                return entity;
            }
        };
    }

    public List<InternalTableDesc> listAllTables() {
        return this.internalTableCrud.listAll();
    }

    public Map<String, List<InternalTableDesc>> listTablesGroupBySchema() {
        return this.listAllTables().stream().collect(Collectors.groupingBy(ATable::getDatabase));
    }

    public InternalTableDesc getInternalTableDesc(String identity) {
        if (StringUtils.isEmpty((CharSequence)identity)) {
            return null;
        }
        return this.internalTableCrud.get(InternalTableDesc.generateResourceName(this.project, identity));
    }

    public void saveOrUpdateInternalTable(InternalTableDesc internalTableDesc) {
        if (this.internalTableCrud.contains(internalTableDesc.resourceName())) {
            this.updateInternalTable(internalTableDesc.getIdentity(), arg_0 -> ((InternalTableDesc)internalTableDesc).copyPropertiesTo(arg_0));
        } else {
            this.createInternalTable(internalTableDesc);
        }
    }

    public void updateInternalTable(String identity, InternalTableDescUpdater updater) {
        InternalTableDesc cached = this.getInternalTableDesc(identity);
        if (cached == null) {
            throw new IllegalArgumentException("Internal table " + identity + " not found");
        }
        InternalTableDesc copy = this.copyForWrite(cached);
        updater.modify(copy);
        copy.init(this.project);
        this.internalTableCrud.save(copy);
    }

    public void removeInternalTable(String tableIdentity) {
        InternalTableDesc t = this.getInternalTableDesc(tableIdentity);
        if (t == null) {
            return;
        }
        this.internalTableCrud.delete(t);
    }

    public void createInternalTable(InternalTableDesc table) {
        table.init(this.project);
        InternalTableDesc copy = this.copyForWrite(table);
        this.internalTableCrud.save(copy);
    }

    public InternalTableDesc copyForWrite(InternalTableDesc table) {
        if (table.getProject() == null) {
            table.setProject(this.project);
        }
        return this.internalTableCrud.copyForWrite(table);
    }

    public void invalidCache(String resourceName) {
        this.internalTableCrud.invalidateCache(resourceName);
    }

    public List<InternalTableDesc> getInternalTableDescInfos(String databaseName, String tableName, boolean isFuzzy) {
        RawResourceFilter combinedFilter = new RawResourceFilter();
        if (!StringUtils.isBlank((CharSequence)databaseName)) {
            if (isFuzzy) {
                combinedFilter.addConditions("dbName", Collections.singletonList(databaseName), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
            } else {
                combinedFilter.addConditions("dbName", Collections.singletonList(databaseName), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
            }
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            if (isFuzzy) {
                combinedFilter.addConditions("name", Collections.singletonList(tableName), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
            } else {
                combinedFilter.addConditions("name", Collections.singletonList(tableName), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
            }
        }
        return this.internalTableCrud.listByFilter(combinedFilter).stream().distinct().collect(Collectors.toList());
    }

    public static interface InternalTableDescUpdater {
        public void modify(InternalTableDesc var1);
    }
}

