/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util.scd2;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlKind;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TableRef;

public class SCD2SqlConverter {
    public static final SCD2SqlConverter INSTANCE = new SCD2SqlConverter();

    public String genSCD2SqlStr(JoinDesc joinDesc, List<NonEquiJoinCondition.SimplifiedJoinCondition> simplifiedNonEquiJoinConditions) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.toJoinDescQuotedString(joinDesc)).append(" " + SqlKind.AND.sql + " " + this.genNonEquiWithSimplified(simplifiedNonEquiJoinConditions));
        return sb.toString();
    }

    private String quotedIdentifierStr(String identifier) {
        return Quoting.DOUBLE_QUOTE.string + identifier + Quoting.DOUBLE_QUOTE.string;
    }

    private String quotedTableRefStr(TableRef tableRef) {
        return this.quotedIdentifierStr(tableRef.getTableDesc().getDatabase()) + "." + this.quotedIdentifierStr(tableRef.getTableDesc().getName());
    }

    private String quotedColumnStr(String colStr) {
        String[] cols = StringSplitter.split((String)colStr, (String)".");
        return this.quotedIdentifierStr(cols[0]) + "." + this.quotedIdentifierStr(cols[1]);
    }

    private String genNonEquiWithSimplified(List<NonEquiJoinCondition.SimplifiedJoinCondition> simplified) {
        return simplified.stream().map(simplifiedNonEquiJoinCondition -> "(" + this.quotedColumnStr(simplifiedNonEquiJoinCondition.getForeignKey()) + simplifiedNonEquiJoinCondition.getOp().sql + this.quotedColumnStr(simplifiedNonEquiJoinCondition.getPrimaryKey()) + ")").collect(Collectors.joining(" " + SqlKind.AND.sql + " "));
    }

    private String toJoinDescQuotedString(JoinDesc join) {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.quotedTableRefStr(join.getFKSide())).append(" AS ").append(this.quotedIdentifierStr(join.getFKSide().getAlias())).append(" ").append(join.getType()).append(" JOIN ").append(this.quotedTableRefStr(join.getPKSide())).append(" AS ").append(this.quotedIdentifierStr(join.getPKSide().getAlias())).append(" ON ");
        for (int i = 0; i < join.getForeignKey().length; ++i) {
            String fk = this.quotedColumnStr(join.getForeignKey()[i]);
            String pk = this.quotedColumnStr(join.getPrimaryKey()[i]);
            if (i > 0) {
                result.append(" " + SqlKind.AND.sql + " ");
            }
            result.append(fk).append("=").append(pk);
        }
        return result.toString();
    }
}

