/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.insensitive;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.insensitive.InsensitiveRequest;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ModelInsensitiveRequest
extends InsensitiveRequest {
    @Override
    default public List<String> inSensitiveFields() {
        return Collections.singletonList("alias");
    }

    @Override
    default public void updateField() {
        for (String fieldName : this.inSensitiveFields()) {
            Field field = this.getDeclaredField(this.getClass(), fieldName);
            if (field == null) {
                return;
            }
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            try {
                NProjectManager projectManager;
                ProjectInstance projectInstance;
                Field projectField;
                String modelAlias = (String)field.get(this);
                if (StringUtils.isEmpty((CharSequence)modelAlias) || (projectField = this.getDeclaredField(this.getClass(), "project")) == null) continue;
                Unsafe.changeAccessibleObject((AccessibleObject)projectField, (boolean)true);
                String projectName = (String)projectField.get(this);
                if (StringUtils.isEmpty((CharSequence)projectName) || (projectInstance = (projectManager = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv())).getProject(projectName)) == null) continue;
                projectName = projectInstance.getName();
                projectField.set(this, projectName);
                modelAlias = this.getDataModelAlias(modelAlias, projectName);
                field.set(this, modelAlias);
            }
            catch (IllegalAccessException e) {
                LogHolder.log.warn("update model name failed ", (Throwable)e);
            }
        }
    }

    default public String getDataModelAlias(String modelAlias, String projectName) {
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), projectName);
        NDataModel dataModel = modelManager.getDataModelDescByAlias(modelAlias);
        if (dataModel != null) {
            return dataModel.getAlias();
        }
        return modelAlias;
    }

    public static final class LogHolder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(LogHolder.class);
    }
}

