/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.utils;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.PersistException;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingUtils.class);
    private static int MAX_RETRY = 3;

    public static Set<LayoutEntity> getToBuildLayouts(NDataflow df) {
        HashSet layouts = Sets.newHashSet();
        Segments<NDataSegment> readySegments = df.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        if (CollectionUtils.isEmpty(readySegments)) {
            if (CollectionUtils.isNotEmpty(df.getIndexPlan().getAllIndexes())) {
                layouts.addAll(df.getIndexPlan().getAllLayouts());
            }
            log.trace("added {} layouts according to model {}'s index plan", (Object)layouts.size(), (Object)df.getIndexPlan().getModel().getAlias());
        } else {
            NDataSegment latestReadySegment = readySegments.getLatestReadySegment();
            for (Map.Entry<Long, NDataLayout> cuboid : latestReadySegment.getLayoutsMap().entrySet()) {
                layouts.add(cuboid.getValue().getLayout());
            }
            log.trace("added {} layouts according to model {}'s latest ready segment {}", new Object[]{layouts.size(), df.getIndexPlan().getModel().getAlias(), latestReadySegment.getName()});
        }
        return layouts;
    }

    public static String getJobId(String modelId, String jobType) {
        return modelId + "_" + jobType.toLowerCase(Locale.ROOT).substring(10);
    }

    public static String getModelId(String jobId) {
        return jobId.substring(0, jobId.lastIndexOf("_"));
    }

    public static String parseStreamingDuration(String duration) {
        if (duration == null || "".equals(duration.trim())) {
            return "30";
        }
        return duration;
    }

    public static Long parseSize(String inputSize) {
        if (inputSize == null || "".equals(inputSize.trim())) {
            inputSize = "32m";
        }
        long size = 0L;
        size = inputSize.endsWith("b") ? Long.parseLong(inputSize.substring(0, inputSize.length() - 2)) : Long.parseLong(inputSize.substring(0, inputSize.length() - 1));
        if (inputSize.endsWith("k") || inputSize.endsWith("kb")) {
            return size * 1024L;
        }
        if (inputSize.endsWith("m") || inputSize.endsWith("mb")) {
            return size * 1024L * 1024L;
        }
        if (inputSize.endsWith("g") || inputSize.endsWith("gb")) {
            return size * 1024L * 1024L * 1024L;
        }
        throw new IllegalArgumentException("Size unit must be k/kb, m/mb or g/gb...");
    }

    public static Long parseTableRefreshInterval(String inputInterval) {
        if (inputInterval == null || "".equals(inputInterval.trim())) {
            return TimeUtil.timeStringAs((String)"-1m", (TimeUnit)TimeUnit.MINUTES);
        }
        if (inputInterval.endsWith("m")) {
            return TimeUtil.timeStringAs((String)inputInterval, (TimeUnit)TimeUnit.MINUTES);
        }
        if (inputInterval.endsWith("h")) {
            return 60L * TimeUtil.timeStringAs((String)inputInterval, (TimeUnit)TimeUnit.HOURS);
        }
        if (inputInterval.endsWith("d")) {
            return 1440L * TimeUtil.timeStringAs((String)inputInterval, (TimeUnit)TimeUnit.DAYS);
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.STREAMING_TABLE_REFRESH_INTERVAL_UNIT_ERROR, new Object[0]);
    }

    public static boolean isLocalMode() {
        return "true".equals(System.getProperty("streaming.local"));
    }

    public static void replayAuditlog() {
        int retry = 0;
        Exception err = new Exception("catch error");
        while (retry++ < MAX_RETRY) {
            KylinConfig conf = KylinConfig.getInstanceFromEnv();
            try {
                ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)conf);
                AuditLogStore auditLogStore = store.getAuditLogStore();
                if (auditLogStore instanceof JdbcAuditLogStore) {
                    ((JdbcAuditLogStore)auditLogStore).catchupWithMaxTimeout();
                } else {
                    auditLogStore.catchupWithTimeout();
                }
                return;
            }
            catch (Exception e) {
                err = e;
                log.warn("catch error, begin to retry");
            }
        }
        throw new PersistException(err.getMessage(), (Throwable)err);
    }

    public static String getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }

    public static boolean isJobOnCluster(KylinConfig config) {
        return !StreamingUtils.isLocalMode() && !config.isUTEnv();
    }

    public static void sleep(long times) {
        try {
            Thread.sleep(times);
        }
        catch (InterruptedException e) {
            log.error("Thread is interrupted while sleeping");
            Thread.currentThread().interrupt();
        }
    }
}

