/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLenHexDimEnc
extends DimensionEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(FixedLenHexDimEnc.class);
    public static byte[] dict = new byte[256];
    public static byte[] revdict = new byte[16];
    public static final byte ROWKEY_PLACE_HOLDER_BYTE = 0;
    public static final String ENCODING_NAME = "fixed_length_hex";
    private int hexLength;
    private int bytelen;
    private transient int avoidVerbose = 0;
    private transient int avoidVerbose2 = 0;

    public FixedLenHexDimEnc() {
    }

    public FixedLenHexDimEnc(int len) {
        if (len < 1) {
            throw new IllegalArgumentException("len has to be positive: " + len);
        }
        this.hexLength = len;
        this.bytelen = (this.hexLength + 1) / 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedLenHexDimEnc that = (FixedLenHexDimEnc)o;
        return this.hexLength == that.hexLength;
    }

    public int hashCode() {
        return this.hexLength;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.bytelen;
    }

    @Override
    public void encode(String valueStr, byte[] output, int outputOffset) {
        if (valueStr == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.bytelen, (byte)-1);
            return;
        }
        byte[] value = Bytes.toBytes((String)valueStr);
        int valueLen = value.length;
        int endOffset = outputOffset + this.bytelen;
        if (valueLen > this.hexLength && this.avoidVerbose++ % 10000 == 0) {
            logger.warn("Expect at most " + this.hexLength + " bytes, but got " + valueLen + ", will truncate, value string: " + Bytes.toString((byte[])value, (int)0, (int)valueLen) + " times:" + this.avoidVerbose);
        }
        if (valueLen >= this.hexLength && this.isF(value, 0, this.hexLength) && this.avoidVerbose2++ % 10000 == 0) {
            logger.warn("All 'F' value: " + Bytes.toString((byte[])value, (int)0, (int)valueLen) + "will become null after encode/decode. times:" + this.avoidVerbose);
        }
        int n = Math.min(valueLen, this.hexLength);
        for (int i = 0; i < n; i += 2) {
            int temp = 0;
            byte iCode = dict[value[i]];
            temp = (byte)(temp | iCode << 4);
            int j = i + 1;
            if (j < n) {
                byte jCode = dict[value[j]];
                temp = (byte)(temp | jCode);
            }
            output[outputOffset++] = temp;
        }
        Arrays.fill(output, outputOffset, endOffset, (byte)0);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        Preconditions.checkArgument((len == this.bytelen ? 1 : 0) != 0, (Object)("len " + len + " not equals " + this.bytelen));
        if (FixedLenHexDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        byte[] ret = new byte[this.hexLength];
        for (int i = 0; i < ret.length; i += 2) {
            byte temp = bytes[i / 2];
            ret[i] = revdict[(temp & 0xF0) >>> 4];
            int j = i + 1;
            if (j >= this.hexLength) continue;
            ret[j] = revdict[temp & 0xF];
        }
        return Bytes.toString((byte[])ret, (int)0, (int)ret.length);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new FixedLenSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.hexLength);
        out.writeShort(this.bytelen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hexLength = in.readShort();
        this.bytelen = in.readShort();
    }

    private boolean isF(byte[] value, int offset, int length) {
        for (int i = offset; i < length + offset; ++i) {
            if (value[i] == 70) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < dict.length; ++i) {
            FixedLenHexDimEnc.dict[i] = -1;
        }
        FixedLenHexDimEnc.dict[48] = 0;
        FixedLenHexDimEnc.dict[49] = 1;
        FixedLenHexDimEnc.dict[50] = 2;
        FixedLenHexDimEnc.dict[51] = 3;
        FixedLenHexDimEnc.dict[52] = 4;
        FixedLenHexDimEnc.dict[53] = 5;
        FixedLenHexDimEnc.dict[54] = 6;
        FixedLenHexDimEnc.dict[55] = 7;
        FixedLenHexDimEnc.dict[56] = 8;
        FixedLenHexDimEnc.dict[57] = 9;
        FixedLenHexDimEnc.dict[65] = 10;
        FixedLenHexDimEnc.dict[66] = 11;
        FixedLenHexDimEnc.dict[67] = 12;
        FixedLenHexDimEnc.dict[68] = 13;
        FixedLenHexDimEnc.dict[69] = 14;
        FixedLenHexDimEnc.dict[70] = 15;
        FixedLenHexDimEnc.dict[97] = 10;
        FixedLenHexDimEnc.dict[98] = 11;
        FixedLenHexDimEnc.dict[99] = 12;
        FixedLenHexDimEnc.dict[100] = 13;
        FixedLenHexDimEnc.dict[101] = 14;
        FixedLenHexDimEnc.dict[102] = 15;
        FixedLenHexDimEnc.revdict[0] = 48;
        FixedLenHexDimEnc.revdict[1] = 49;
        FixedLenHexDimEnc.revdict[2] = 50;
        FixedLenHexDimEnc.revdict[3] = 51;
        FixedLenHexDimEnc.revdict[4] = 52;
        FixedLenHexDimEnc.revdict[5] = 53;
        FixedLenHexDimEnc.revdict[6] = 54;
        FixedLenHexDimEnc.revdict[7] = 55;
        FixedLenHexDimEnc.revdict[8] = 56;
        FixedLenHexDimEnc.revdict[9] = 57;
        FixedLenHexDimEnc.revdict[10] = 65;
        FixedLenHexDimEnc.revdict[11] = 66;
        FixedLenHexDimEnc.revdict[12] = 67;
        FixedLenHexDimEnc.revdict[13] = 68;
        FixedLenHexDimEnc.revdict[14] = 69;
        FixedLenHexDimEnc.revdict[15] = 70;
    }

    public class FixedLenSerializer
    extends DataTypeSerializer<Object> {
        private byte[] currentBuf() {
            byte[] buf = (byte[])this.current.get();
            if (buf == null) {
                buf = new byte[FixedLenHexDimEnc.this.bytelen];
                this.current.set(buf);
            }
            return buf;
        }

        public void serialize(Object value, ByteBuffer out) {
            byte[] buf = this.currentBuf();
            String str = value == null ? null : value.toString();
            FixedLenHexDimEnc.this.encode(str, buf, 0);
            out.put(buf);
        }

        public Object deserialize(ByteBuffer in) {
            byte[] buf = this.currentBuf();
            in.get(buf);
            return FixedLenHexDimEnc.this.decode(buf, 0, buf.length);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return FixedLenHexDimEnc.this.bytelen;
        }

        @Override
        public int maxLength() {
            return FixedLenHexDimEnc.this.bytelen;
        }

        @Override
        public int getStorageBytesEstimate() {
            return FixedLenHexDimEnc.this.bytelen;
        }

        @Override
        public Object valueOf(String str) {
            return str;
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return FixedLenHexDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new FixedLenHexDimEnc(Integer.parseInt(args[0]));
        }
    }
}

