/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.runners;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.runners.JobCheckUtil;
import org.apache.kylin.job.scheduler.JdbcJobScheduler;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCheckRunner
implements Runnable {
    private JobContext jobContext;
    private static final Logger logger = LoggerFactory.getLogger(JobCheckRunner.class);

    public JobCheckRunner(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    private boolean discardTimeoutJob(String jobId, String project, Long startTime) {
        Integer timeOutMinute = KylinConfig.getInstanceFromEnv().getSchedulerJobTimeOutMinute();
        if (timeOutMinute == 0) {
            return false;
        }
        try {
            if (this.checkTimeoutIfNeeded(jobId, project, startTime, timeOutMinute)) {
                logger.error("project {} job {} running timeout.", (Object)project, (Object)jobId);
                return (Boolean)JobContextUtil.withTxAndRetry(() -> {
                    ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project).errorJob(jobId);
                    return true;
                });
            }
            return false;
        }
        catch (Exception e) {
            logger.warn("[UNEXPECTED_THINGS_HAPPENED] project " + project + " job " + jobId + " should be timeout but discard failed", (Throwable)e);
            return false;
        }
    }

    private boolean checkTimeoutIfNeeded(String jobId, String project, Long startTime, Integer timeOutMinute) {
        long duration = System.currentTimeMillis() - startTime;
        long durationMins = Math.toIntExact(duration / 60000L);
        if (durationMins >= (long)timeOutMinute.intValue()) {
            ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
            AbstractExecutable jobExecutable = executableManager.getJob(jobId);
            ExecutableState status = jobExecutable.getStatus();
            return !status.isNotProgressing() && !status.isFinalState();
        }
        return false;
    }

    @Override
    public void run() {
        logger.info("Start check job pool.");
        JdbcJobScheduler jdbcJobScheduler = this.jobContext.getJobScheduler();
        Map<String, Pair<AbstractJobExecutable, Long>> runningJobs = jdbcJobScheduler.getRunningJob();
        for (Map.Entry<String, Pair<AbstractJobExecutable, Long>> entry : runningJobs.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warn("Job check thread {} is interrupted.", (Object)Thread.currentThread().getName());
                return;
            }
            String jobId = entry.getKey();
            AbstractJobExecutable jobExecutable = (AbstractJobExecutable)entry.getValue().getFirst();
            long startTime = (Long)entry.getValue().getSecond();
            String project = jobExecutable.getProject();
            if (JobCheckRunner.markSuicideJobWithTransaction((AbstractExecutable)jobExecutable, project)) {
                logger.info("suicide job = {} on checker runner", (Object)jobId);
                continue;
            }
            if (this.discardTimeoutJob(jobId, project, startTime)) {
                logger.info("discardTimeoutJob job = {} on checker runner", (Object)jobId);
                continue;
            }
            if (!this.stopJobIfStorageQuotaLimitReached(this.jobContext, jobId, project)) continue;
            logger.info("stopJobIfStorageQuotaLimitReached job = {} on checker runner", (Object)jobId);
        }
        this.markSuicideForErrorOrPausedJobs();
    }

    private static boolean markSuicideJobWithTransaction(AbstractExecutable jobExecutable, String project) {
        return (Boolean)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> JobCheckUtil.markSuicideJob(jobExecutable), (String)project);
    }

    private void markSuicideForErrorOrPausedJobs() {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setStatuses(Lists.newArrayList((Object[])new ExecutableState[]{ExecutableState.ERROR, ExecutableState.PAUSED}));
        jobMapperFilter.setLimit(10);
        jobMapperFilter.setOffset(0);
        List<JobInfo> jobInfoList = this.jobContext.getJobInfoMapper().selectByJobFilter(jobMapperFilter);
        if (CollectionUtils.isEmpty(jobInfoList)) {
            return;
        }
        Collections.shuffle(jobInfoList);
        for (JobInfo jobInfo : jobInfoList) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warn("Job check thread {} is interrupted.", (Object)Thread.currentThread().getName());
                return;
            }
            if (!this.markSuicideJobWithTransaction(jobInfo)) continue;
            logger.info("suicide job = {} on checker runner", (Object)jobInfo.getJobId());
        }
    }

    private boolean markSuicideJobWithTransaction(JobInfo jobInfo) {
        return (Boolean)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> JobCheckUtil.markSuicideJob(jobInfo), (String)jobInfo.getProject());
    }

    private boolean stopJobIfStorageQuotaLimitReached(JobContext jobContext, String jobId, String project) {
        if (!KylinConfig.getInstanceFromEnv().isStorageQuotaEnabled()) {
            return false;
        }
        return JobCheckUtil.stopJobIfStorageQuotaLimitReached(jobContext, project, jobId);
    }
}

