/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum JobTypeEnum {
    INDEX_REFRESH("BUILD"),
    INDEX_MERGE("BUILD"),
    INDEX_BUILD("BUILD"),
    INC_BUILD("BUILD"),
    LAYOUT_DATA_OPTIMIZE("OTHER"),
    SUB_PARTITION_BUILD("BUILD"),
    SUB_PARTITION_REFRESH("BUILD"),
    INDEX_PLAN_OPT("REC"),
    SNAPSHOT_BUILD("SNAPSHOT"),
    SNAPSHOT_REFRESH("SNAPSHOT"),
    INTERNAL_TABLE_BUILD("INTERNAL"),
    INTERNAL_TABLE_REFRESH("INTERNAL"),
    INTERNAL_TABLE_DELETE_PARTITION("INTERNAL"),
    STREAMING_MERGE("STREAMING"),
    STREAMING_BUILD("STREAMING"),
    ASYNC_QUERY("ASYNC_QUERY"),
    TABLE_SAMPLING("OTHER"),
    STAGE("OTHER"),
    ROUTINE("CRON"),
    META("CRON"),
    SOURCE_USAGE("CRON"),
    AUTO_REFRESH("CRON"),
    SPRING_SESSION_CLEAN_EXPIRED("CRON");

    private final String category;
    public static final List<String> BUILD_JOB_TYPES;

    private JobTypeEnum(String category) {
        this.category = category;
    }

    public static List<JobTypeEnum> getJobTypeByCategory(String category) {
        return Arrays.stream(JobTypeEnum.values()).filter(e -> e.getCategory().equals(category)).collect(Collectors.toList());
    }

    public static JobTypeEnum getEnumByName(String name) {
        for (JobTypeEnum value : JobTypeEnum.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        return null;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    static {
        BUILD_JOB_TYPES = Arrays.stream(JobTypeEnum.values()).filter(e -> !e.getCategory().equals("CRON") && !e.getCategory().equals("ASYNC_QUERY")).map(Enum::name).collect(Collectors.toList());
    }

    public static class Category {
        public static final String BUILD = "BUILD";
        public static final String SNAPSHOT = "SNAPSHOT";
        public static final String INTERNAL = "INTERNAL";
        public static final String STREAMING = "STREAMING";
        public static final String ASYNC_QUERY = "ASYNC_QUERY";
        public static final String CRON = "CRON";
        public static final String OTHER = "OTHER";
        public static final String ALL = "ALL";
        public static final String REC = "REC";

        private Category() {
        }
    }
}

