/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.ModifyTableNameSqlVisitor;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.engine.spark.utils.ComputedColumnEvalUtil;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegmentManager;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.UpdateImpact;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.model.util.ExpandableMeasureUtil;
import org.apache.kylin.metadata.model.util.scd2.SCD2CondChecker;
import org.apache.kylin.metadata.model.util.scd2.SCD2SqlConverter;
import org.apache.kylin.metadata.model.util.scd2.Scd2Simplifier;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinDesc;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinTableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.SCD2SimplificationConvertUtil;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ModelSemanticHelper
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelSemanticHelper.class);
    private static final Logger logger = LoggerFactory.getLogger(ModelSemanticHelper.class);
    private final ExpandableMeasureUtil expandableMeasureUtil = new ExpandableMeasureUtil((model, ccDesc) -> {
        String ccExpression = PushDownUtil.massageComputedColumn((NDataModel)model, (String)model.getProject(), (ComputedColumnDesc)ccDesc, (QueryContext.AclInfo)AclPermissionUtil.createAclInfo((String)model.getProject(), (Set)this.getCurrentUserGroups()));
        ccDesc.setInnerExpression(ccExpression);
        ComputedColumnEvalUtil.evaluateExprAndType((NDataModel)model, (ComputedColumnDesc)ccDesc);
    });
    private final Function<List<NDataModel.NamedColumn>, Map<String, NDataModel.NamedColumn>> toExistMap = allCols -> allCols.stream().filter(NDataModel.NamedColumn::isExist).collect(Collectors.toMap(NDataModel.NamedColumn::getAliasDotColumn, Function.identity()));
    private final Function<List<NDataModel.Measure>, Map<SimplifiedMeasure, NDataModel.Measure>> toMeasureMap = allCols -> allCols.stream().filter(m -> !m.isTomb()).collect(Collectors.toMap(SimplifiedMeasure::fromMeasure, Function.identity(), (u, v) -> {
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_MEASURE_EXPRESSION, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateMeasureDefinition(), v.getName()));
    }));
    private final Function<List<NDataModel.NamedColumn>, Map<String, NDataModel.NamedColumn>> toDimensionMap = allCols -> allCols.stream().filter(NDataModel.NamedColumn::isDimension).collect(Collectors.toMap(NDataModel.NamedColumn::getAliasDotColumn, Function.identity()));

    public NDataModel deepCopyModel(NDataModel originModel) {
        NDataModel nDataModel;
        try {
            nDataModel = (NDataModel)JsonUtil.readValue((String)JsonUtil.writeValueAsIndentString((Object)originModel), NDataModel.class);
            nDataModel.setJoinTables(SCD2SimplificationConvertUtil.deepCopyJoinTables(originModel.getJoinTables()));
        }
        catch (IOException e) {
            ThreadUtil.warnKylinStackTrace((String)"Parse json failed...\n");
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_PARSE_JSON, (Throwable)e);
        }
        return nDataModel;
    }

    public NDataModel convertToDataModel(ModelRequest modelRequest) {
        NDataModel dataModel;
        List<SimplifiedMeasure> simplifiedMeasures = modelRequest.getSimplifiedMeasures();
        try {
            dataModel = (NDataModel)JsonUtil.deepCopy((Object)((Object)modelRequest), NDataModel.class);
            dataModel.setComputedColumnDescs(ComputedColumnUtil.deepCopy(modelRequest.getComputedColumnDescs()));
        }
        catch (IOException e) {
            ThreadUtil.warnKylinStackTrace((String)"Parse json failed...\n");
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_PARSE_JSON, (Throwable)e);
        }
        Map allTablesMap = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, modelRequest.getProject())).getAllTablesMap();
        List ccList = dataModel.getComputedColumnDescs();
        if (!ccList.isEmpty()) {
            String factTableIdentity = dataModel.getRootFactTableName();
            TableDesc tableDesc = (TableDesc)allTablesMap.get(factTableIdentity);
            TableDesc extendTable = tableDesc.appendColumns(ComputedColumnUtil.createComputedColumns((List)ccList, (TableDesc)tableDesc), true);
            allTablesMap.put(factTableIdentity, extendTable);
        }
        dataModel.setUuid(modelRequest.getUuid() != null ? modelRequest.getUuid() : RandomUtil.randomUUIDStr());
        dataModel.setDescription(modelRequest.getDescription() != null ? modelRequest.getDescription() : "");
        dataModel.setProject(modelRequest.getProject());
        dataModel.setAllMeasures(this.convertMeasure(simplifiedMeasures));
        dataModel.setAllNamedColumns(this.convertNamedColumns(modelRequest.getProject(), dataModel, modelRequest));
        dataModel.initJoinDesc(KylinConfig.getInstanceFromEnv(), allTablesMap);
        this.convertNonEquiJoinCond(dataModel, modelRequest);
        dataModel.setModelType(dataModel.getModelTypeFromTable());
        return dataModel;
    }

    public void expandModelRequest(ModelRequest modelRequest) {
        if (modelRequest.getUuid() != null) {
            NDataModel existingModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)modelRequest.getProject()).getDataModelDesc(modelRequest.getUuid());
            HashMap<Integer, Collection<Integer>> effectiveExpandedMeasures = null;
            ImmutableBiMap<Integer, NDataModel.Measure> effectiveMeasures = null;
            if (existingModel.isBroken()) {
                effectiveExpandedMeasures = new HashMap<Integer, Collection<Integer>>();
                effectiveMeasures = this.loadModelMeasureWithoutInit(modelRequest, effectiveExpandedMeasures);
            } else {
                effectiveExpandedMeasures = existingModel.getEffectiveExpandedMeasures();
                effectiveMeasures = existingModel.getEffectiveMeasures();
            }
            HashSet internalIds = new HashSet();
            for (SimplifiedMeasure measure : modelRequest.getSimplifiedMeasures()) {
                if (!effectiveExpandedMeasures.containsKey(measure.getId())) continue;
                internalIds.addAll((Collection)effectiveExpandedMeasures.get(measure.getId()));
            }
            Set requestMeasureIds = modelRequest.getSimplifiedMeasures().stream().map(SimplifiedMeasure::getId).collect(Collectors.toSet());
            for (Integer internalId : internalIds) {
                if (requestMeasureIds.contains(internalId)) continue;
                modelRequest.getSimplifiedMeasures().add(SimplifiedMeasure.fromMeasure((NDataModel.Measure)effectiveMeasures.get((Object)internalId)));
            }
        }
    }

    private ImmutableBiMap<Integer, NDataModel.Measure> loadModelMeasureWithoutInit(ModelRequest modelRequest, Map<Integer, Collection<Integer>> effectiveExpandedMeasures) {
        NDataModel srcModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)modelRequest.getProject()).getDataModelDescWithoutInit(modelRequest.getUuid());
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (NDataModel.Measure measure : srcModel.getAllMeasures()) {
            measure.setName(measure.getName());
            if (measure.isTomb()) continue;
            mapBuilder.put((Object)measure.getId(), (Object)measure);
            if (measure.getType() != NDataModel.MeasureType.EXPANDABLE) continue;
            effectiveExpandedMeasures.put(measure.getId(), measure.getInternalIds());
        }
        return mapBuilder.build();
    }

    public void deleteExpandableMeasureInternalMeasures(NDataModel model) {
        this.expandableMeasureUtil.deleteExpandableMeasureInternalMeasures(model);
    }

    public void expandExpandableMeasure(NDataModel model) {
        this.expandableMeasureUtil.expandExpandableMeasure(model);
    }

    private void convertNonEquiJoinCond(NDataModel dataModel, ModelRequest request) {
        List<SimplifiedJoinTableDesc> requestJoinTableDescs = request.getSimplifiedJoinTableDescs();
        if (CollectionUtils.isEmpty(requestJoinTableDescs)) {
            return;
        }
        HashSet<SimplifiedJoinDesc> nonEquivJoins = new HashSet<SimplifiedJoinDesc>();
        String project = dataModel.getProject();
        KylinConfig projectKylinConfig = NProjectManager.getProjectConfig((String)project);
        boolean isScd2Enabled = projectKylinConfig.isQueryNonEquiJoinModelEnabled();
        if (!projectKylinConfig.isUTEnv()) {
            QueryContext.current().setAclInfo(AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups()));
        }
        QueryExec queryExec = new QueryExec(project, projectKylinConfig, false);
        for (int i = 0; i < requestJoinTableDescs.size(); ++i) {
            final JoinDesc joinWithoutNonEquivInfo = ((JoinTableDesc)dataModel.getJoinTables().get(i)).getJoin();
            SimplifiedJoinDesc requestJoinDesc = requestJoinTableDescs.get(i).getSimplifiedJoinDesc();
            if (CollectionUtils.isEmpty((Collection)requestJoinDesc.getSimplifiedNonEquiJoinConditions())) continue;
            if (!isScd2Enabled) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_SCD2_IS_NOT_ALLOWED, new Object[0]);
            }
            this.checkRequestNonEquiJoinConds(requestJoinDesc);
            String scd2Sql = SCD2SqlConverter.INSTANCE.genSCD2SqlStr(joinWithoutNonEquivInfo, requestJoinDesc.getSimplifiedNonEquiJoinConditions());
            JoinDesc analyzedJoin = this.deriveJoins(queryExec, scd2Sql);
            NonEquiJoinCondition nonEquiCondWithAliasRestored = new NonEquiJoinCondition.NeqConditionVisitor(){

                public NonEquiJoinCondition visitColumn(NonEquiJoinCondition cond) {
                    TableRef originalTableRef = cond.getColRef().getTableRef().getTableIdentity().equals(joinWithoutNonEquivInfo.getPKSide().getTableIdentity()) ? joinWithoutNonEquivInfo.getPKSide() : joinWithoutNonEquivInfo.getFKSide();
                    return new NonEquiJoinCondition(originalTableRef.getColumn(cond.getColRef().getName()), cond.getDataType());
                }
            }.visit(analyzedJoin.getNonEquiJoinCondition());
            analyzedJoin.setNonEquiJoinCondition(nonEquiCondWithAliasRestored);
            String expr = analyzedJoin.getNonEquiJoinCondition().getExpr();
            expr = expr.replaceAll(analyzedJoin.getPKSide().getAlias(), joinWithoutNonEquivInfo.getPKSide().getAlias());
            expr = expr.replaceAll(analyzedJoin.getFKSide().getAlias(), joinWithoutNonEquivInfo.getFKSide().getAlias());
            analyzedJoin.getNonEquiJoinCondition().setExpr(expr);
            analyzedJoin.setPrimaryTableRef(joinWithoutNonEquivInfo.getPKSide());
            analyzedJoin.setPrimaryTable(joinWithoutNonEquivInfo.getPrimaryTable());
            analyzedJoin.setForeignTableRef(joinWithoutNonEquivInfo.getFKSide());
            analyzedJoin.setForeignTable(joinWithoutNonEquivInfo.getForeignTable());
            try {
                Scd2Simplifier.INSTANCE.simplifyScd2Conditions(analyzedJoin);
                joinWithoutNonEquivInfo.setNonEquiJoinCondition(analyzedJoin.getNonEquiJoinCondition());
                joinWithoutNonEquivInfo.setForeignTable(analyzedJoin.getForeignTable());
                joinWithoutNonEquivInfo.setPrimaryTable(analyzedJoin.getPrimaryTable());
            }
            catch (Exception e) {
                ThreadUtil.warnKylinStackTrace((String)"Update model failed...\n");
                if (e instanceof KylinException) {
                    throw e;
                }
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION, new Object[]{Throwables.getRootCause((Throwable)e).getMessage()});
            }
            if (nonEquivJoins.contains(requestJoinDesc)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DUPLICATE_MODEL_JOIN_CONDITIONS, new Object[0]);
            }
            nonEquivJoins.add(requestJoinDesc);
        }
    }

    private JoinDesc deriveJoins(QueryExec queryExec, String sql) {
        Optional<KylinException> th;
        List contexts = queryExec.deriveOlapContexts(sql);
        if (contexts.isEmpty()) {
            th = Optional.of(new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION, new Object[]{"Failed to extract joins from the input sql: " + sql}));
        } else if (contexts.size() > 1) {
            th = Optional.of(new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION, new Object[]{"Small sub-queries were split from the input sql: " + sql}));
        } else {
            OlapContext ctx = (OlapContext)contexts.get(0);
            if (ctx.getJoins().size() == 1) {
                return (JoinDesc)ctx.getJoins().get(0);
            }
            th = Optional.of(new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION, new Object[]{"Non-equiv-join conditions were split. the input sql is: " + sql}));
        }
        throw th.get();
    }

    private void checkRequestNonEquiJoinConds(SimplifiedJoinDesc requestJoinDesc) {
        if (!SCD2CondChecker.INSTANCE.checkSCD2EquiJoinCond(requestJoinDesc.getForeignKey(), requestJoinDesc.getPrimaryKey())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_REQUIRES_AT_LEAST_ONE_EQUAL_CONDITION, new Object[0]);
        }
        if (!SCD2CondChecker.INSTANCE.checkSCD2NonEquiJoinCondPair(requestJoinDesc.getSimplifiedNonEquiJoinConditions())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_REQUIRES_AT_LEAST_ONE_NON_EQUAL_CONDITION, new Object[0]);
        }
        if (!SCD2CondChecker.INSTANCE.checkFkPkPairUnique(requestJoinDesc)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_PK_FK_UNIQUE_CHECK_FAILED, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<NDataModel.NamedColumn> convertNamedColumns(String project, NDataModel dataModel, ModelRequest modelRequest) {
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        ArrayList allTables = Lists.newArrayList();
        JoinTableDesc rootFactTable = new JoinTableDesc();
        rootFactTable.setTable(dataModel.getRootFactTableName());
        rootFactTable.setAlias(dataModel.getRootFactTableAlias());
        rootFactTable.setKind(NDataModel.TableKind.FACT);
        allTables.add(rootFactTable);
        allTables.addAll(dataModel.getJoinTables());
        List<NDataModel.NamedColumn> simplifiedColumns = modelRequest.getSimplifiedDimensions();
        HashMap dimensionNameMap = Maps.newHashMap();
        for (NDataModel.NamedColumn namedColumn : simplifiedColumns) {
            dimensionNameMap.put(namedColumn.getAliasDotColumn(), namedColumn);
        }
        HashMap otherColumnNameMap = Maps.newHashMap();
        for (NDataModel.NamedColumn namedColumn : modelRequest.getOtherColumns()) {
            otherColumnNameMap.put(namedColumn.getAliasDotColumn(), namedColumn);
        }
        boolean bl = false;
        ArrayList columns = Lists.newArrayList();
        for (JoinTableDesc joinTable : allTables) {
            TableDesc tableDesc = tableManager.getTableDesc(joinTable.getTable());
            boolean isFact = joinTable.getKind() == NDataModel.TableKind.FACT;
            String alias = StringUtils.isEmpty((CharSequence)joinTable.getAlias()) ? tableDesc.getName() : joinTable.getAlias();
            for (ColumnDesc column2 : modelRequest.getColumnsFetcher().apply(tableDesc, !isFact)) {
                void var10_13;
                NDataModel.NamedColumn namedColumn = new NDataModel.NamedColumn();
                namedColumn.setId((int)(++var10_13));
                namedColumn.setName(column2.getName());
                namedColumn.setAliasDotColumn(alias + "." + column2.getName());
                namedColumn.setStatus(NDataModel.ColumnStatus.EXIST);
                NDataModel.NamedColumn dimension = (NDataModel.NamedColumn)dimensionNameMap.get(namedColumn.getAliasDotColumn());
                if (dimension != null) {
                    namedColumn.setStatus(NDataModel.ColumnStatus.DIMENSION);
                    namedColumn.setName(dimension.getName());
                }
                if (otherColumnNameMap.get(namedColumn.getAliasDotColumn()) != null) {
                    namedColumn.setName(((NDataModel.NamedColumn)otherColumnNameMap.get(namedColumn.getAliasDotColumn())).getName());
                }
                columns.add(namedColumn);
            }
        }
        Map ccMap = dataModel.getComputedColumnDescs().stream().collect(Collectors.toMap(ComputedColumnDesc::getFullName, Function.identity()));
        ArrayList orderedCCList = Lists.newArrayList();
        NDataModel originModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(dataModel.getUuid());
        if (originModel != null && !originModel.isBroken()) {
            originModel.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).filter(column -> ccMap.containsKey(column.getAliasDotColumn())).forEach(column -> {
                ComputedColumnDesc cc = (ComputedColumnDesc)ccMap.get(column.getAliasDotColumn());
                orderedCCList.add(cc);
                ccMap.remove(column.getAliasDotColumn());
            });
            orderedCCList.addAll(ccMap.values());
        } else {
            orderedCCList.addAll(dataModel.getComputedColumnDescs());
        }
        for (ComputedColumnDesc computedColumnDesc : orderedCCList) {
            void var10_14;
            NDataModel.NamedColumn namedColumn = new NDataModel.NamedColumn();
            namedColumn.setId((int)(++var10_14));
            namedColumn.setName(computedColumnDesc.getColumnName());
            namedColumn.setAliasDotColumn(computedColumnDesc.getFullName());
            namedColumn.setStatus(NDataModel.ColumnStatus.EXIST);
            NDataModel.NamedColumn dimension = (NDataModel.NamedColumn)dimensionNameMap.get(namedColumn.getAliasDotColumn());
            if (dimension != null) {
                namedColumn.setStatus(NDataModel.ColumnStatus.DIMENSION);
                namedColumn.setName(dimension.getName());
            }
            columns.add(namedColumn);
        }
        return columns;
    }

    private void updateModelColumnForTableAliasModify(NDataModel model, Map<String, String> matchAlias) {
        for (Map.Entry<String, String> kv : matchAlias.entrySet()) {
            String newAliasName;
            String oldAliasName = kv.getKey();
            if (oldAliasName.equalsIgnoreCase(newAliasName = kv.getValue())) continue;
            model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).forEach(x -> x.changeTableAlias(oldAliasName, newAliasName));
            model.getAllMeasures().stream().filter(x -> !x.isTomb()).forEach(x -> x.changeTableAlias(oldAliasName, newAliasName));
            model.getComputedColumnDescs().forEach(x -> this.changeTableAlias((ComputedColumnDesc)x, oldAliasName, newAliasName));
            if (!StringUtils.isNotBlank((CharSequence)model.getFilterCondition())) continue;
            String expr = QueryUtil.adaptCalciteSyntax((String)model.getFilterCondition());
            SqlNode sqlNode = CalciteParser.getExpNode((String)expr);
            sqlNode.accept((SqlVisitor)new ModifyTableNameSqlVisitor(oldAliasName, newAliasName));
            String newFilterCondition = sqlNode.toSqlString((SqlDialect)CalciteParser.HIVE_SQL_DIALECT).toString();
            model.setFilterCondition(newFilterCondition);
        }
    }

    private void changeTableAlias(ComputedColumnDesc computedColumnDesc, String oldAlias, String newAlias) {
        ModifyTableNameSqlVisitor modifyAlias = new ModifyTableNameSqlVisitor(oldAlias, newAlias);
        SqlNode sqlNode = CalciteParser.getExpNode((String)computedColumnDesc.getExpression());
        sqlNode.accept((SqlVisitor)modifyAlias);
        computedColumnDesc.setExpression(sqlNode.toSqlString(CalciteSqlDialect.DEFAULT).toString());
    }

    private Map<String, String> getAliasTransformMap(NDataModel originModel, NDataModel expectModel) {
        HashMap matchAlias = Maps.newHashMap();
        boolean match = originModel.getJoinsGraph().match(expectModel.getJoinsGraph(), (Map)matchAlias);
        if (!match) {
            matchAlias.clear();
        }
        return matchAlias;
    }

    private boolean isValidMeasure(MeasureDesc measure) {
        FunctionDesc funcDesc = measure.getFunction();
        ParameterDesc param = (ParameterDesc)funcDesc.getParameters().get(0);
        if (param.isConstant()) {
            return true;
        }
        DataType ccDataType = param.getColRef().getType();
        return funcDesc.isDatatypeSuitable(ccDataType);
    }

    private NDataModel updateColumnsInit(NDataModel originModel, ModelRequest request, boolean saveCheck) {
        NDataModel expectedModel = this.convertToDataModel(request);
        this.discardInvalidColsAndMeasForBrokenModel(request.getProject(), expectedModel);
        String project = request.getProject();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        expectedModel.init(kylinConfig);
        Map<String, String> matchAlias = this.getAliasTransformMap(originModel, expectedModel);
        this.updateModelColumnForTableAliasModify(expectedModel, matchAlias);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
        expectedModel.init(kylinConfig, project, modelManager.getCCRelatedModels(expectedModel), saveCheck);
        originModel.setJoinTables(expectedModel.getJoinTables());
        originModel.setCanvas(expectedModel.getCanvas());
        originModel.setRootFactTableName(expectedModel.getRootFactTableName());
        originModel.setRootFactTableAlias(expectedModel.getRootFactTableAlias());
        originModel.setPartitionDesc(expectedModel.getPartitionDesc());
        originModel.setFilterCondition(expectedModel.getFilterCondition());
        originModel.setMultiPartitionDesc(expectedModel.getMultiPartitionDesc());
        this.updateModelColumnForTableAliasModify(originModel, matchAlias);
        return expectedModel;
    }

    private boolean equalsIgnoreReturnType(NDataModel.Measure removedOrUpdatedMeasure, NDataModel.Measure newMeasure) {
        SimplifiedMeasure simpleOld = SimplifiedMeasure.fromMeasure(removedOrUpdatedMeasure);
        simpleOld.setReturnType("any");
        SimplifiedMeasure simpleNew = SimplifiedMeasure.fromMeasure(newMeasure);
        simpleNew.setReturnType("any");
        return simpleOld.equals(simpleNew);
    }

    public UpdateImpact updateModelColumns(NDataModel originModel, ModelRequest request) {
        return this.updateModelColumns(originModel, request, false);
    }

    public UpdateImpact updateModelColumns(NDataModel originModel, ModelRequest request, boolean saveCheck) {
        NDataModel expectedModel = this.updateColumnsInit(originModel, request, saveCheck);
        UpdateImpact updateImpact = new UpdateImpact();
        List currentComputedColumns = originModel.getComputedColumnDescs();
        List newComputedColumns = expectedModel.getComputedColumnDescs();
        Set removedOrUpdatedComputedColumns = currentComputedColumns.stream().filter(cc -> !newComputedColumns.contains(cc)).map(ComputedColumnDesc::getFullName).collect(Collectors.toSet());
        originModel.getAllNamedColumns().stream().filter(column -> removedOrUpdatedComputedColumns.contains(column.getAliasDotColumn()) && column.isExist()).forEach(unusedColumn -> {
            unusedColumn.setStatus(NDataModel.ColumnStatus.TOMB);
            updateImpact.getRemovedOrUpdatedCCs().add(unusedColumn.getId());
        });
        Set allFunctions = originModel.getEffectiveMeasures().values().stream().map(measure -> measure.getFunction().toString()).collect(Collectors.toSet());
        if (allFunctions.size() != originModel.getEffectiveMeasures().size()) {
            this.fixDupMeasureNames(originModel, request);
        }
        ImmutableList currentMeasures = originModel.getEffectiveMeasures().values().asList();
        currentMeasures.stream().filter(measure -> {
            List params = measure.getFunction().getColRefs();
            if (CollectionUtils.isEmpty((Collection)params)) {
                return false;
            }
            return params.stream().map(TblColRef::getIdentity).anyMatch(removedOrUpdatedComputedColumns::contains);
        }).forEach(unusedMeasure -> {
            unusedMeasure.setTomb(true);
            updateImpact.getInvalidMeasures().add(unusedMeasure.getId());
        });
        originModel.setComputedColumnDescs(expectedModel.getComputedColumnDescs());
        originModel.setComputedColumnUuids(originModel.getComputedColumnDescs().stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList()));
        ArrayList newMeasures = Lists.newArrayList();
        this.compareAndUpdateColumns(this.toMeasureMap.apply(originModel.getAllMeasures()), this.toMeasureMap.apply(expectedModel.getAllMeasures()), newMeasures::add, oldMeasure -> oldMeasure.setTomb(true), (oldMeasure, newMeasure) -> {
            oldMeasure.setName(newMeasure.getName());
            oldMeasure.setComment(newMeasure.getComment());
        });
        this.updateMeasureStatus(newMeasures, originModel, updateImpact);
        Map<String, NDataModel.NamedColumn> originExistMap = this.toExistMap.apply(originModel.getAllNamedColumns());
        ArrayList newCols = Lists.newArrayList();
        this.compareAndUpdateColumns(originExistMap, this.toExistMap.apply(expectedModel.getAllNamedColumns()), newCols::add, oldCol -> oldCol.setStatus(NDataModel.ColumnStatus.TOMB), (olCol, newCol) -> olCol.setName(newCol.getName()));
        this.updateColumnStatus(newCols, originModel, updateImpact);
        HashSet removedCCs = new HashSet();
        removedCCs.addAll(updateImpact.getRemovedOrUpdatedCCs());
        removedCCs.removeAll(updateImpact.getUpdatedCCs());
        updateImpact.getInvalidMeasures().removeIf(measureId -> this.causedByCCDelete(removedCCs, originModel, (int)measureId));
        Map<String, NDataModel.NamedColumn> originDimensionMap = this.toDimensionMap.apply(originModel.getAllNamedColumns());
        this.compareAndUpdateColumns(originDimensionMap, this.toDimensionMap.apply(expectedModel.getAllNamedColumns()), newCol -> ((NDataModel.NamedColumn)originExistMap.get(newCol.getAliasDotColumn())).setStatus(NDataModel.ColumnStatus.DIMENSION), oldCol -> oldCol.setStatus(NDataModel.ColumnStatus.EXIST), (olCol, newCol) -> olCol.setName(newCol.getName()));
        originModel.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isDimension).filter(column -> request.getSimplifiedDimensions().stream().noneMatch(dimension -> dimension.getAliasDotColumn().equals(column.getAliasDotColumn()))).forEach(c -> c.setStatus(NDataModel.ColumnStatus.EXIST));
        return updateImpact;
    }

    private void fixDupMeasureNames(NDataModel originModel, ModelRequest request) {
        HashSet healthyExistedMeasures = Sets.newHashSet();
        ArrayList illegalSimplifiedMeasures = Lists.newArrayList();
        HashMap nameToIdOfSimplified = Maps.newHashMap();
        HashSet idOfSimplified = Sets.newHashSet();
        for (SimplifiedMeasure measure2 : request.getSimplifiedMeasures()) {
            nameToIdOfSimplified.put(measure2.getName(), measure2.getId());
            if (measure2.getId() == 0) continue;
            idOfSimplified.add(measure2.getId());
        }
        List nonCountStarExistedMeasures = originModel.getAllMeasures().stream().filter(measure -> !measure.getName().equals("COUNT_ALL")).filter(measure -> !measure.isTomb()).collect(Collectors.toList());
        Map<String, Integer> nameToIdOfExistedModel = nonCountStarExistedMeasures.stream().collect(Collectors.toMap(MeasureDesc::getName, NDataModel.Measure::getId));
        nameToIdOfExistedModel.forEach((name, id) -> {
            if (!nameToIdOfSimplified.containsKey(name)) {
                if (idOfSimplified.contains(id)) {
                    healthyExistedMeasures.add(id);
                }
            } else if ((Integer)nameToIdOfSimplified.get(name) == 0) {
                illegalSimplifiedMeasures.add(name);
            } else {
                healthyExistedMeasures.add(id);
            }
        });
        if (!illegalSimplifiedMeasures.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SIMPLIFIED_MEASURES_MISSING_ID, new Object[]{String.join((CharSequence)",", illegalSimplifiedMeasures)});
        }
        nonCountStarExistedMeasures.stream().filter(measure -> !healthyExistedMeasures.contains(measure.getId())).forEach(measure -> {
            log.warn("the measure({}) has been handled to tomb", (Object)measure.getName());
            measure.setTomb(true);
        });
    }

    private void updateMeasureStatus(List<NDataModel.Measure> newMeasures, NDataModel originModel, UpdateImpact updateImpact) {
        int maxMeasureId = originModel.getAllMeasures().stream().map(NDataModel.Measure::getId).mapToInt(i -> i).max().orElse(99999);
        newMeasures.sort(Comparator.comparing(NDataModel.Measure::getId));
        for (NDataModel.Measure measure : newMeasures) {
            Integer modifiedMeasureId = updateImpact.getInvalidMeasures().stream().filter(measureId -> this.equalsIgnoreReturnType(originModel.getTombMeasureById(measureId.intValue()), measure)).findFirst().orElse(null);
            if (modifiedMeasureId != null) {
                if (!this.isValidMeasure((MeasureDesc)measure)) continue;
                updateImpact.getInvalidMeasures().remove(modifiedMeasureId);
                FunctionDesc funcDesc = measure.getFunction();
                DataType ccDataType = ((ParameterDesc)funcDesc.getParameters().get(0)).getColRef().getType();
                String proposeReturnType = FunctionDesc.proposeReturnType((String)funcDesc.getExpression(), (String)ccDataType.toString());
                String originReturnType = originModel.getTombMeasureById(modifiedMeasureId.intValue()).getFunction().getReturnType();
                if (!originReturnType.equals(proposeReturnType)) {
                    FunctionDesc newFuncDesc = FunctionDesc.newInstance((String)funcDesc.getExpression(), (List)funcDesc.getParameters(), (String)proposeReturnType);
                    measure.setFunction(newFuncDesc);
                    measure.setId(++maxMeasureId);
                    originModel.getAllMeasures().add(measure);
                    updateImpact.getReplacedMeasures().put(modifiedMeasureId, maxMeasureId);
                    continue;
                }
                originModel.getTombMeasureById(modifiedMeasureId.intValue()).setTomb(false);
                updateImpact.getUpdatedMeasures().add(modifiedMeasureId);
                continue;
            }
            if (this.isValidMeasure((MeasureDesc)measure)) {
                measure.setId(++maxMeasureId);
                originModel.getAllMeasures().add(measure);
                continue;
            }
            updateImpact.getInvalidRequestMeasures().add(measure.getId());
        }
    }

    private void updateColumnStatus(List<NDataModel.NamedColumn> newCols, NDataModel originModel, UpdateImpact updateImpact) {
        int maxId = originModel.getAllNamedColumns().stream().map(NDataModel.NamedColumn::getId).mapToInt(i -> i).max().orElse(-1);
        for (NDataModel.NamedColumn newCol : newCols) {
            Integer modifiedColId = updateImpact.getRemovedOrUpdatedCCs().stream().filter(modifiedId -> newCol.getAliasDotColumn().equals(originModel.getTombColumnNameById(modifiedId.intValue()))).findFirst().orElse(null);
            if (modifiedColId != null) {
                NDataModel.NamedColumn modifiedColumn = originModel.getAllNamedColumns().stream().filter(c -> c.getId() == modifiedColId.intValue()).findFirst().orElse(null);
                if (modifiedColumn == null) continue;
                modifiedColumn.setStatus(newCol.getStatus());
                updateImpact.getUpdatedCCs().add(modifiedColId);
                continue;
            }
            newCol.setId(++maxId);
            originModel.getAllNamedColumns().add(newCol);
        }
    }

    private boolean causedByCCDelete(Set<Integer> removedCCs, NDataModel originModel, int measureId) {
        for (int ccId : removedCCs) {
            String colName = originModel.getTombColumnNameById(ccId);
            List funcParams = originModel.getTombMeasureById(measureId).getFunction().getParameters();
            for (ParameterDesc funcParam : funcParams) {
                String funcColName = funcParam.getColRef().getIdentity();
                if (!StringUtils.equalsIgnoreCase((CharSequence)funcColName, (CharSequence)colName)) continue;
                return true;
            }
        }
        return false;
    }

    private <K, T> void compareAndUpdateColumns(Map<K, T> origin, Map<K, T> target, Consumer<T> onlyInTarget, Consumer<T> onlyInOrigin, BiConsumer<T, T> inBoth) {
        T matched;
        for (Map.Entry<K, T> entry : target.entrySet()) {
            matched = origin.get(entry.getKey());
            if (matched == null) {
                onlyInTarget.accept(entry.getValue());
                continue;
            }
            inBoth.accept(matched, entry.getValue());
        }
        for (Map.Entry<K, T> entry : origin.entrySet()) {
            matched = target.get(entry.getKey());
            if (matched != null) continue;
            onlyInOrigin.accept(entry.getValue());
        }
    }

    private List<NDataModel.Measure> convertMeasure(List<SimplifiedMeasure> simplifiedMeasures) {
        NDataModel.Measure measure;
        ArrayList<NDataModel.Measure> measures = new ArrayList<NDataModel.Measure>();
        boolean hasCountAll = false;
        int id = 100000;
        if (simplifiedMeasures == null) {
            simplifiedMeasures = Lists.newArrayList();
        }
        for (SimplifiedMeasure simplifiedMeasure : simplifiedMeasures) {
            measure = simplifiedMeasure.toMeasure();
            measure.setId(id);
            measures.add(measure);
            FunctionDesc functionDesc = measure.getFunction();
            if (functionDesc.isCount() && !functionDesc.isCountOnColumn()) {
                hasCountAll = true;
            }
            ++id;
        }
        if (!hasCountAll) {
            FunctionDesc functionDesc = new FunctionDesc();
            ParameterDesc parameterDesc = new ParameterDesc();
            parameterDesc.setType("constant");
            parameterDesc.setValue("1");
            functionDesc.setParameters((List)Lists.newArrayList((Object[])new ParameterDesc[]{parameterDesc}));
            functionDesc.setExpression("COUNT");
            functionDesc.setReturnType("bigint");
            measure = this.newMeasure(functionDesc, "COUNT_ALL", id);
            measures.add(measure);
        }
        return measures;
    }

    private NDataModel.Measure newMeasure(FunctionDesc func, String name, int id) {
        NDataModel.Measure measure = new NDataModel.Measure();
        measure.setName(name);
        measure.setFunction(func);
        measure.setId(id);
        return measure;
    }

    public void handleSemanticUpdate(String project, String model, NDataModel originModel, String start, String end) {
        this.handleSemanticUpdate(project, model, originModel, start, end, false);
    }

    public void handleSemanticUpdate(String project, String model, NDataModel originModel, String start, String end, boolean saveOnly) {
        boolean needBuild = this.doHandleSemanticUpdate(project, model, originModel, start, end);
        if (!saveOnly && needBuild) {
            this.buildForModel(project, model);
        }
    }

    public boolean doHandleSemanticUpdate(String project, String model, NDataModel originModel, String start, String end) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indePlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)project);
        NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        OptRecManagerV2 optRecManagerV2 = OptRecManagerV2.getInstance((String)project);
        IndexPlan indexPlan = indePlanManager.getIndexPlan(model);
        NDataModel newModel = modelMgr.getDataModelDesc(model);
        if (this.isSignificantChange(originModel, newModel)) {
            log.info("model {} reload data from datasource", (Object)originModel.getAlias());
            IndexPlan savedIndexPlan = this.handleMeasuresChanged(indexPlan, (Set<Integer>)newModel.getEffectiveMeasures().keySet(), indePlanManager);
            this.removeUselessDimensions(savedIndexPlan, (Set<Integer>)newModel.getEffectiveDimensions().keySet(), false, config);
            modelMgr.updateDataModel(newModel.getUuid(), copyForWrite -> copyForWrite.setSemanticVersion(copyForWrite.getSemanticVersion() + 1));
            this.handleReloadData(newModel, originModel, project, start, end);
            optRecManagerV2.discardAll(model);
            return true;
        }
        if (this.isMeasureChange(originModel, newModel)) {
            this.handleMeasuresChanged(indexPlan, (Set<Integer>)newModel.getEffectiveMeasures().keySet(), indePlanManager);
        }
        if (this.isDimNotOnlyAdd(originModel, newModel)) {
            this.removeUselessDimensions(indexPlan, (Set<Integer>)newModel.getEffectiveDimensions().keySet(), true, config);
        }
        return this.hasRulebaseLayoutChange(indexPlan.getRuleBasedIndex(), indePlanManager.getIndexPlan(indexPlan.getId()).getRuleBasedIndex());
    }

    public boolean isDimNotOnlyAdd(NDataModel originModel, NDataModel newModel) {
        return !newModel.getEffectiveDimensions().keySet().containsAll((Collection)originModel.getEffectiveDimensions().keySet());
    }

    public boolean isMeasureChange(NDataModel originModel, NDataModel newModel) {
        return !CollectionUtils.isEqualCollection((Collection)newModel.getEffectiveMeasures().keySet(), (Collection)originModel.getEffectiveMeasures().keySet());
    }

    public boolean isFilterConditionNotChange(String oldFilterCondition, String newFilterCondition) {
        oldFilterCondition = oldFilterCondition == null ? "" : oldFilterCondition;
        newFilterCondition = newFilterCondition == null ? "" : newFilterCondition;
        return StringUtils.trim((String)oldFilterCondition).equals(StringUtils.trim((String)newFilterCondition));
    }

    public static boolean isMultiPartitionDescSame(MultiPartitionDesc oldPartitionDesc, MultiPartitionDesc newPartitionDesc) {
        String oldColumns = oldPartitionDesc == null ? "" : StringUtils.join((Iterable)oldPartitionDesc.getColumns(), (String)",");
        String newColumns = newPartitionDesc == null ? "" : StringUtils.join((Iterable)newPartitionDesc.getColumns(), (String)",");
        return oldColumns.equals(newColumns);
    }

    public static boolean isAntiFlattenableSame(List<JoinTableDesc> oldJoinTables, List<JoinTableDesc> newJoinTables) {
        Map newJoinMap = newJoinTables.stream().collect(Collectors.toMap(JoinTableDesc::getJoin, Function.identity()));
        boolean sameAntiFlattenable = true;
        for (JoinTableDesc oldJoinTable : oldJoinTables) {
            JoinTableDesc newJoinTable;
            JoinDesc join = oldJoinTable.getJoin();
            if (!newJoinMap.containsKey(join) || !oldJoinTable.hasDifferentAntiFlattenable(newJoinTable = (JoinTableDesc)newJoinMap.get(join))) continue;
            sameAntiFlattenable = false;
            break;
        }
        return sameAntiFlattenable;
    }

    public boolean isSignificantChange(NDataModel originModel, NDataModel newModel) {
        return this.isDifferent(originModel.getPartitionDesc(), newModel.getPartitionDesc()) || !Objects.equals(originModel.getRootFactTable(), newModel.getRootFactTable()) || !originModel.getJoinsGraph().match(newModel.getJoinsGraph(), (Map)Maps.newHashMap()) || !this.isFilterConditionNotChange(originModel.getFilterCondition(), newModel.getFilterCondition()) || !ModelSemanticHelper.isMultiPartitionDescSame(originModel.getMultiPartitionDesc(), newModel.getMultiPartitionDesc()) || !ModelSemanticHelper.isAntiFlattenableSame(originModel.getJoinTables(), newModel.getJoinTables());
    }

    private boolean isDifferent(PartitionDesc p1, PartitionDesc p2) {
        boolean isP2Null;
        boolean isP1Null = p1 == null || p1.isEmpty();
        boolean bl = isP2Null = p2 == null || p2.isEmpty();
        if (isP1Null && isP2Null) {
            return false;
        }
        return !Objects.equals(p1, p2);
    }

    private IndexPlan handleMeasuresChanged(IndexPlan indexPlan, Set<Integer> measures, NIndexPlanManager indexPlanManager) {
        return indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
            copyForWrite.setIndexes(copyForWrite.getIndexes().stream().filter(index -> measures.containsAll(index.getMeasures())).collect(Collectors.toList()));
            if (copyForWrite.getRuleBasedIndex() == null) {
                return;
            }
            RuleBasedIndex newRule = (RuleBasedIndex)JsonUtil.deepCopyQuietly((Object)copyForWrite.getRuleBasedIndex(), RuleBasedIndex.class);
            newRule.setLayoutIdMapping((List)Lists.newArrayList());
            if (newRule.getAggregationGroups() != null) {
                for (NAggregationGroup aggGroup : newRule.getAggregationGroups()) {
                    HashSet aggMeasures = Sets.newHashSet((Object[])aggGroup.getMeasures());
                    aggGroup.setMeasures((Integer[])Sets.intersection((Set)aggMeasures, (Set)measures).toArray((Object[])new Integer[0]));
                }
            }
            copyForWrite.setRuleBasedIndex(newRule);
        });
    }

    private void removeUselessDimensions(IndexPlan indexPlan, Set<Integer> availableDimensions, boolean onlyDataflow, KylinConfig config) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)indexPlan.getProject());
        Set deprecatedLayoutIds = indexPlan.getIndexes().stream().filter(index -> !index.isTableIndex()).filter(index -> !availableDimensions.containsAll(index.getDimensions())).flatMap(index -> index.getLayouts().stream().map(LayoutEntity::getId)).collect(Collectors.toSet());
        Set toBeDeletedLayoutIds = indexPlan.getToBeDeletedIndexes().stream().filter(index -> !index.isTableIndex()).filter(index -> !availableDimensions.containsAll(index.getDimensions())).flatMap(index -> index.getLayouts().stream().map(LayoutEntity::getId)).collect(Collectors.toSet());
        deprecatedLayoutIds.addAll(toBeDeletedLayoutIds);
        if (deprecatedLayoutIds.isEmpty()) {
            return;
        }
        if (onlyDataflow) {
            NDataflow df = dataflowManager.getDataflow(indexPlan.getUuid());
            dataflowManager.removeLayouts(df, deprecatedLayoutIds);
            if (CollectionUtils.isNotEmpty(toBeDeletedLayoutIds)) {
                NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)indexPlan.getProject());
                indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> copyForWrite.removeLayouts(deprecatedLayoutIds, true, true));
            }
        } else {
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)indexPlan.getProject());
            indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
                copyForWrite.removeLayouts(deprecatedLayoutIds, true, true);
                copyForWrite.removeLayouts(deprecatedLayoutIds, true, true);
            });
        }
    }

    public SegmentRange getSegmentRangeByModel(String project, String modelId, String start, String end) {
        TableRef tableRef = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId).getRootFactTable();
        TableDesc tableDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(tableRef.getTableIdentity());
        return SourceFactory.getSource((ISourceAware)tableDesc).getSegmentRange(start, end);
    }

    private void handleDatePartitionColumn(NDataModel newModel, NDataflowManager dataflowManager, NDataflow df, String modelId, String project, String start, String end) {
        if (newModel.getPartitionDesc() == null) {
            dataflowManager.fillDfManually(df, (List)Lists.newArrayList((Object[])new SegmentRange[]{SegmentRange.TimePartitionedSegmentRange.createInfinite()}));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)start) && StringUtils.isNotEmpty((CharSequence)end)) {
            dataflowManager.fillDfManually(df, (List)Lists.newArrayList((Object[])new SegmentRange[]{this.getSegmentRangeByModel(project, modelId, start, end)}));
        }
    }

    private void handleReloadData(NDataModel newModel, NDataModel oriModel, String project, String start, String end) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataSegmentManager segmentManager = NDataSegmentManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dataflowManager.getDataflow(newModel.getUuid());
        Segments segments = df.getFlatSegments();
        segments.forEach(arg_0 -> ((NDataSegmentManager)segmentManager).delete(arg_0));
        dataflowManager.updateDataflow(df.getUuid(), copyForWrite -> copyForWrite.setSegmentUuids(new Segments()));
        String modelId = newModel.getUuid();
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        if (newModel.isMultiPartitionModel() || oriModel.isMultiPartitionModel()) {
            boolean isMultiPartitionChange;
            boolean bl = isMultiPartitionChange = !ModelSemanticHelper.isMultiPartitionDescSame(oriModel.getMultiPartitionDesc(), newModel.getMultiPartitionDesc()) || !Objects.equals(oriModel.getPartitionDesc(), newModel.getPartitionDesc());
            if (isMultiPartitionChange && newModel.isMultiPartitionModel()) {
                modelManager.updateDataModel(modelId, copyForWrite -> copyForWrite.setMultiPartitionDesc(new MultiPartitionDesc(newModel.getMultiPartitionDesc().getColumns())));
            }
            if (!Objects.equals(oriModel.getPartitionDesc(), newModel.getPartitionDesc())) {
                this.handleDatePartitionColumn(newModel, dataflowManager, df, modelId, project, start, end);
            }
        } else if (!Objects.equals(oriModel.getPartitionDesc(), newModel.getPartitionDesc())) {
            this.handleDatePartitionColumn(newModel, dataflowManager, df, modelId, project, start, end);
        } else {
            ArrayList segmentRanges = Lists.newArrayList();
            segments.forEach(segment -> segmentRanges.add(segment.getSegRange()));
            dataflowManager.fillDfManually(df, (List)segmentRanges);
        }
    }

    public BuildIndexResponse handleIndexPlanUpdateRule(String project, String model, RuleBasedIndex oldRule, RuleBasedIndex newRule, boolean forceFireEvent) {
        log.debug("handle indexPlan udpate rule {} {}", (Object)project, (Object)model);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(model);
        Segments readySegs = df.getSegments();
        if (readySegs.isEmpty()) {
            return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NO_SEGMENT);
        }
        if (this.hasRulebaseLayoutChange(oldRule, newRule) || forceFireEvent) {
            JobManager jobManager = JobManager.getInstance((KylinConfig)kylinConfig, (String)project);
            String jobId = jobManager.addIndexJob(new JobParam(model, BasicService.getUsername()));
            BuildIndexResponse buildIndexResponse = new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NORM_BUILD, jobId);
            if (Objects.isNull(jobId)) {
                buildIndexResponse.setWarnCodeWithSupplier((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_JOB_SAVE_INDEX_SUCCESS);
            }
            return buildIndexResponse;
        }
        return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NO_LAYOUT);
    }

    private boolean hasRulebaseLayoutChange(RuleBasedIndex oldRule, RuleBasedIndex newRule) {
        Set originLayouts = oldRule == null ? Sets.newHashSet() : oldRule.genCuboidLayouts();
        Set targetLayouts = newRule == null ? Sets.newHashSet() : newRule.genCuboidLayouts();
        Sets.SetView difference = Sets.difference((Set)targetLayouts, (Set)originLayouts);
        return difference.size() > 0;
    }

    public IndexPlan addRuleBasedIndexBlackListLayouts(IndexPlan indexPlan, Collection<Long> blackListLayoutIds) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)indexPlan.getProject());
        return indexPlanManager.updateIndexPlan(indexPlan.getId(), indexPlanCopy -> indexPlanCopy.addRuleBasedBlackList(blackListLayoutIds));
    }

    public void buildForModel(String project, String modelId) {
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getIndexPlan(modelId);
        if (CollectionUtils.isNotEmpty((Collection)indexPlan.getAllLayoutIds(false))) {
            JobParam jobParam = new JobParam(modelId, BasicService.getUsername());
            jobParam.setProject(project);
            ((JobManager)this.getManager(JobManager.class, project)).addIndexJob(jobParam);
        }
    }

    public void buildForModelSegments(String project, String modelId, Set<String> targetSegments) {
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getIndexPlan(modelId);
        if (CollectionUtils.isNotEmpty((Collection)indexPlan.getAllLayoutIds(false))) {
            JobParam jobParam = new JobParam(modelId, BasicService.getUsername());
            jobParam.setProject(project);
            jobParam.withTargetSegments(targetSegments);
            ((JobManager)this.getManager(JobManager.class, project)).addRelatedIndexJob(jobParam);
        }
    }

    public void discardInvalidColsAndMeasForBrokenModel(String project, NDataModel model) {
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        HashSet<String> aliasDotColSet = new HashSet<String>();
        TableDesc rootFactTableDesc = tableMetadataManager.getTableDesc(model.getRootFactTableName());
        Arrays.stream(rootFactTableDesc.getColumns()).forEach(columnDesc -> {
            String aliasDotCol = rootFactTableDesc.getName() + "." + columnDesc.getName();
            aliasDotColSet.add(aliasDotCol);
        });
        List joinTables = model.getJoinTables();
        joinTables.forEach(joinTableDesc -> {
            TableDesc tableDesc = tableMetadataManager.getTableDesc(joinTableDesc.getTable());
            String joinTableAlias = joinTableDesc.getAlias();
            Arrays.stream(tableDesc.getColumns()).forEach(colDesc -> {
                String aliasDotCol = joinTableAlias + "." + colDesc.getName();
                aliasDotColSet.add(aliasDotCol);
            });
        });
        model.bindComputedColumns();
        List computedColumnDescs = model.getComputedColumnDescs();
        List<ComputedColumnDesc> validCCDescs = this.discardInvalidComputedColumnsForBrokenModel(aliasDotColSet, computedColumnDescs);
        model.setComputedColumnDescs(validCCDescs);
        model.setComputedColumnUuids(validCCDescs.stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList()));
        List allNamedColumns = model.getAllNamedColumns();
        allNamedColumns.stream().filter(NDataModel.NamedColumn::isExist).forEach(col -> {
            String aliasDotColumn = col.getAliasDotColumn();
            if (!aliasDotColSet.contains(aliasDotColumn)) {
                col.setStatus(NDataModel.ColumnStatus.TOMB);
            }
        });
        List allMeasures = model.getAllMeasures();
        allMeasures.stream().filter(measure -> !measure.isTomb()).forEach(measure -> {
            FunctionDesc functionDesc = measure.getFunction();
            functionDesc.getParameters().forEach(p -> {
                String aliasDotColumn;
                if (p.isColumnType() && !aliasDotColSet.contains(aliasDotColumn = p.getValue())) {
                    measure.setTomb(true);
                }
            });
        });
    }

    private List<ComputedColumnDesc> discardInvalidComputedColumnsForBrokenModel(Set<String> aliasDotColSet, List<ComputedColumnDesc> computedColumnDescs) {
        return computedColumnDescs.stream().map(ccDesc -> {
            AtomicBoolean isValidCC = new AtomicBoolean(true);
            String calciteSyntaxExp = QueryUtil.adaptCalciteSyntax((String)ccDesc.getInnerExpression());
            List colsWithAlias = ComputedColumnUtil.ExprIdentifierFinder.getExprIdentifiers((String)calciteSyntaxExp);
            colsWithAlias.forEach(c -> {
                String column = (String)c.getFirst() + "." + (String)c.getSecond();
                if (!aliasDotColSet.contains(column)) {
                    isValidCC.set(false);
                }
            });
            if (!isValidCC.get()) {
                return null;
            }
            String ccAlias = ccDesc.getTableAlias() + "." + ccDesc.getColumnName();
            aliasDotColSet.add(ccAlias);
            return ccDesc;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

