/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rest.request.CreateBaseIndexRequest;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.service.IndexPlanService;

public class BaseIndexUpdateHelper {
    private long preBaseAggLayout;
    private long preBaseTableLayout;
    private static final long NON_EXIST_LAYOUT = -1L;
    private String project;
    private String modelId;
    private List<IndexEntity.Source> updateBaseIndexTypes;
    private boolean needUpdate;

    public BaseIndexUpdateHelper(NDataModel model, boolean createIfNotExist) {
        this(model, BaseIndexUpdateHelper.updateTypesByFlag(createIfNotExist));
    }

    private static List<IndexEntity.Source> updateTypesByFlag(boolean createIfNotExist) {
        if (createIfNotExist) {
            return Lists.newArrayList((Object[])new IndexEntity.Source[]{IndexEntity.Source.BASE_AGG_INDEX, IndexEntity.Source.BASE_TABLE_INDEX});
        }
        return Lists.newArrayList();
    }

    public BaseIndexUpdateHelper(NDataModel model, List<IndexEntity.Source> updateBaseIndexTypes) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(model.getId());
        if (!indexPlan.isBroken()) {
            this.needUpdate = indexPlan.getConfig().isBaseIndexAutoUpdate();
        }
        if (this.needUpdate) {
            this.project = model.getProject();
            this.modelId = model.getId();
            this.updateBaseIndexTypes = updateBaseIndexTypes;
            this.preBaseAggLayout = this.getBaseAggLayout();
            this.preBaseTableLayout = this.getBaseTableLayout();
        }
    }

    public BuildBaseIndexResponse update(IndexPlanService service) {
        return this.update(service, true);
    }

    public BuildBaseIndexResponse update(IndexPlanService service, boolean checkProjectOperation) {
        if (!this.needUpdate) {
            return BuildBaseIndexResponse.EMPTY;
        }
        if (this.notExist(this.preBaseAggLayout) && this.notExist(this.preBaseTableLayout) && !this.updateBaseIndexTypes.contains(IndexEntity.Source.BASE_TABLE_INDEX) && !this.updateBaseIndexTypes.contains(IndexEntity.Source.BASE_AGG_INDEX)) {
            return BuildBaseIndexResponse.EMPTY;
        }
        long curBaseTableLayout = this.getBaseTableLayout();
        boolean needCreateBaseTable = this.updateBaseIndexTypes.contains(IndexEntity.Source.BASE_TABLE_INDEX);
        if (this.exist(this.preBaseTableLayout) && this.notExist(curBaseTableLayout)) {
            needCreateBaseTable = true;
        }
        Long curExistBaseAggLayout = this.getBaseAggLayout();
        boolean needCreateBaseAgg = this.updateBaseIndexTypes.contains(IndexEntity.Source.BASE_AGG_INDEX);
        if (this.exist(this.preBaseAggLayout) && this.notExist(curExistBaseAggLayout)) {
            needCreateBaseAgg = true;
        }
        CreateBaseIndexRequest indexRequest = new CreateBaseIndexRequest();
        indexRequest.setModelId(this.modelId);
        indexRequest.setProject(this.project);
        BuildBaseIndexResponse response = checkProjectOperation ? service.updateBaseIndex(this.project, indexRequest, needCreateBaseTable, needCreateBaseAgg, true) : service.updateBaseIndexInternal(this.project, indexRequest, needCreateBaseTable, needCreateBaseAgg, true);
        response.judgeIndexOperateType(this.exist(this.preBaseAggLayout), true);
        response.judgeIndexOperateType(this.exist(this.preBaseTableLayout), false);
        return response;
    }

    private boolean notExist(long layout) {
        return layout == -1L;
    }

    private boolean exist(long layout) {
        return layout != -1L;
    }

    private long getBaseTableLayout() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        LayoutEntity layout = indexPlanManager.getIndexPlan(this.modelId).getBaseTableLayout();
        return layout != null ? layout.getId() : -1L;
    }

    private long getBaseAggLayout() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        LayoutEntity layout = indexPlanManager.getIndexPlan(this.modelId).getBaseAggLayout();
        return layout != null ? layout.getId() : -1L;
    }
}

