/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtil.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtil.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.error("Get field value error:", (Throwable)e);
        }
        return result;
    }

    public static Method getDeclaredMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Can not find method {}", (Object)methodName, (Object)e);
                continue;
            }
        }
        return null;
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers())) {
            Unsafe.changeAccessibleObject(field, true);
        }
    }

    public static Field getDeclaredField(Object object, String filedName) {
        NoSuchFieldException noSuchFieldEx = null;
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(filedName);
            }
            catch (NoSuchFieldException e) {
                noSuchFieldEx = (NoSuchFieldException)ObjectUtils.firstNonNull((Object[])new NoSuchFieldException[]{noSuchFieldEx, e});
                continue;
            }
        }
        LOG.error("Can not find field '{}' in class {}", new Object[]{filedName, object.getClass().getName(), noSuchFieldEx});
        return null;
    }
}

