/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.mail.EmailException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.mail.MailService;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MailServiceTest {
    @Test
    public void testSendEmail() {
        KylinConfig mockConfig = (KylinConfig)Mockito.mock(KylinConfig.class);
        Mockito.when((Object)mockConfig.isStarttlsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockConfig.getMailUsername()).thenReturn((Object)"test@user");
        Mockito.when((Object)mockConfig.getMailPassword()).thenReturn((Object)"test_password");
        Mockito.when((Object)mockConfig.getSmtpPort()).thenReturn((Object)"25");
        Mockito.when((Object)mockConfig.getMailSender()).thenReturn((Object)"test@user");
        MailService mailservice = new MailService(mockConfig);
        ArrayList<String> receivers = new ArrayList<String>(1);
        receivers.add("foobar@foobar.com");
        boolean sent = this.sendTestEmail(mailservice, receivers, true);
        Assert.assertFalse((boolean)sent);
        Mockito.when((Object)mockConfig.isStarttlsEnabled()).thenReturn((Object)false);
        Mockito.when((Object)mockConfig.getMailUsername()).thenReturn((Object)"");
        Mockito.when((Object)mockConfig.getMailPassword()).thenReturn((Object)"ENC(test_password)");
        Mockito.when((Object)mockConfig.getMailSender()).thenReturn((Object)"test@sender");
        mailservice = new MailService(mockConfig);
        sent = this.sendTestEmail(mailservice, Lists.newArrayList(), false);
        Assert.assertFalse((boolean)sent);
    }

    private boolean sendTestEmail(MailService mailservice, List<String> receivers, boolean isHtmlMsg) {
        try {
            return mailservice.sendMail(receivers, "A test email from Kylin", "Hello!", isHtmlMsg);
        }
        catch (EmailException e) {
            return false;
        }
    }
}

