/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class MetaDataTypeTest {
    @Test
    public void testSplitKeyWithType() {
        String normalPath = "PROJECT/default";
        String rootPath = "/";
        String singleMetaKey = "abc";
        String illegalType = "proj/abc";
        String illegalPath = "/PROJECT/default";
        Pair typeAndKey = MetadataType.splitKeyWithType((String)normalPath);
        Assert.assertEquals((Object)MetadataType.PROJECT, (Object)typeAndKey.getFirst());
        Assert.assertEquals((Object)"default", (Object)typeAndKey.getSecond());
        typeAndKey = MetadataType.splitKeyWithType((String)rootPath);
        Assert.assertEquals((Object)MetadataType.ALL, (Object)typeAndKey.getFirst());
        Assert.assertEquals((Object)rootPath, (Object)typeAndKey.getSecond());
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.splitKeyWithType((String)singleMetaKey));
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.splitKeyWithType((String)illegalType));
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.splitKeyWithType((String)illegalPath));
    }

    @Test
    public void testMergeKeyWithType() {
        String normalPath = "PROJECT/default";
        String rootPath = "/";
        String singleMetaKey = "abc";
        Assert.assertEquals((Object)"PROJECT/abc", (Object)MetadataType.mergeKeyWithType((String)singleMetaKey, (MetadataType)MetadataType.PROJECT));
        Assert.assertEquals((Object)normalPath, (Object)MetadataType.mergeKeyWithType((String)normalPath, (MetadataType)MetadataType.ALL));
        Assert.assertEquals((Object)rootPath, (Object)MetadataType.mergeKeyWithType((String)rootPath, (MetadataType)MetadataType.ALL));
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.mergeKeyWithType((String)singleMetaKey, (MetadataType)MetadataType.ALL));
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.mergeKeyWithType((String)rootPath, (MetadataType)MetadataType.PROJECT));
        Assert.assertThrows(IllegalArgumentException.class, () -> MetadataType.mergeKeyWithType((String)normalPath, (MetadataType)MetadataType.PROJECT));
    }
}

