/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.smarter;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.step.build.FlatTableStage$;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkInternalAgent$;
import org.apache.spark.sql.SparkOperation$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.execution.utils.SchemaProcessor$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class IndexDependencyParser$ {
    public static IndexDependencyParser$ MODULE$;

    static {
        new IndexDependencyParser$();
    }

    public Dataset<Row> generateFullFlatTableDF(NDataModel model) {
        BoxedUnit boxedUnit;
        LogicalPlan rootLogicalPlan = this.genTableLogicalPlan(model.getRootFactTable());
        LinkedHashMap joinTableDFMap = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getJoinTables()).asScala()).map((Function1 & Serializable & scala.Serializable)joinTable -> joinTableDFMap.put(joinTable, (Object)MODULE$.genTableLogicalPlan(joinTable.getTableRef())), Buffer$.MODULE$.canBuildFrom());
        LogicalPlan df = FlatTableStage$.MODULE$.joinFactTableWithLookupTables(rootLogicalPlan, (Map<JoinTableDesc, LogicalPlan>)joinTableDFMap, model, false);
        String filterCondition = model.getFilterCondition();
        if (StringUtils.isNotEmpty((CharSequence)filterCondition)) {
            String massagedCondition = PushDownUtil.massageExpression((NDataModel)model, (String)model.getProject(), (String)filterCondition, null);
            String condition = NSparkCubingUtil.convertFromDot((String)massagedCondition);
            boxedUnit = SparkOperation$.MODULE$.filter(functions$.MODULE$.col(condition), df);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return SparkInternalAgent$.MODULE$.getDataFrame(SparderEnv$.MODULE$.getSparkSessionWithConfig(KylinConfig.getInstanceFromEnv()), df);
    }

    private LogicalPlan genTableLogicalPlan(TableRef tableRef) {
        ColumnDesc[] tableCols = (ColumnDesc[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tableRef.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getColumnDesc(), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnDesc.class));
        StructType structType = SchemaProcessor$.MODULE$.buildSchemaWithRawTable(tableCols);
        String alias = tableRef.getAlias();
        LocalRelation fsRelation = new LocalRelation(this.toAttributes(structType), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3());
        SubqueryAlias plan = SubqueryAlias$.MODULE$.apply(alias, (LogicalPlan)fsRelation);
        return FlatTableStage$.MODULE$.wrapAlias((LogicalPlan)plan, alias, false);
    }

    public Seq<AttributeReference> toAttributes(StructType schema) {
        return (Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toAttribute((StructField)field), Seq$.MODULE$.canBuildFrom());
    }

    public AttributeReference toAttribute(StructField field) {
        String x$1 = field.name();
        DataType x$2 = field.dataType();
        boolean x$3 = field.nullable();
        Metadata x$4 = field.metadata();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    private IndexDependencyParser$() {
        MODULE$ = this;
    }
}

