/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.manager;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.util.JobKiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobManager.class);
    private String project;
    private KylinConfig config;
    private CachedCrudAssist<StreamingJobMeta> crud;

    private StreamingJobManager(KylinConfig config, final String project) {
        this.project = project;
        this.config = config;
        this.crud = new CachedCrudAssist<StreamingJobMeta>(this.getStore(), MetadataType.STREAMING_JOB, project, StreamingJobMeta.class){

            protected StreamingJobMeta initEntityAfterReload(StreamingJobMeta entity, String resourceName) {
                entity.setProject(project);
                return entity;
            }
        };
    }

    public static StreamingJobManager getInstance(KylinConfig config, String project) {
        return (StreamingJobManager)config.getManager(project, StreamingJobManager.class);
    }

    static StreamingJobManager newInstance(KylinConfig config, String project) {
        return new StreamingJobManager(config, project);
    }

    public StreamingJobMeta getStreamingJobByUuid(String uuid) {
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            return null;
        }
        return (StreamingJobMeta)this.crud.get(uuid);
    }

    public void createStreamingJob(NDataModel model) {
        this.createStreamingJob(model, JobTypeEnum.STREAMING_BUILD);
        this.createStreamingJob(model, JobTypeEnum.STREAMING_MERGE);
    }

    public void createStreamingJob(NDataModel model, JobTypeEnum jobType) {
        StreamingJobMeta job = StreamingJobMeta.create(model, JobStatusEnum.STOPPED, jobType);
        StreamingJobMeta copy = this.copyForWrite(job);
        this.crud.save((RootPersistentEntity)copy);
    }

    public StreamingJobMeta copy(StreamingJobMeta jobMeta) {
        return (StreamingJobMeta)this.crud.copyBySerialization((RootPersistentEntity)jobMeta);
    }

    public StreamingJobMeta copyForWrite(StreamingJobMeta jobMeta) {
        return (StreamingJobMeta)this.crud.copyForWrite((RootPersistentEntity)jobMeta);
    }

    public StreamingJobMeta updateStreamingJob(String jobId, NStreamingJobUpdater updater) {
        StreamingJobMeta cached = this.getStreamingJobByUuid(jobId);
        if (cached == null) {
            return null;
        }
        StreamingJobMeta copy = this.copyForWrite(cached);
        updater.modify(copy);
        return (StreamingJobMeta)this.crud.save((RootPersistentEntity)copy);
    }

    public void deleteStreamingJob(String uuid) {
        StreamingJobMeta job = this.getStreamingJobByUuid(uuid);
        if (job == null) {
            log.warn("Dropping streaming job {} doesn't exists", (Object)uuid);
            return;
        }
        log.info("deleteStreamingJob:" + uuid);
        this.crud.delete(uuid);
    }

    public List<StreamingJobMeta> listAllStreamingJobMeta() {
        return this.crud.listAll();
    }

    public void destroyAllProcess() {
        this.listAllStreamingJobMeta().stream().forEach(JobKiller::killProcess);
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public static interface NStreamingJobUpdater {
        public void modify(StreamingJobMeta var1);
    }
}

