/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import jodd.io.StreamGobbler;

public class ProcessRunner {
    public static final String ERROR_PREFIX = "err> ";
    public static final String OUTPUT_PREFIX = "out> ";

    public static ProcessResult run(Process process) throws InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), (OutputStream)baos, OUTPUT_PREFIX);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), (OutputStream)baos, ERROR_PREFIX);
        outputGobbler.start();
        errorGobbler.start();
        int result = process.waitFor();
        outputGobbler.waitFor();
        errorGobbler.waitFor();
        return new ProcessResult(result, baos.toString());
    }

    public static class ProcessResult {
        private final int exitCode;
        private final String output;

        protected ProcessResult(int existCode, String output) {
            this.exitCode = existCode;
            this.output = output;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

