/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.apache.commons.cli.Options;
import alluxio.shaded.client.org.apache.commons.cli.ParseException;
import alluxio.shaded.client.org.apache.commons.cli.PosixParser;
import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliCommand;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliParseException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliWrapperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.MalformedPathException;
import alluxio.shaded.client.org.apache.zookeeper.cli.StatPrinter;
import alluxio.shaded.client.org.apache.zookeeper.data.ACL;
import alluxio.shaded.client.org.apache.zookeeper.data.Stat;
import java.util.List;

public class GetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetAclCommand() {
        super("getAcl", "[-s] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<ACL> acl;
        String path = this.args[1];
        Stat stat = new Stat();
        try {
            acl = this.zk.getACL(path, stat);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        for (ACL a : acl) {
            this.out.println(a.getId() + ": " + GetAclCommand.getPermString(a.getPerms()));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return false;
    }

    private static String getPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    static {
        options.addOption("s", false, "stats");
    }
}

