/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.scheduler;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.EvictionScheduler;
import com.stoyanr.evictor.map.EvictibleEntry;
import com.stoyanr.evictor.queue.NavigableMapEvictionQueue;

public abstract class AbstractQueueEvictionScheduler<K, V>
implements EvictionScheduler<K, V> {
    private final EvictionQueue<K, V> queue;

    public AbstractQueueEvictionScheduler() {
        this(new NavigableMapEvictionQueue());
    }

    public AbstractQueueEvictionScheduler(EvictionQueue<K, V> queue) {
        if (queue == null) {
            throw new NullPointerException("Queue cannot be null");
        }
        this.queue = queue;
    }

    @Override
    public void scheduleEviction(EvictibleEntry<K, V> e) {
        if (e.isEvictible()) {
            this.queue.putEntry(e);
            this.onScheduleEviction(e);
        }
    }

    @Override
    public void cancelEviction(EvictibleEntry<K, V> e) {
        if (e.isEvictible()) {
            this.queue.removeEntry(e);
            this.onCancelEviction(e);
        }
    }

    protected void evictEntries() {
        if (this.queue.evictEntries()) {
            this.onEvictEntries();
        }
    }

    protected boolean hasScheduledEvictions() {
        return this.queue.hasEntries();
    }

    protected long getNextEvictionTime() {
        return this.queue.getNextEvictionTime();
    }

    protected abstract void onScheduleEviction(EvictibleEntry<K, V> var1);

    protected abstract void onCancelEviction(EvictibleEntry<K, V> var1);

    protected abstract void onEvictEntries();

    final class EvictionRunnable
    implements Runnable {
        EvictionRunnable() {
        }

        @Override
        public void run() {
            AbstractQueueEvictionScheduler.this.evictEntries();
        }
    }
}

