/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.ProcessUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public class TempMetadataBuilder {
    public static final String KAP_META_TEST_DATA = "../examples/test_case_data/localmeta";
    public static final String SPARK_PROJECT_KAP_META_TEST_DATA = "../../examples/test_case_data/localmeta";
    public static final String TEMP_TEST_METADATA = "../examples/test_data/" + ProcessUtils.getCurrentId(System.currentTimeMillis() + "_" + UUID.randomUUID().toString());
    private final List<String> metaSrcs;
    private String project;
    private boolean onlyProps = false;

    public static String prepareLocalTempMetadata() {
        return TempMetadataBuilder.prepareLocalTempMetadata(Lists.newArrayList());
    }

    public static String prepareLocalTempMetadata(List<String> overlay) {
        return TempMetadataBuilder.createBuilder(overlay).build();
    }

    public static TempMetadataBuilder createBuilder(List<String> overlay) {
        overlay.add(0, KAP_META_TEST_DATA);
        if (!new File(overlay.get(0)).exists()) {
            overlay.set(0, "../" + overlay.get(0));
        }
        return new TempMetadataBuilder(overlay);
    }

    public String build() {
        try {
            String tempTestMetadataDir = TEMP_TEST_METADATA;
            FileUtils.deleteQuietly((File)new File(tempTestMetadataDir));
            for (String metaSrc : this.metaSrcs) {
                if (this.onlyProps) {
                    FileUtils.copyFile((File)new File(metaSrc, "kylin.properties"), (File)new File(tempTestMetadataDir, "kylin.properties"));
                    continue;
                }
                FileUtils.copyDirectory((File)new File(metaSrc), (File)new File(tempTestMetadataDir), pathname -> {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    try {
                        String name = pathname.getCanonicalPath();
                        return this.project == null || name.endsWith(".properties") || !MetadataChecker.verifyNonMetadataFile(name);
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }, (boolean)true);
            }
            this.appendKylinProperties(tempTestMetadataDir);
            return tempTestMetadataDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendKylinProperties(String tempMetadataDir) throws IOException {
        File propsFile = new File(tempMetadataDir, "kylin.properties");
        File appendFile = new File(tempMetadataDir, "kylin.properties.append");
        if (appendFile.exists()) {
            String appendStr = FileUtils.readFileToString((File)appendFile, (Charset)Charsets.UTF_8);
            FileUtils.writeStringToFile((File)propsFile, (String)appendStr, (Charset)Charsets.UTF_8, (boolean)true);
            FileUtils.deleteQuietly((File)appendFile);
        }
    }

    @Generated
    public TempMetadataBuilder(List<String> metaSrcs) {
        this.metaSrcs = metaSrcs;
    }

    @Generated
    public TempMetadataBuilder(List<String> metaSrcs, String project, boolean onlyProps) {
        this.metaSrcs = metaSrcs;
        this.project = project;
        this.onlyProps = onlyProps;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setOnlyProps(boolean onlyProps) {
        this.onlyProps = onlyProps;
    }

    @Generated
    public List<String> getMetaSrcs() {
        return this.metaSrcs;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public boolean isOnlyProps() {
        return this.onlyProps;
    }
}

