/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.SnapshotRawResource;
import org.apache.kylin.common.persistence.VersionedRawResource;
import org.apache.kylin.common.persistence.metadata.FileSystemFilterFactory;
import org.apache.kylin.common.persistence.metadata.FileTransactionHelper;
import org.apache.kylin.common.persistence.metadata.MemoryAuditLogStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.guava30.shaded.common.util.concurrent.Uninterruptibles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class FileSystemMetadataStore
extends MetadataStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemMetadataStore.class);
    public static final String HDFS_SCHEME = "hdfs";
    public static final String FILE_SCHEME = "file";
    private static final String COMPRESSED_FILE = "metadata.zip";
    public static final String JSON_SUFFIX = ".json";
    private static final int DEFAULT_FILE_NUMBER = 10000;
    private final FileTransactionHelper helper;
    @VisibleForTesting
    protected static volatile ExecutorService fileSystemMetadataExecutor = null;
    protected Path rootPath;
    protected FileSystem fs;
    @VisibleForTesting
    protected final Type type;
    private final CompressHandlerInterface compressHandlerInterface;
    private final AtomicReference<Object> compressedFiles = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public FileSystemMetadataStore(KylinConfig kylinConfig) throws IOException {
        super(kylinConfig);
        try {
            StorageURL storageUrl = kylinConfig.getMetadataUrl();
            String scheme = storageUrl.getScheme();
            Preconditions.checkState((HDFS_SCHEME.equals(scheme) || FILE_SCHEME.equals(scheme) ? 1 : 0) != 0, (Object)"FileSystemMetadataStore only support hdfs or file scheme");
            this.type = storageUrl.getParameter("zip") != null ? Type.ZIP : Type.DIR;
            this.compressHandlerInterface = storageUrl.getParameter("snapshot") != null ? new SnapShotCompressHandler() : new CompressHandler();
            String pathStr = scheme.equals(HDFS_SCHEME) ? storageUrl.getParameter("path") : kylinConfig.getMetadataUrl().getIdentifier();
            this.initWithMetadataPath(pathStr, scheme, kylinConfig);
            if (this.fs instanceof RawLocalFileSystem || this.fs instanceof LocalFileSystem) {
                this.fs.setWriteChecksum(false);
                this.fs.setVerifyChecksum(true);
            }
            if (!this.fs.exists(this.rootPath)) {
                Path p = this.rootPath;
                if (this.type == Type.ZIP && this.rootPath.toString().endsWith(".zip")) {
                    p = this.rootPath.getParent();
                }
                log.warn("Path not exist in FileSystem, create it: {}", (Object)p.toString());
                this.fs.mkdirs(p);
            }
            if (fileSystemMetadataExecutor == null && kylinConfig.isConcurrencyProcessMetadataEnabled()) {
                Class<FileSystemMetadataStore> clazz = FileSystemMetadataStore.class;
                // MONITORENTER : org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore.class
                if (fileSystemMetadataExecutor == null) {
                    fileSystemMetadataExecutor = new ThreadPoolExecutor(kylinConfig.getConcurrencyProcessMetadataThreadNumber(), kylinConfig.getConcurrencyProcessMetadataThreadNumber(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("fileSystemMetadataExecutor"));
                }
                // MONITOREXIT : clazz
            }
            this.auditLogStore = new MemoryAuditLogStore(kylinConfig);
            this.helper = new FileTransactionHelper(this);
            log.info("The FileSystem location is {}, hdfs root path : {}", (Object)this.fs.getUri().toString(), (Object)this.rootPath.toString());
            return;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new KylinRuntimeException(e);
        }
    }

    private void initWithMetadataPath(String pathStr, String scheme, KylinConfig kylinConfig) throws IOException {
        if (pathStr == null) {
            assert (!scheme.equals(FILE_SCHEME)) : "When scheme is file, the pathStr shouldn't be null";
            pathStr = HadoopUtil.getBackupFolder(kylinConfig);
            this.fs = HadoopUtil.getWorkingFileSystem();
            this.createMetaFolderIfNeed(new Path(pathStr));
            Path tmpRootPath = Stream.of(FileSystemUtil.listStatus(this.fs, new Path(pathStr))).filter(fileStatus -> fileStatus.getPath().getName().endsWith("_backup")).max(Comparator.comparing(FileStatus::getModificationTime)).map(FileStatus::getPath).orElse(new Path(pathStr + "/backup_0/"));
            this.createMetaFolderIfNeed(tmpRootPath);
            this.rootPath = this.checkCoreMetaDir(tmpRootPath);
        } else {
            Path tempPath;
            if (scheme.equals(FILE_SCHEME) && !pathStr.startsWith(FILE_SCHEME)) {
                pathStr = "file://" + new File(pathStr).getAbsolutePath();
            }
            if ((tempPath = new Path(pathStr)).toUri().getScheme() != null) {
                this.fs = HadoopUtil.getWorkingFileSystem(tempPath);
                this.rootPath = tempPath;
            } else {
                this.fs = HadoopUtil.getWorkingFileSystem();
                this.rootPath = this.fs.makeQualified(tempPath);
            }
        }
    }

    private Path checkCoreMetaDir(Path tmpRootPath) throws IOException {
        FileStatus[] fileStatuses;
        for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(tmpRootPath)) {
            if (!fileStatus.isDirectory() || !"core_meta".equals(fileStatus.getPath().getName())) continue;
            return fileStatus.getPath();
        }
        return tmpRootPath;
    }

    @Override
    public <T extends RawResource> List<T> get(MetadataType type, RawResourceFilter filter, boolean needLock, boolean needContent) {
        List<? extends RawResource> resList;
        Preconditions.checkArgument((type != MetadataType.ALL ? 1 : 0) != 0, (Object)"Fetching all metadata in the transaction is not allowed.");
        FileSystemFilterFactory.FilterContext context = FileSystemFilterFactory.convertConditionsToFilter(filter, type);
        Class<? extends RawResource> resourceClass = type.getResourceClass();
        if (needLock) {
            if (context.isWholePath()) {
                this.lockResource(context.getResPath());
            } else {
                this.lockResource(type.name());
            }
        }
        try {
            resList = this.type == Type.DIR ? this.getFromDir(context, needContent, resourceClass) : this.getFromZip(context, needContent, resourceClass);
        }
        catch (IOException e) {
            throw new KylinRuntimeException("get resource fail", e);
        }
        return resList;
    }

    private <T extends RawResource> List<T> getFromDir(FileSystemFilterFactory.FilterContext context, boolean needContent, Class<T> resourceClass) throws IOException {
        ArrayList resList = new ArrayList();
        String resPath = context.getResPath();
        RawResourceFilter jsonFilter = context.getRawResourceFilter();
        Path p = this.getRealFileSystemPath(resPath);
        if (context.isWholePath()) {
            T rawResource;
            if (this.fs.exists(p) && this.fs.isFile(p) && (rawResource = this.getRawResource(needContent, this.fs.getFileStatus(p), resourceClass, jsonFilter)) != null) {
                resList.add(rawResource);
            }
        } else if (this.fs.exists(p) && this.fs.isDirectory(p)) {
            Stream<FileStatus> stream = context.getRegex() == null ? Arrays.stream(this.fs.listStatus(p)) : Arrays.stream(this.fs.globStatus(new Path(this.rootPath, resPath + "/" + "*"), path -> path.getName().matches(context.getRegex())));
            stream.forEach(path -> {
                Object rawResource = this.getRawResource(needContent, (FileStatus)path, resourceClass, jsonFilter);
                if (rawResource != null) {
                    resList.add(rawResource);
                }
            });
        }
        return resList;
    }

    private <T extends RawResource> List<T> getFromZip(FileSystemFilterFactory.FilterContext context, boolean needContent, Class<T> resourceClass) {
        ArrayList<RawResource> resList = new ArrayList<RawResource>();
        String resPath = context.getResPath();
        RawResourceFilter jsonFilter = context.getRawResourceFilter();
        if (context.isWholePath()) {
            RawResource rawResource = (RawResource)resourceClass.cast(this.getCompressedFiles().get(resPath));
            if (rawResource != null && jsonFilter.isMatch(rawResource)) {
                if (!needContent) {
                    rawResource.setContent(null);
                }
                resList.add(rawResource);
            }
        } else {
            this.getCompressedFiles().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(context.getResPath()) && (context.getRegex() == null || ((String)entry.getKey()).matches(context.getResPath() + "/" + context.getRegex()))).forEach(entry -> {
                RawResource rawResource = (RawResource)resourceClass.cast(entry.getValue());
                if (jsonFilter.isMatch(rawResource)) {
                    if (!needContent) {
                        rawResource.setContent(null);
                    }
                    resList.add(rawResource);
                }
            });
        }
        return resList;
    }

    private <T extends RawResource> T getRawResource(boolean needContent, FileStatus fileStatus, Class<T> resourceClass, RawResourceFilter jsonFilter) {
        String filePath;
        if (fileStatus.getLen() == 0L) {
            log.warn("Zero length file: " + fileStatus.getPath().toString());
        }
        if (MetadataChecker.verifyNonMetadataFile(filePath = fileStatus.getPath().toString().replace(this.rootPath.toString(), ""))) {
            return null;
        }
        if (filePath.split("/", 2).length != 2) {
            throw new IllegalStateException("Can not get file path: " + filePath + ".");
        }
        String fileName = FileSystemMetadataStore.splitFilePath(filePath).getValue();
        String metaKey = fileName.substring(0, fileName.length() - 5);
        T rawResource = this.openFileWithRetry(fileStatus.getPath(), resourceClass, needContent, 3);
        long ts = fileStatus.getModificationTime();
        ((RawResource)rawResource).setTs(ts);
        ((RawResource)rawResource).setMetaKey(metaKey);
        ((RawResource)rawResource).setMvcc(0L);
        return (T)(jsonFilter.isMatch((RawResource)rawResource) ? rawResource : null);
    }

    private <T extends RawResource> T openFileWithRetry(Path filePath, Class<T> resourceClass, boolean needContent, int retryCnt) {
        RawResource rawResource;
        byte[] byteArray = null;
        try (FSDataInputStream in = this.fs.open(filePath);){
            byteArray = IOUtils.toByteArray((InputStream)in);
            rawResource = (RawResource)JsonUtil.readValue(byteArray, resourceClass);
        }
        catch (Exception e) {
            log.warn("Failed to load resource from file: " + filePath);
            if (byteArray != null && byteArray.length == 0 && retryCnt > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new KylinRuntimeException(ex);
                }
                return this.openFileWithRetry(filePath, resourceClass, needContent, retryCnt - 1);
            }
            try {
                rawResource = (RawResource)resourceClass.newInstance();
            }
            catch (Exception ex) {
                throw new KylinRuntimeException(ex);
            }
        }
        if (needContent) {
            rawResource.setContent(byteArray);
        }
        return (T)rawResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KylinConfig getKylinConfigFromFile() {
        Path confPath = new Path(this.rootPath, "kylin.properties");
        try {
            if (!this.fs.exists(confPath)) {
                throw new KylinRuntimeException("kylin.properties not exist under: " + this.rootPath);
            }
            try (FSDataInputStream in = this.fs.open(confPath);){
                KylinConfig kylinConfig = KylinConfig.createKylinConfig(KylinConfig.streamToProps((InputStream)in));
                return kylinConfig;
            }
        }
        catch (IOException e) {
            throw new KylinRuntimeException("Read kylin.properties failed from file system.");
        }
    }

    private void dumpKylinConfigToFile(KylinConfig conf) {
        Path confPath = new Path(this.rootPath, "kylin.properties");
        try (FSDataOutputStream out = this.fs.create(confPath, true);){
            conf.exportToProperties().store((OutputStream)out, confPath.toString());
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Dump resource fail", e);
        }
    }

    @Override
    public int save(MetadataType type, RawResource raw) {
        String resPath = raw.generateFilePath();
        Path p = this.getRealFileSystemPath(resPath);
        try {
            this.createMetaFolderIfNeed(p.getParent());
            byte[] bytes = raw.getContent();
            if (bytes == null) {
                return this.fs.delete(p, true) ? 1 : 0;
            }
            ByteSource bs = ByteSource.wrap((byte[])raw.getContent());
            try (FSDataOutputStream out = this.createFileWithDefaultPermission(p);){
                IOUtils.copy((InputStream)bs.openStream(), (OutputStream)out);
                out.hflush();
                this.fs.setTimes(p, raw.getTs().longValue(), -1L);
            }
            FileStatus fileStatus = this.fs.getFileStatus(p);
            if (fileStatus.getLen() == 0L) {
                throw new KylinRuntimeException("Put resource fail : " + resPath + ", because resource file is Zero length");
            }
            if (bs.size() != fileStatus.getLen()) {
                throw new KylinRuntimeException("Put resource fail : " + resPath + ", because resource file length not equal with ByteSource");
            }
        }
        catch (IOException e) {
            throw new KylinRuntimeException(e);
        }
        return 1;
    }

    private FSDataOutputStream createFileWithDefaultPermission(Path f) throws IOException {
        return this.fs.create(f, null, true, this.fs.getConf().getInt("io.file.buffer.size", 4096), this.fs.getDefaultReplication(f), this.fs.getDefaultBlockSize(f), null);
    }

    @Override
    public NavigableSet<String> listAll() {
        try {
            if (this.compressedFilesContains("/")) {
                return Sets.newTreeSet(this.getAllFilePathFromCompressedFiles());
            }
            Path p = this.rootPath;
            if (!this.fs.exists(p) || !this.fs.isDirectory(p)) {
                log.warn("path {} does not exist in HDFS", (Object)p);
                return new TreeSet<String>();
            }
            Path replacedPath = Path.getPathWithoutSchemeAndAuthority((Path)this.rootPath);
            String replacedValue = this.fs.makeQualified(replacedPath).toString();
            return FileSystemMetadataStore.getAllFilePath(p, this.fs).parallelStream().map(path -> {
                String replaced = path.toString().replace(replacedValue + "/", "");
                return FileSystemMetadataStore.pathWithoutJsonSuffix(replaced);
            }).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new KylinRuntimeException(e);
        }
    }

    protected RawResource loadOne(FileStatus status, Path parentPath) throws IOException, InstantiationException, IllegalAccessException {
        Path p = status.getPath();
        if (status.getLen() == 0L) {
            log.warn("Zero length file: " + p.toString());
        }
        Path replacedPath = Path.getPathWithoutSchemeAndAuthority((Path)parentPath);
        String replacedValue = this.fs.makeQualified(replacedPath).toString();
        String replaced = p.toString().replace(replacedValue, "");
        if (MetadataChecker.verifyNonMetadataFile(replaced)) {
            return null;
        }
        Pair<MetadataType, String> srcPair = FileSystemMetadataStore.splitFilePath(replaced);
        Class<? extends RawResource> resourceClass = srcPair.getKey().getResourceClass();
        long ts = status.getModificationTime();
        try (FSDataInputStream in = this.fs.open(p);){
            RawResource res;
            String metaKey = srcPair.getValue().substring(0, srcPair.getValue().length() - 5);
            byte[] byteArray = IOUtils.toByteArray((InputStream)in);
            try {
                res = JsonUtil.readValue(byteArray, resourceClass);
            }
            catch (Exception e) {
                log.warn("Failed to load resource from file: " + p + ". This json file is broken!");
                res = resourceClass.newInstance();
            }
            if (res.getMetaKey() == null) {
                res.setMetaKey(metaKey);
            }
            res.setContent(byteArray);
            res.setMvcc(0L);
            res.setTs(ts);
            RawResource rawResource = res;
            return rawResource;
        }
    }

    @Override
    public void dump(ResourceStore store) throws IOException, InterruptedException, ExecutionException {
        NavigableSet<String> resources = store.listResourcesRecursively(MetadataType.ALL.name());
        if (Type.ZIP.name().equals(this.type.name())) {
            this.dumpToZip(store, resources, new Path(this.rootPath, COMPRESSED_FILE));
        } else {
            this.dumpToFile(store, resources);
        }
    }

    @Override
    public void dump(ResourceStore store, Collection<String> resources) throws IOException, InterruptedException {
        Path compressedFile = new Path(this.rootPath, COMPRESSED_FILE);
        this.dumpToZip(store, resources, compressedFile);
    }

    public void dumpToFile(ResourceStore resourceStore, Collection<String> resources) throws ExecutionException, InterruptedException {
        this.dumpKylinConfigToFile(resourceStore.getConfig());
        if (resources == null || resources.isEmpty()) {
            log.info("there is no resources to dump, please check.");
            return;
        }
        if (fileSystemMetadataExecutor == null || resources.size() < 10000) {
            try {
                super.dump(resourceStore, resources);
            }
            catch (Exception e) {
                throw new KylinRuntimeException(e);
            }
        } else {
            ArrayList<String> batchResources = new ArrayList<String>(10000);
            ArrayList futures = Lists.newArrayList();
            for (String resPath : resources) {
                batchResources.add(resPath);
                if (batchResources.size() < 10000) continue;
                futures.addAll(this.batchInsertByResources(batchResources, resourceStore));
                batchResources = new ArrayList(10000);
            }
            if (!batchResources.isEmpty()) {
                futures.addAll(this.batchInsertByResources(batchResources, resourceStore));
            }
            if (!futures.isEmpty()) {
                for (Future task : futures) {
                    task.get();
                }
            }
        }
    }

    public void dumpToZip(ResourceStore store, Collection<String> resources, Path compressedFile) throws IOException, InterruptedException {
        block29: {
            if (resources != null && !resources.isEmpty()) {
                try (FSDataOutputStream out = this.fs.create(compressedFile, true);
                     ZipOutputStream zipOut = new ZipOutputStream(new CheckedOutputStream((OutputStream)out, new CRC32()));){
                    for (String resPath : resources) {
                        RawResource raw = store.getResource(resPath);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (raw == null) continue;
                        this.compress(zipOut, raw, resPath);
                    }
                    break block29;
                }
                catch (IOException e) {
                    throw new IOException("Put compressed resource fail", e);
                }
            }
            log.info("there is no resources, please check.");
        }
    }

    private List<Future<Boolean>> batchInsertByResources(List<String> batchResources, ResourceStore resourceStore) {
        ArrayList taskList = Lists.newArrayList();
        List<String> innerBatchResources = batchResources;
        taskList.add(fileSystemMetadataExecutor.submit(() -> {
            for (String resource : innerBatchResources) {
                RawResource raw = resourceStore.getResource(resource);
                this.save(raw.getMetaType(), raw);
            }
            innerBatchResources.clear();
            return true;
        }));
        return taskList;
    }

    @Override
    public MetadataStore.MemoryMetaData reloadAll() throws IOException {
        Path compressedFile = this.getRealFileSystemPath(COMPRESSED_FILE);
        if (!this.fs.exists(compressedFile) || !this.fs.isFile(compressedFile)) {
            return this.getAllFile(this.rootPath);
        }
        log.info("reloadAll from metadata.zip");
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        this.getCompressedFiles().forEach((resPath, raw) -> data.put(raw.getMetaType(), new VersionedRawResource((RawResource)raw)));
        return data;
    }

    private void compress(ZipOutputStream out, RawResource raw, String resPath) throws IOException {
        ZipEntry entry = new ZipEntry(resPath + JSON_SUFFIX);
        entry.setTime(raw.getTs());
        out.putNextEntry(entry);
        this.compressHandlerInterface.write(out, raw);
    }

    public static Pair<MetadataType, String> splitFilePath(String resourcePath) {
        String[] split;
        if ("/".equals(resourcePath)) {
            return new Pair<MetadataType, Object>(MetadataType.ALL, null);
        }
        if (resourcePath.startsWith("/") && resourcePath.length() > 1) {
            resourcePath = resourcePath.substring(1);
        }
        if ((split = resourcePath.split("/", 2)).length < 2) {
            throw new KylinRuntimeException("resourcePath is invalid: " + resourcePath);
        }
        String typeStr = split[0].toUpperCase(Locale.ROOT);
        return new Pair<MetadataType, String>(MetadataType.create(typeStr), split[1]);
    }

    @VisibleForTesting
    protected Path getRealFileSystemPath(String resourcePath) {
        if (resourcePath.equals("/")) {
            return this.rootPath;
        }
        if (resourcePath.endsWith(".zip")) {
            return new Path(this.rootPath, resourcePath);
        }
        if (resourcePath.startsWith("/") && resourcePath.length() > 1) {
            resourcePath = resourcePath.substring(1);
        }
        return new Path(this.rootPath, resourcePath);
    }

    public static TreeSet<Path> getAllFilePath(Path filePath, FileSystem fs) {
        try {
            TreeSet fileList = Sets.newTreeSet();
            Arrays.stream(fs.listStatus(filePath)).forEach(status -> FileSystemMetadataStore.getAllFilePath(status.getPath(), fs, fileList));
            return fileList;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new KylinRuntimeException(e);
        }
    }

    MetadataStore.MemoryMetaData getAllFile(Path filePath) {
        Date startTime = new Date();
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        BiConsumer<FileStatus, MetadataStore.MemoryMetaData> loadMetadataProcess = (innerStat, dataHelper) -> {
            try {
                RawResource innerRaw = this.loadOne((FileStatus)innerStat, filePath);
                if (innerRaw != null) {
                    dataHelper.put(innerRaw.getMetaType(), new VersionedRawResource(innerRaw));
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                Throwables.throwIfUnchecked((Throwable)e);
            }
        };
        try {
            FileStatus[] fileStatuses = this.fs.listStatus(filePath);
            log.info("getAllFile from {} started", (Object)filePath);
            ArrayList futures = new ArrayList();
            for (FileStatus childStatus : fileStatuses) {
                this.getAndPutAllFileRecursion(childStatus, this.fs, data, futures, loadMetadataProcess);
            }
            for (Future future : futures) {
                Uninterruptibles.getUninterruptibly((Future)future);
            }
            log.info("getAllFile cost {} ms", (Object)(new Date().getTime() - startTime.getTime()));
            return data;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new KylinRuntimeException(e);
        }
    }

    private static void getAllFilePath(Path filePath, FileSystem fs, TreeSet<Path> fileList) {
        try {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(filePath)) {
                if (file.isDirectory()) {
                    FileSystemMetadataStore.getAllFilePath(file.getPath(), fs, fileList);
                    continue;
                }
                fileList.add(file.getPath());
            }
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
        }
    }

    public void getAndPutAllFileRecursion(FileStatus status, FileSystem fs, MetadataStore.MemoryMetaData data, List<Future<?>> futures, BiConsumer<FileStatus, MetadataStore.MemoryMetaData> process) {
        try {
            for (FileStatus childStatus : fs.listStatus(status.getPath())) {
                if (childStatus.isDirectory()) {
                    this.getAndPutAllFileRecursion(childStatus, fs, data, futures, process);
                    continue;
                }
                if (fileSystemMetadataExecutor != null) {
                    futures.add(fileSystemMetadataExecutor.submit(() -> process.accept(childStatus, data)));
                    continue;
                }
                process.accept(childStatus, data);
            }
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
        }
    }

    private List<String> getAllFilePathFromCompressedFiles() {
        return this.getCompressedFiles().keySet().stream().map(FileSystemMetadataStore::pathWithoutJsonSuffix).collect(Collectors.toList());
    }

    private void createMetaFolderIfNeed(Path metaDirName) {
        try {
            if (!this.fs.exists(metaDirName)) {
                this.fs.mkdirs(metaDirName);
            }
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
        }
    }

    private Map<String, RawResource> getFilesFromCompressedFile() {
        Path compressedFile = this.getRealFileSystemPath(COMPRESSED_FILE);
        return FileSystemMetadataStore.getFilesFromCompressedFile(compressedFile, this.compressHandlerInterface, this.fs);
    }

    public static Map<String, RawResource> getFilesFromCompressedFile(Path compressedFile, CompressHandlerInterface handler, FileSystem fs) {
        try {
            if (fs == null || !fs.exists(compressedFile) || !fs.isFile(compressedFile)) {
                return Maps.newHashMap();
            }
        }
        catch (IOException e) {
            log.warn("Check file failed. ", (Throwable)e);
            return Maps.newHashMap();
        }
        try {
            return FileSystemMetadataStore.getFilesFromCompressedFileByStream((InputStream)fs.open(compressedFile), handler);
        }
        catch (IOException e) {
            log.warn("Get file from compressed file error", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<String, RawResource> getFilesFromCompressedFileByStream(InputStream stream, CompressHandlerInterface handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean compressedFilesContains(String path) {
        if (File.separator.equals(path)) {
            return !this.getCompressedFiles().isEmpty();
        }
        return this.getCompressedFiles().keySet().stream().anyMatch(file -> file.startsWith(path + "/") || file.equals(path));
    }

    private static String pathWithoutJsonSuffix(String path) {
        if (path.endsWith(JSON_SUFFIX)) {
            path = path.substring(0, path.length() - JSON_SUFFIX.length());
        }
        return path;
    }

    @Generated
    public Path getRootPath() {
        return this.rootPath;
    }

    @Generated
    public FileSystem getFs() {
        return this.fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, RawResource> getCompressedFiles() {
        Object value = this.compressedFiles.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.compressedFiles;
            synchronized (atomicReference) {
                value = this.compressedFiles.get();
                if (value == null) {
                    Map<String, RawResource> actualValue = this.getFilesFromCompressedFile();
                    value = actualValue == null ? this.compressedFiles : actualValue;
                    this.compressedFiles.set(value);
                }
            }
        }
        return (Map)(value == this.compressedFiles ? null : value);
    }

    @Override
    @Generated
    public TransactionStatus getTransaction() throws TransactionException {
        return this.helper.getTransaction();
    }

    @Override
    @Generated
    public void commit(TransactionStatus status) throws TransactionException {
        this.helper.commit(status);
    }

    @Override
    @Generated
    public void rollback(TransactionStatus status) throws TransactionException {
        this.helper.rollback(status);
    }

    @Generated
    public void lockResource(String lockPath) {
        this.helper.lockResource(lockPath);
    }

    public static class SnapShotCompressHandler
    implements CompressHandlerInterface {
        @Override
        public <T extends RawResource> T read(InputStream in, String resPath, long time, MetadataType type) throws IOException {
            SnapshotRawResource snap = JsonUtil.readValue(IOUtils.toByteArray((InputStream)in), SnapshotRawResource.class);
            String name = resPath.substring(resPath.lastIndexOf("/") + 1);
            return (T)RawResource.constructResource(type, snap.getByteSource(), snap.getTimestamp(), snap.getMvcc(), FileSystemMetadataStore.pathWithoutJsonSuffix(name));
        }

        @Override
        public void write(OutputStream out, RawResource raw) throws IOException {
            SnapshotRawResource snapshotRawResource = new SnapshotRawResource(raw);
            out.write(JsonUtil.writeValueAsIndentBytes(snapshotRawResource));
        }
    }

    @VisibleForTesting
    public static class CompressHandler
    implements CompressHandlerInterface {
        @Override
        public <T extends RawResource> T read(InputStream in, String resPath, long time, MetadataType type) throws IOException {
            byte[] raw = IOUtils.toByteArray((InputStream)in);
            String name = resPath.substring(resPath.lastIndexOf("/") + 1);
            String metaKey = FileSystemMetadataStore.pathWithoutJsonSuffix(name);
            return (T)RawResource.constructResource(type, ByteSource.wrap((byte[])raw), time, 0L, metaKey);
        }

        @Override
        public void write(OutputStream out, RawResource raw) throws IOException {
            try (InputStream inputStream = ByteSource.wrap((byte[])raw.getContent()).openStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
        }
    }

    public static interface CompressHandlerInterface {
        public <T extends RawResource> T read(InputStream var1, String var2, long var3, MetadataType var5) throws IOException;

        public void write(OutputStream var1, RawResource var2) throws IOException;
    }

    public static enum Type {
        DIR,
        ZIP;

    }
}

