/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.mail;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.mail.MailService;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotifier {
    protected static final Logger logger = LoggerFactory.getLogger(MailNotifier.class);

    private MailNotifier() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean notifyUser(KylinConfig kylinConfig, Pair<String, String> mail, List<String> users) {
        if (CollectionUtils.isEmpty(users)) {
            logger.warn("user list is empty, not need to notify users.");
            return false;
        }
        if (Objects.isNull(mail)) {
            logger.error("mail content is null, not need to notify users.");
            return false;
        }
        logger.info("prepare to send email {} to: {}", (Object)mail.getFirst(), users);
        try {
            return new MailService(kylinConfig).sendMail(users, mail.getFirst(), mail.getSecond());
        }
        catch (Exception e) {
            logger.error("notify user {} failed!", (Object)mail.getFirst(), (Object)e);
            return false;
        }
    }
}

