/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.blacklist;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.blacklist.SQLBlacklistItem;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SQLBlacklist
extends RootPersistentEntity
implements Serializable {
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="blacklist_items")
    private List<SQLBlacklistItem> blacklistItems;

    public SQLBlacklist() {
        this.updateRandomUuid();
    }

    public SQLBlacklist(String project) {
        this();
        this.project = project;
    }

    public List<SQLBlacklistItem> getBlacklistItems() {
        return this.blacklistItems;
    }

    public void setBlacklistItems(List<SQLBlacklistItem> blacklistItems) {
        this.blacklistItems = blacklistItems;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void addBlacklistItem(SQLBlacklistItem sqlBlacklistItem) {
        if (null == this.blacklistItems) {
            this.blacklistItems = Lists.newArrayList();
        }
        this.blacklistItems.add(sqlBlacklistItem);
    }

    public SQLBlacklistItem getSqlBlacklistItem(String id) {
        if (null == this.blacklistItems || this.blacklistItems.isEmpty()) {
            return null;
        }
        for (SQLBlacklistItem sqlBlacklistItem : this.blacklistItems) {
            if (!id.equals(sqlBlacklistItem.getId())) continue;
            return sqlBlacklistItem;
        }
        return null;
    }

    public SQLBlacklistItem getSqlBlacklistItemByRegex(String regex) {
        if (null == this.blacklistItems || this.blacklistItems.isEmpty()) {
            return null;
        }
        for (SQLBlacklistItem sqlBlacklistItem : this.blacklistItems) {
            if (!regex.equals(sqlBlacklistItem.getRegex())) continue;
            return sqlBlacklistItem;
        }
        return null;
    }

    public SQLBlacklistItem getSqlBlacklistItemBySql(String sql) {
        if (null == this.blacklistItems || this.blacklistItems.isEmpty()) {
            return null;
        }
        for (SQLBlacklistItem sqlBlacklistItem : this.blacklistItems) {
            if (!sql.equals(sqlBlacklistItem.getSql())) continue;
            return sqlBlacklistItem;
        }
        return null;
    }

    public SQLBlacklistItem match(String sql) {
        if (null == this.blacklistItems || this.blacklistItems.isEmpty()) {
            return null;
        }
        for (SQLBlacklistItem sqlBlacklistItem : this.blacklistItems) {
            if (!sqlBlacklistItem.match(sql)) continue;
            return sqlBlacklistItem;
        }
        return null;
    }

    public void deleteSqlBlacklistItem(String id) {
        if (null == this.blacklistItems || this.blacklistItems.isEmpty()) {
            return;
        }
        ArrayList newBlacklistItems = Lists.newArrayList();
        for (SQLBlacklistItem item : this.blacklistItems) {
            if (item.getId().equals(id)) continue;
            newBlacklistItems.add(item);
        }
        this.setBlacklistItems(newBlacklistItems);
    }

    public String resourceName() {
        return this.project;
    }

    public MetadataType resourceType() {
        return MetadataType.SQL_BLACKLIST;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLBlacklist)) {
            return false;
        }
        SQLBlacklist other = (SQLBlacklist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        List<SQLBlacklistItem> this$blacklistItems = this.getBlacklistItems();
        List<SQLBlacklistItem> other$blacklistItems = other.getBlacklistItems();
        return !(this$blacklistItems == null ? other$blacklistItems != null : !((Object)this$blacklistItems).equals(other$blacklistItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLBlacklist;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        List<SQLBlacklistItem> $blacklistItems = this.getBlacklistItems();
        result = result * 59 + ($blacklistItems == null ? 43 : ((Object)$blacklistItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SQLBlacklist(project=" + this.getProject() + ", blacklistItems=" + this.getBlacklistItems() + ")";
    }
}

