/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.type;

import io.substrait.proto.Type;
import java.io.Serializable;
import org.apache.gluten.substrait.type.TypeNode;

public class DecimalTypeNode
implements TypeNode,
Serializable {
    public final Boolean nullable;
    public final int precision;
    public final int scale;

    public DecimalTypeNode(Boolean nullable, int precision, int scale) {
        this.nullable = nullable;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public Type toProtobuf() {
        Type.Decimal.Builder decimalBuilder = Type.Decimal.newBuilder();
        decimalBuilder.setPrecision(this.precision);
        decimalBuilder.setScale(this.scale);
        if (this.nullable.booleanValue()) {
            decimalBuilder.setNullability(Type.Nullability.NULLABILITY_NULLABLE);
        } else {
            decimalBuilder.setNullability(Type.Nullability.NULLABILITY_REQUIRED);
        }
        Type.Builder builder = Type.newBuilder();
        builder.setDecimal(decimalBuilder.build());
        return builder.build();
    }
}

