/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import com.google.protobuf.ByteString;
import io.substrait.proto.Expression;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.BinaryTypeNode;
import org.apache.gluten.substrait.type.TypeNode;

public class BinaryLiteralNode
extends LiteralNodeWithValue<byte[]> {
    public BinaryLiteralNode(byte[] value) {
        super(value, new BinaryTypeNode(true));
    }

    public BinaryLiteralNode(byte[] value, TypeNode typeNode) {
        super(value, typeNode);
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, byte[] value) {
        ByteString byteValue;
        try {
            Method m = ByteString.class.getDeclaredMethod("wrap", byte[].class);
            m.setAccessible(true);
            byteValue = (ByteString)m.invoke(null, new Object[]{value});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        literalBuilder.setBinary(byteValue);
    }
}

