/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.DelegatingOutputStream;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);

    private HadoopStreams() {
    }

    static SeekableInputStream wrap(FSDataInputStream stream) {
        return new HadoopSeekableInputStream(stream);
    }

    static PositionOutputStream wrap(FSDataOutputStream stream) {
        return new HadoopPositionOutputStream(stream);
    }

    public static FSInputStream wrap(SeekableInputStream stream) {
        return new WrappedSeekableInputStream(stream);
    }

    private static class WrappedSeekableInputStream
    extends FSInputStream
    implements DelegatingInputStream {
        private final SeekableInputStream inputStream;

        private WrappedSeekableInputStream(SeekableInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void seek(long pos) throws IOException {
            this.inputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.inputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException("seekToNewSource not supported");
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public InputStream getDelegate() {
            return this.inputStream;
        }
    }

    private static class HadoopPositionOutputStream
    extends PositionOutputStream
    implements DelegatingOutputStream {
        private final FSDataOutputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopPositionOutputStream(FSDataOutputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        public OutputStream getDelegate() {
            return this.stream;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
            }
        }
    }

    private static class HadoopSeekableInputStream
    extends SeekableInputStream
    implements DelegatingInputStream {
        private final FSDataInputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopSeekableInputStream(FSDataInputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        public InputStream getDelegate() {
            return this.stream;
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public int read(ByteBuffer buf) throws IOException {
            return this.stream.read(buf);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
            }
        }
    }
}

