/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.iceberg.util.UUIDUtil;

public class UUIDConversion
extends Conversion<UUID> {
    public Class<UUID> getConvertedType() {
        return UUID.class;
    }

    public String getLogicalTypeName() {
        return LogicalTypes.uuid().getName();
    }

    public UUID fromFixed(GenericFixed value, Schema schema, LogicalType type) {
        return UUIDUtil.convert((byte[])value.bytes());
    }

    public GenericFixed toFixed(UUID value, Schema schema, LogicalType type) {
        return new GenericData.Fixed(schema, UUIDUtil.convert((UUID)value));
    }
}

