/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.clickhouse.utils;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.ClickHouseConfig$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class CHDataSourceUtils$
implements Logging {
    public static CHDataSourceUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CHDataSourceUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isClickHouseTable(CatalogTable table) {
        return this.isClickHouseTable((Option<String>)table.provider());
    }

    public boolean isClickHouseTable(Option<String> provider) {
        return provider.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)CHDataSourceUtils$.MODULE$.isClickHouseDataSourceName(name)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClickHouseDataSourceName(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        String string2 = ClickHouseConfig$.MODULE$.NAME();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = name.toLowerCase(Locale.ROOT);
        String string4 = ClickHouseConfig$.MODULE$.ALT_NAME();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public boolean isClickHouseTable(SparkSession spark, TableIdentifier tableName) {
        SessionCatalog catalog = spark.sessionState().catalog();
        boolean tableIsNotTemporaryTable = !catalog.isTempView(tableName);
        boolean tableExists = (tableName.database().isEmpty() || catalog.databaseExists((String)tableName.database().get())) && catalog.tableExists(tableName);
        return tableIsNotTemporaryTable && tableExists && this.isClickHouseTable(catalog.getTableMetadata(tableName));
    }

    public boolean isClickhousePath(SparkSession spark, TableIdentifier identifier) {
        SessionCatalog catalog = spark.sessionState().catalog();
        return spark.sessionState().conf().runSQLonFile() && this.isClickHouseTable((Option<String>)identifier.database()) && !CHDataSourceUtils$.tableIsTemporaryTable$1(catalog, identifier) && !this.tableExists$1(catalog, identifier) && new Path(identifier.table()).isAbsolute();
    }

    public Option<Path> findClickHouseTableRoot(SparkSession spark, Path path, Map<String, String> options) {
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConfWithOptions(options));
        for (Path currentPath = path; currentPath != null; currentPath = currentPath.getParent()) {
            String string = currentPath.getName();
            String string2 = ClickHouseConfig$.MODULE$.METADATA_DIR();
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            String string3 = currentPath.getName();
            String string4 = "_samples";
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break;
            Path deltaLogPath = new Path(currentPath, ClickHouseConfig$.MODULE$.METADATA_DIR());
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fs.exists(deltaLogPath)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) continue;
            return Option$.MODULE$.apply((Object)currentPath);
        }
        return None$.MODULE$;
    }

    public Map<String, String> findClickHouseTableRoot$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public void ensureClickHouseTableV2(Option<TableIdentifier> tableId, SparkSession sparkSession) {
        if (tableId.isEmpty()) {
            throw new UnsupportedOperationException("Current command requires table identifier.");
        }
        Table table = CatalogV2Implicits$.MODULE$.CatalogHelper(sparkSession.sessionState().catalogManager().currentCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{(String)((TableIdentifier)tableId.get()).database().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSession.sessionState().catalogManager().currentNamespace())).head())})), (String)((TableIdentifier)tableId.get()).table()));
        table.name();
    }

    private static final boolean tableIsTemporaryTable$1(SessionCatalog catalog$1, TableIdentifier identifier$1) {
        return catalog$1.isTempView(identifier$1);
    }

    private final boolean tableExists$1(SessionCatalog catalog$1, TableIdentifier identifier$1) {
        boolean bl;
        block4: {
            try {
                if (catalog$1.databaseExists((String)identifier$1.database().get()) && catalog$1.tableExists(identifier$1)) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                AnalysisException analysisException;
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof AnalysisException) || !DeltaTableIdentifier$.MODULE$.gluePermissionError(analysisException = (AnalysisException)throwable2)) {
                    throw throwable;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Received an access denied error from Glue. Will check to see if this ").append("identifier (").append(identifier$1).append(") is path based.").toString(), (Throwable)analysisException);
                boolean bl2 = false;
                bl = bl2;
            }
        }
        return bl;
    }

    private CHDataSourceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

