/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.iterator.ClosableIterator;
import org.apache.gluten.metrics.NativeMetrics;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class BatchIterator
extends ClosableIterator {
    private final long handle;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public BatchIterator(long handle) {
        this.handle = handle;
    }

    private native boolean nativeHasNext(long var1);

    private native long nativeCHNext(long var1);

    private native void nativeClose(long var1);

    private native void nativeCancel(long var1);

    private native String nativeFetchMetrics(long var1);

    public boolean hasNext0() {
        return this.nativeHasNext(this.handle);
    }

    public ColumnarBatch next0() {
        long block = this.nativeCHNext(this.handle);
        CHNativeBlock nativeBlock = new CHNativeBlock(block);
        return nativeBlock.toColumnarBatch();
    }

    public NativeMetrics getMetrics() {
        return new NativeMetrics(this.nativeFetchMetrics(this.handle));
    }

    public void close0() {
        this.nativeClose(this.handle);
    }

    public final void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.nativeCancel(this.handle);
        }
    }
}

