/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.spark.memory.SparkMemoryUtil;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.task.TaskResources;
import org.apache.spark.util.Utils;

public class ThrowOnOomMemoryTarget
implements MemoryTarget {
    private final MemoryTarget target;

    public ThrowOnOomMemoryTarget(MemoryTarget target) {
        this.target = target;
    }

    @Override
    public long borrow(long size) {
        long granted = this.target.borrow(size);
        if (granted >= size) {
            return granted;
        }
        if (granted != 0L) {
            this.target.repay(granted);
        }
        if (TaskResources.inSparkTask()) {
            TaskResources.getLocalTaskContext().taskMemoryManager().showMemoryUsage();
        }
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append(String.format("Not enough spark off-heap execution memory. Acquired: %s, granted: %s. Try tweaking config option spark.memory.offHeap.size to get larger space to run this application (if spark.gluten.memory.dynamic.offHeap.sizing.enabled is not enabled). %n", Utils.bytesToString((long)size), Utils.bytesToString((long)granted))).append("Current config settings: ").append(System.lineSeparator()).append(String.format("\t%s=%s", GlutenConfig$.MODULE$.GLUTEN_OFFHEAP_SIZE_IN_BYTES_KEY(), ThrowOnOomMemoryTarget.reformatBytes(SQLConf.get().getConfString(GlutenConfig$.MODULE$.GLUTEN_OFFHEAP_SIZE_IN_BYTES_KEY())))).append(System.lineSeparator()).append(String.format("\t%s=%s", GlutenConfig$.MODULE$.GLUTEN_TASK_OFFHEAP_SIZE_IN_BYTES_KEY(), ThrowOnOomMemoryTarget.reformatBytes(SQLConf.get().getConfString(GlutenConfig$.MODULE$.GLUTEN_TASK_OFFHEAP_SIZE_IN_BYTES_KEY())))).append(System.lineSeparator()).append(String.format("\t%s=%s", GlutenConfig$.MODULE$.GLUTEN_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES_KEY(), ThrowOnOomMemoryTarget.reformatBytes(SQLConf.get().getConfString(GlutenConfig$.MODULE$.GLUTEN_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES_KEY())))).append(System.lineSeparator()).append(String.format("\t%s=%s", GlutenConfig$.MODULE$.SPARK_OFFHEAP_ENABLED(), SQLConf.get().getConfString(GlutenConfig$.MODULE$.SPARK_OFFHEAP_ENABLED()))).append(System.lineSeparator()).append(String.format("\t%s=%s", GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED(), SQLConf.get().getConfString(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED()))).append(System.lineSeparator());
        errorBuilder.append(SparkMemoryUtil.dumpMemoryTargetStats(this.target));
        errorBuilder.append(System.lineSeparator());
        throw new OutOfMemoryException(errorBuilder.toString());
    }

    private static String reformatBytes(String in) {
        return Utils.bytesToString((long)Utils.byteStringAsBytes((String)in));
    }

    @Override
    public long repay(long size) {
        return this.target.repay(size);
    }

    @Override
    public long usedBytes() {
        return this.target.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MemoryTarget target() {
        return this.target;
    }

    public static class OutOfMemoryException
    extends RuntimeException {
        public OutOfMemoryException(String message) {
            super(message);
        }
    }
}

