/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.sql.Date;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Predef$;

public final class KapDateTimeUtils$ {
    public static KapDateTimeUtils$ MODULE$;
    private final long MONTHS_PER_QUARTER;
    private final long QUARTERS_PER_YEAR;

    static {
        new KapDateTimeUtils$();
    }

    public final long MONTHS_PER_QUARTER() {
        return this.MONTHS_PER_QUARTER;
    }

    public final long QUARTERS_PER_YEAR() {
        return this.QUARTERS_PER_YEAR;
    }

    public TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    public long addMonths(long timestamp, int m) {
        long ms = timestamp / 1000L;
        int day0 = this.millisToDaysLegacy(ms, TimeZone.getTimeZone(ZoneId.systemDefault()));
        long millis = ms - (long)day0 * 86400000L;
        int x = this.dateAddMonths(day0, m);
        return ((long)x * 86400000L + millis) * 1000L;
    }

    public int dateSubtractMonths(int date0, int date1) {
        if (date0 < date1) {
            return -this.dateSubtractMonths(date1, date0);
        }
        int m = (date0 - date1) / 31;
        int date2;
        while ((date2 = this.dateAddMonths(date1, m)) < date0) {
            int date3 = this.dateAddMonths(date1, m + 1);
            if (date3 > date0) {
                return m;
            }
            ++m;
        }
        return m;
    }

    public int subtractMonths(long t0, long t1) {
        int x;
        block1: {
            long millis0 = this.floorMod(t0, 86400000L);
            int d0 = this.millisToDaysLegacy(t0, TimeZone.getTimeZone(ZoneId.systemDefault()));
            long millis1 = this.floorMod(t1, 86400000L);
            int d1 = this.millisToDaysLegacy(t1, TimeZone.getTimeZone(ZoneId.systemDefault()));
            x = this.dateSubtractMonths(d0, d1);
            int d2 = this.dateAddMonths(d1, x);
            if (x > 0 && d2 == d0 && millis0 < millis1) {
                --x;
            }
            if (x >= 0 || d2 != d0 || millis0 <= millis1) break block1;
            ++x;
        }
        return x;
    }

    public int millisToDaysLegacy(long millisUtc, TimeZone timeZone) {
        long millisLocal = millisUtc + (long)timeZone.getOffset(millisUtc);
        return (int)Math.floor((double)millisLocal / (double)86400000L);
    }

    public int fromJavaDateLegacy(Date date) {
        return this.millisToDaysLegacy(date.getTime(), TimeZone.getTimeZone(ZoneId.systemDefault()));
    }

    public long daysToMillis(int days) {
        return this.daysToMillis(days, this.defaultTimeZone());
    }

    public long daysToMillis(int days, TimeZone timeZone) {
        long millisLocal = (long)days * 86400000L;
        return millisLocal - this.getOffsetFromLocalMillis(millisLocal, timeZone);
    }

    public long getOffsetFromLocalMillis(long millisLocal, TimeZone tz) {
        int guess;
        block1: {
            guess = tz.getRawOffset();
            int offset = tz.getOffset(millisLocal - (long)guess);
            if (offset == guess || (guess = tz.getOffset(millisLocal - (long)offset)) == offset) break block1;
            int days = (int)Math.floor((double)millisLocal / (double)86400000L);
            int year = DateTimeUtils$.MODULE$.getYear(days);
            int month = DateTimeUtils$.MODULE$.getMonth(days);
            int day = DateTimeUtils$.MODULE$.getDayOfMonth(days);
            int millisOfDay = (int)(millisLocal % 86400000L);
            if (millisOfDay < 0) {
                millisOfDay += (int)86400000L;
            }
            int seconds = (int)((long)millisOfDay / 1000L);
            int hh = seconds / 3600;
            int mm = seconds / 60 % 60;
            int ss = seconds % 60;
            int ms = millisOfDay % 1000;
            Calendar calendar = Calendar.getInstance(tz, Locale.getDefault(Locale.Category.FORMAT));
            calendar.set(year, month - 1, day, hh, mm, ss);
            calendar.set(14, ms);
            guess = (int)(millisLocal - calendar.getTimeInMillis());
        }
        return guess;
    }

    public int dateAddMonths(int date, int m) {
        int d0;
        int m0;
        int y0;
        block1: {
            y0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
            m0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)date);
            d0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.DAY, (long)date);
            int endOfMonth = this.lastDay(y0, m0);
            int y = (m + m0) / 12;
            y0 += y;
            if ((m0 = m + m0 - y * 12) <= 0) {
                Predef$.MODULE$.assert((m0 += 12) > 0);
                --y0;
            }
            int last = this.lastDay(y0, m0);
            if (d0 != endOfMonth && d0 <= last) break block1;
            d0 = last;
        }
        return DateTimeUtils.ymdToUnixDate((int)y0, (int)m0, (int)d0);
    }

    public long floorDiv(long x, long y) {
        long r;
        block0: {
            r = x / y;
            if ((x ^ y) >= 0L || r * y == x) break block0;
            --r;
        }
        return r;
    }

    public long floorMod(long x, long y) {
        return x - this.floorDiv(x, y) * y;
    }

    private int lastDay(int y, int m) {
        int n;
        int n2 = m;
        switch (n2) {
            case 2: {
                if (y % 4 == 0 && (y % 100 != 0 || y % 400 == 0)) {
                    n = 29;
                    break;
                }
                n = 28;
                break;
            }
            case 4: {
                n = 30;
                break;
            }
            case 6: {
                n = 30;
                break;
            }
            case 9: {
                n = 30;
                break;
            }
            case 11: {
                n = 30;
                break;
            }
            default: {
                n = 31;
                break;
            }
        }
        return n;
    }

    private KapDateTimeUtils$() {
        MODULE$ = this;
        this.MONTHS_PER_QUARTER = 3L;
        this.QUARTERS_PER_YEAR = 4L;
    }
}

