/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.CriteriaGroup;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.AbstractHavingFinisher;
import org.mybatis.dynamic.sql.select.AbstractHavingStarter;
import org.mybatis.dynamic.sql.select.AbstractQueryExpressionDSL;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.HavingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.join.JoinType;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.AbstractWhereFinisher;
import org.mybatis.dynamic.sql.where.AbstractWhereStarter;
import org.mybatis.dynamic.sql.where.WhereModel;

public class QueryExpressionDSL<R>
extends AbstractQueryExpressionDSL<QueryExpressionWhereBuilder, QueryExpressionDSL<R>>
implements Buildable<R> {
    private final String connector;
    private final SelectDSL<R> selectDSL;
    private final boolean isDistinct;
    private final List<BasicColumn> selectList;
    private QueryExpressionWhereBuilder whereBuilder;
    private GroupByModel groupByModel;
    private final StatementConfiguration statementConfiguration = new StatementConfiguration();
    private QueryExpressionHavingBuilder havingBuilder;

    protected QueryExpressionDSL(FromGatherer<R> fromGatherer, TableExpression table) {
        super(table);
        this.connector = ((FromGatherer)fromGatherer).connector;
        this.selectList = ((FromGatherer)fromGatherer).selectList;
        this.isDistinct = ((FromGatherer)fromGatherer).isDistinct;
        this.selectDSL = Objects.requireNonNull(((FromGatherer)fromGatherer).selectDSL);
        this.selectDSL.registerQueryExpression(this);
    }

    protected QueryExpressionDSL(FromGatherer<R> fromGatherer, SqlTable table, String tableAlias) {
        this(fromGatherer, table);
        this.addTableAlias(table, tableAlias);
    }

    @Override
    public QueryExpressionWhereBuilder where() {
        if (this.whereBuilder == null) {
            this.whereBuilder = new QueryExpressionWhereBuilder();
        }
        return this.whereBuilder;
    }

    @Override
    public QueryExpressionDSL<R> configureStatement(Consumer<StatementConfiguration> consumer) {
        consumer.accept(this.statementConfiguration);
        return this;
    }

    protected QueryExpressionHavingBuilder having() {
        if (this.havingBuilder == null) {
            this.havingBuilder = new QueryExpressionHavingBuilder();
        }
        return this.havingBuilder;
    }

    protected void applyHaving(CriteriaGroup criteriaGroup) {
        this.having().initialize(criteriaGroup);
    }

    @Override
    @NotNull
    public R build() {
        return this.selectDSL.build();
    }

    public JoinSpecificationStarter join(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.INNER);
    }

    public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
        this.addTableAlias(joinTable, tableAlias);
        return this.join(joinTable);
    }

    public JoinSpecificationStarter join(Buildable<SelectModel> joinTable, String tableAlias) {
        return new JoinSpecificationStarter(QueryExpressionDSL.buildSubQuery(joinTable, tableAlias), JoinType.INNER);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.LEFT);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
        this.addTableAlias(joinTable, tableAlias);
        return this.leftJoin(joinTable);
    }

    public JoinSpecificationStarter leftJoin(Buildable<SelectModel> joinTable, String tableAlias) {
        return new JoinSpecificationStarter(QueryExpressionDSL.buildSubQuery(joinTable, tableAlias), JoinType.LEFT);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.RIGHT);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
        this.addTableAlias(joinTable, tableAlias);
        return this.rightJoin(joinTable);
    }

    public JoinSpecificationStarter rightJoin(Buildable<SelectModel> joinTable, String tableAlias) {
        return new JoinSpecificationStarter(QueryExpressionDSL.buildSubQuery(joinTable, tableAlias), JoinType.RIGHT);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.FULL);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
        this.addTableAlias(joinTable, tableAlias);
        return this.fullJoin(joinTable);
    }

    public JoinSpecificationStarter fullJoin(Buildable<SelectModel> joinTable, String tableAlias) {
        return new JoinSpecificationStarter(QueryExpressionDSL.buildSubQuery(joinTable, tableAlias), JoinType.FULL);
    }

    public GroupByFinisher groupBy(BasicColumn ... columns) {
        return this.groupBy(Arrays.asList(columns));
    }

    public GroupByFinisher groupBy(Collection<BasicColumn> columns) {
        this.groupByModel = GroupByModel.of(columns);
        return new GroupByFinisher();
    }

    public SelectDSL<R> orderBy(SortSpecification ... columns) {
        return this.orderBy(Arrays.asList(columns));
    }

    public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
        this.selectDSL.orderBy(columns);
        return this.selectDSL;
    }

    public UnionBuilder union() {
        return new UnionBuilder("union");
    }

    public UnionBuilder unionAll() {
        return new UnionBuilder("union all");
    }

    protected QueryExpressionModel buildModel() {
        QueryExpressionModel.Builder builder = QueryExpressionModel.withSelectList(this.selectList).withConnector(this.connector).withTable(this.table()).isDistinct(this.isDistinct).withTableAliases(this.tableAliases()).withJoinModel(this.buildJoinModel().orElse(null)).withGroupByModel(this.groupByModel);
        if (this.whereBuilder != null) {
            builder.withWhereModel(this.whereBuilder.buildWhereModel());
        }
        if (this.havingBuilder != null) {
            builder.withHavingModel(this.havingBuilder.buildHavingModel());
        }
        return builder.build();
    }

    public SelectDSL.LimitFinisher limit(long limit) {
        return this.selectDSL.limit(limit);
    }

    public SelectDSL.OffsetFirstFinisher offset(long offset) {
        return this.selectDSL.offset(offset);
    }

    public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        return this.selectDSL.fetchFirst(fetchFirstRows);
    }

    @Override
    protected QueryExpressionDSL<R> getThis() {
        return this;
    }

    public static class FromGatherer<R> {
        private final String connector;
        private final List<BasicColumn> selectList;
        private final SelectDSL<R> selectDSL;
        private final boolean isDistinct;

        public FromGatherer(Builder<R> builder) {
            this.connector = ((Builder)builder).connector;
            this.selectList = ((Builder)builder).selectList;
            this.selectDSL = Objects.requireNonNull(((Builder)builder).selectDSL);
            this.isDistinct = ((Builder)builder).isDistinct;
        }

        public QueryExpressionDSL<R> from(Buildable<SelectModel> select) {
            return new QueryExpressionDSL(this, AbstractQueryExpressionDSL.buildSubQuery(select));
        }

        public QueryExpressionDSL<R> from(Buildable<SelectModel> select, String tableAlias) {
            return new QueryExpressionDSL(this, AbstractQueryExpressionDSL.buildSubQuery(select, tableAlias));
        }

        public QueryExpressionDSL<R> from(SqlTable table) {
            return new QueryExpressionDSL(this, table);
        }

        public QueryExpressionDSL<R> from(SqlTable table, String tableAlias) {
            return new QueryExpressionDSL(this, table, tableAlias);
        }

        public static class Builder<R> {
            private String connector;
            private final List<BasicColumn> selectList = new ArrayList<BasicColumn>();
            private SelectDSL<R> selectDSL;
            private boolean isDistinct;

            public Builder<R> withConnector(String connector) {
                this.connector = connector;
                return this;
            }

            public Builder<R> withSelectList(Collection<BasicColumn> selectList2) {
                this.selectList.addAll(selectList2);
                return this;
            }

            public Builder<R> withSelectDSL(SelectDSL<R> selectDSL) {
                this.selectDSL = selectDSL;
                return this;
            }

            public Builder<R> isDistinct() {
                this.isDistinct = true;
                return this;
            }

            public FromGatherer<R> build() {
                return new FromGatherer(this);
            }
        }
    }

    public class QueryExpressionWhereBuilder
    extends AbstractWhereFinisher<QueryExpressionWhereBuilder>
    implements Buildable<R> {
        private QueryExpressionWhereBuilder() {
            super(QueryExpressionDSL.this.statementConfiguration);
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return this.orderBy(Arrays.asList(columns));
        }

        public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        public GroupByFinisher groupBy(BasicColumn ... columns) {
            return this.groupBy(Arrays.asList(columns));
        }

        public GroupByFinisher groupBy(Collection<BasicColumn> columns) {
            return QueryExpressionDSL.this.groupBy(columns);
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        @Override
        protected QueryExpressionWhereBuilder getThis() {
            return this;
        }

        protected WhereModel buildWhereModel() {
            return super.buildModel();
        }
    }

    public class QueryExpressionHavingBuilder
    extends AbstractHavingFinisher<QueryExpressionHavingBuilder>
    implements Buildable<R> {
        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return this.orderBy(Arrays.asList(columns));
        }

        public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        @Override
        protected QueryExpressionHavingBuilder getThis() {
            return this;
        }

        protected HavingModel buildHavingModel() {
            return super.buildModel();
        }
    }

    public class JoinSpecificationStarter {
        private final TableExpression joinTable;
        private final JoinType joinType;

        public JoinSpecificationStarter(TableExpression joinTable, JoinType joinType) {
            this.joinTable = joinTable;
            this.joinType = joinType;
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition joinCondition) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, joinCondition, this.joinType);
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition onJoinCondition, JoinCriterion ... andJoinCriteria) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, onJoinCondition, this.joinType, andJoinCriteria);
        }
    }

    public class GroupByFinisher
    extends AbstractHavingStarter<QueryExpressionHavingBuilder>
    implements Buildable<R> {
        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return this.orderBy(Arrays.asList(columns));
        }

        public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }

        @Override
        public QueryExpressionHavingBuilder having() {
            return QueryExpressionDSL.this.having();
        }
    }

    public class UnionBuilder {
        protected final String connector;

        public UnionBuilder(String connector) {
            this.connector = connector;
        }

        public FromGatherer<R> select(BasicColumn ... selectList2) {
            return this.select(Arrays.asList(selectList2));
        }

        public FromGatherer<R> select(List<BasicColumn> selectList2) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList2).withSelectDSL(QueryExpressionDSL.this.selectDSL).build();
        }

        public FromGatherer<R> selectDistinct(BasicColumn ... selectList2) {
            return this.selectDistinct(Arrays.asList(selectList2));
        }

        public FromGatherer<R> selectDistinct(List<BasicColumn> selectList2) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList2).withSelectDSL(QueryExpressionDSL.this.selectDSL).isDistinct().build();
        }
    }

    public class JoinSpecificationFinisher
    extends AbstractWhereStarter<QueryExpressionWhereBuilder, JoinSpecificationFinisher>
    implements Buildable<R> {
        private final JoinSpecification.Builder joinSpecificationBuilder;

        public JoinSpecificationFinisher(TableExpression table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType) {
            JoinCriterion joinCriterion = new JoinCriterion.Builder().withConnector("on").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder = JoinSpecification.withJoinTable(table).withJoinType(joinType).withJoinCriterion(joinCriterion);
            QueryExpressionDSL.this.addJoinSpecificationBuilder(this.joinSpecificationBuilder);
        }

        public JoinSpecificationFinisher(TableExpression table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType, JoinCriterion ... andJoinCriteria) {
            JoinCriterion onJoinCriterion = new JoinCriterion.Builder().withConnector("on").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder = JoinSpecification.withJoinTable(table).withJoinType(joinType).withJoinCriterion(onJoinCriterion).withJoinCriteria(Arrays.asList(andJoinCriteria));
            QueryExpressionDSL.this.addJoinSpecificationBuilder(this.joinSpecificationBuilder);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        @Override
        public JoinSpecificationFinisher configureStatement(Consumer<StatementConfiguration> consumer) {
            consumer.accept(QueryExpressionDSL.this.statementConfiguration);
            return this;
        }

        @Override
        public QueryExpressionWhereBuilder where() {
            return QueryExpressionDSL.this.where();
        }

        public JoinSpecificationFinisher and(BasicColumn joinColumn, JoinCondition joinCondition) {
            JoinCriterion joinCriterion = new JoinCriterion.Builder().withConnector("and").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder.withJoinCriterion(joinCriterion);
            return this;
        }

        public JoinSpecificationStarter join(SqlTable joinTable) {
            return QueryExpressionDSL.this.join(joinTable);
        }

        public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.join(joinTable, tableAlias);
        }

        public JoinSpecificationStarter join(Buildable<SelectModel> joinTable, String tableAlias) {
            return QueryExpressionDSL.this.join(joinTable, tableAlias);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.leftJoin(joinTable);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.leftJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter leftJoin(Buildable<SelectModel> joinTable, String tableAlias) {
            return QueryExpressionDSL.this.leftJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.rightJoin(joinTable);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.rightJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter rightJoin(Buildable<SelectModel> joinTable, String tableAlias) {
            return QueryExpressionDSL.this.rightJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.fullJoin(joinTable);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.fullJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter fullJoin(Buildable<SelectModel> joinTable, String tableAlias) {
            return QueryExpressionDSL.this.fullJoin(joinTable, tableAlias);
        }

        public GroupByFinisher groupBy(BasicColumn ... columns) {
            return this.groupBy(Arrays.asList(columns));
        }

        public GroupByFinisher groupBy(Collection<BasicColumn> columns) {
            return QueryExpressionDSL.this.groupBy(columns);
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return this.orderBy(Arrays.asList(columns));
        }

        public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }
    }
}

