/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.naming.CommunicationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.response.ErrorResponse;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
@Order(value=-300)
public class ReloadAuthoritiesInterceptor
extends HandlerInterceptorAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReloadAuthoritiesInterceptor.class);
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!KylinConfig.getInstanceFromEnv().isUTEnv() && auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.isAuthenticated()) {
            String name = auth.getName();
            ManagedUser user = null;
            try {
                user = (ManagedUser)this.userService.loadUserByUsername(name);
            }
            catch (UsernameNotFoundException e) {
                log.debug("Load user by name exception, set authentication to AnonymousAuthenticationToken", (Throwable)e);
                SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("anonymousUser", (Object)"anonymousUser", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ANONYMOUS"))));
                return true;
            }
            catch (org.springframework.ldap.CommunicationException communicationException) {
                boolean present = Optional.ofNullable(communicationException).map(Throwable::getCause).filter(CommunicationException.class::isInstance).map(Throwable::getCause).filter(ConnectException.class::isInstance).isPresent();
                if (present) {
                    response.setStatus(500);
                    response.setContentType("application/json");
                    ErrorResponse errorResponse = new ErrorResponse(request.getRequestURL().toString(), (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_DATA_SOURCE_CONNECTION_FAILED, MsgPicker.getMsg().getlDapUserDataSourceConnectionFailed()));
                    response.setCharacterEncoding("UTF-8");
                    PrintWriter writer = response.getWriter();
                    writer.print(JsonUtil.writeValueAsIndentString((Object)((Object)errorResponse)));
                    writer.flush();
                    writer.close();
                    return false;
                }
                throw communicationException;
            }
            if (user != null && auth instanceof UsernamePasswordAuthenticationToken) {
                UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)name, auth.getCredentials(), (Collection)user.getAuthorities());
                newAuth.setDetails((Object)user);
                SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
            }
        }
        return true;
    }
}

