/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.constant.ProjectInfoParserConstant;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInfoParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectInfoParser.class);
    private static final String PROJECT_PARAM = "project";
    private static final String PROJECT_NAME_PARAM = "projectName";

    private ProjectInfoParser() {
        throw new IllegalStateException("Utility class");
    }

    public static Pair<String, HttpServletRequest> parseProjectInfo(HttpServletRequest request) {
        Object requestWrapper = request;
        String project = null;
        try {
            ProjectRequest projectRequest;
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("application/x-www-form-urlencoded")) {
                project = requestWrapper.getParameter(PROJECT_PARAM);
            }
            if (StringUtils.isEmpty((CharSequence)(project = (requestWrapper = new RepeatableBodyRequestWrapper(request)).getParameter(PROJECT_PARAM)))) {
                project = requestWrapper.getParameter(PROJECT_NAME_PARAM);
            }
            if (StringUtils.isEmpty((CharSequence)project) && contentType != null && contentType.contains("json") && (projectRequest = (ProjectRequest)JsonUtil.readValue((byte[])((RepeatableBodyRequestWrapper)((Object)requestWrapper)).getBody(), ProjectRequest.class)) != null) {
                project = projectRequest.getProject();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtils.isEmpty(project)) {
            project = ProjectInfoParser.extractProject(request.getRequestURI());
        }
        if (StringUtils.isEmpty(project)) {
            project = ProjectInfoParser.extractUrlV2Project(request.getRequestURI(), requestWrapper);
        }
        if (StringUtils.isEmpty((CharSequence)project) && Objects.nonNull(request.getAttribute(PROJECT_PARAM))) {
            project = String.valueOf(request.getAttribute(PROJECT_PARAM));
        }
        if (StringUtils.isEmpty((CharSequence)project)) {
            project = "_global";
        }
        log.debug("Parsed project {} from request {}", (Object)project, (Object)request.getRequestURI());
        return new Pair((Object)project, requestWrapper);
    }

    static String extractProject(String url) {
        if (ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_EXCLUDED_LIST.contains(url)) {
            return null;
        }
        for (String needParserURI : ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_LIST) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserURI);
            if (!uriTemplate.match((CharSequence)url, kvMap = new HashMap())) continue;
            String project = (String)kvMap.get(PROJECT_PARAM);
            if (StringUtils.isEmpty((CharSequence)project)) {
                project = (String)kvMap.get(PROJECT_NAME_PARAM);
            }
            return project;
        }
        return null;
    }

    static String extractUrlV2Project(String url, HttpServletRequest requestWrapper) {
        String accept = requestWrapper.getHeader("Accept");
        if (!StringUtils.equals((CharSequence)accept, (CharSequence)"application/vnd.apache.kylin-v2+json") || ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_V2_EXCLUDED_LIST.contains(url)) {
            return null;
        }
        for (String needParserURI : ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_V2_LIST) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserURI);
            if (!uriTemplate.match((CharSequence)url, kvMap = new HashMap())) continue;
            String project = (String)kvMap.get(PROJECT_PARAM);
            if (StringUtils.isEmpty((CharSequence)project)) {
                project = (String)kvMap.get(PROJECT_NAME_PARAM);
            }
            return project;
        }
        return null;
    }

    public static class ProjectRequest {
        private String project;

        @Generated
        public ProjectRequest() {
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectRequest)) {
                return false;
            }
            ProjectRequest other = (ProjectRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            return !(this$project == null ? other$project != null : !this$project.equals(other$project));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProjectRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectInfoParser.ProjectRequest(project=" + this.getProject() + ")";
        }
    }

    public static class RepeatableBodyRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        public RepeatableBodyRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            return new ServletInputStream(){
                private boolean isFinished;

                public boolean isFinished() {
                    return this.isFinished;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    int b = byteArrayInputStream.read();
                    this.isFinished = b == -1;
                    return b;
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), Charset.defaultCharset()));
        }

        @Generated
        public byte[] getBody() {
            return this.body;
        }
    }
}

