/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeltaSourceOffset$
implements scala.Serializable {
    public static DeltaSourceOffset$ MODULE$;
    private final int VERSION_1;

    static {
        new DeltaSourceOffset$();
    }

    public int VERSION_1() {
        return this.VERSION_1;
    }

    public DeltaSourceOffset apply(long sourceVersion, String reservoirId, long reservoirVersion, long index, boolean isStartingVersion) {
        return new DeltaSourceOffset(sourceVersion, reservoirId, reservoirVersion, index, isStartingVersion);
    }

    public DeltaSourceOffset apply(String reservoirId, Offset offset) {
        DeltaSourceOffset deltaSourceOffset;
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSourceOffset) {
            DeltaSourceOffset deltaSourceOffset2;
            deltaSourceOffset = deltaSourceOffset2 = (DeltaSourceOffset)offset2;
        } else {
            this.validateSourceVersion(offset2.json());
            DeltaSourceOffset o = (DeltaSourceOffset)((Object)((ScalaObjectMapper)JsonUtils$.MODULE$.mapper()).readValue(offset2.json(), ManifestFactory$.MODULE$.classType(DeltaSourceOffset.class)));
            String string = o.reservoirId();
            String string2 = reservoirId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw DeltaErrors$.MODULE$.nonExistentDeltaTableStreaming(o.reservoirId());
            }
            deltaSourceOffset = o;
        }
        return deltaSourceOffset;
    }

    private void validateSourceVersion(String json) {
        JsonAST.JValue parsedJson = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Option versionOpt = this.jsonOption(package$.MODULE$.jvalue2monadic(parsedJson).$bslash("sourceVersion")).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)DeltaSourceOffset$.$anonfun$validateSourceVersion$1(x0$1)));
        if (versionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.cannotFindSourceVersionException(json);
        }
        int maxVersion = this.VERSION_1();
        if (BoxesRunTime.unboxToLong((Object)versionOpt.get()) > (long)maxVersion) {
            throw DeltaErrors$.MODULE$.invalidFormatFromSourceVersion(BoxesRunTime.unboxToLong((Object)versionOpt.get()), Predef$.MODULE$.int2Integer(maxVersion));
        }
    }

    private Option<JsonAST.JValue> jsonOption(JsonAST.JValue json) {
        None$ none$;
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            none$ = None$.MODULE$;
        } else if (jValue != null) {
            JsonAST.JValue jValue3 = jValue;
            none$ = new Some((Object)jValue3);
        } else {
            throw new MatchError((Object)jValue);
        }
        return none$;
    }

    public void validateOffsets(DeltaSourceOffset previousOffset, DeltaSourceOffset currentOffset) {
        if (!previousOffset.isStartingVersion() && currentOffset.isStartingVersion()) {
            throw new IllegalStateException(new StringBuilder(84).append("Found invalid offsets: 'isStartingVersion' fliped incorrectly. ").append("Previous: ").append((Object)previousOffset).append(", Current: ").append((Object)currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() > currentOffset.reservoirVersion()) {
            throw new IllegalStateException(new StringBuilder(75).append("Found invalid offsets: 'reservoirVersion' moved back. ").append("Previous: ").append((Object)previousOffset).append(", Current: ").append((Object)currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() == currentOffset.reservoirVersion() && previousOffset.index() > currentOffset.index()) {
            throw new IllegalStateException(new StringBuilder(64).append("Found invalid offsets. 'index' moved back. ").append("Previous: ").append((Object)previousOffset).append(", Current: ").append((Object)currentOffset).toString());
        }
    }

    public Option<Tuple5<Object, String, Object, Object, Object>> unapply(DeltaSourceOffset x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.sourceVersion()), (Object)x$0.reservoirId(), (Object)BoxesRunTime.boxToLong((long)x$0.reservoirVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isStartingVersion())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$validateSourceVersion$1(JsonAST.JValue x0$1) {
        JsonAST.JValue jValue = x0$1;
        if (!(jValue instanceof JsonAST.JInt)) {
            throw DeltaErrors$.MODULE$.invalidSourceVersion(jValue);
        }
        JsonAST.JInt jInt = (JsonAST.JInt)jValue;
        long l = jInt.num().longValue();
        return l;
    }

    private DeltaSourceOffset$() {
        MODULE$ = this;
        this.VERSION_1 = 1;
    }
}

