/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.GeneratedColumn$;
import org.apache.spark.sql.delta.IdentityColumnsTableFeature$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ColumnWithDefaultExprUtils$
implements DeltaLogging {
    public static ColumnWithDefaultExprUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ColumnWithDefaultExprUtils$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isIdentityColumn(StructField field) {
        org.apache.spark.sql.types.Metadata md = field.metadata();
        boolean hasStart = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_START());
        boolean hasStep = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP());
        boolean hasInsert = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT());
        if (hasStart != hasStep || hasStart != hasInsert) {
            throw DeltaErrors$.MODULE$.identityColumnInconsistentMetadata(field.name(), hasStart, hasStep, hasInsert);
        }
        return hasStart && hasStep && hasInsert;
    }

    public boolean hasIdentityColumn(StructType schema) {
        return schema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(field)));
    }

    public boolean satisfiesIdentityColumnProtocol(Protocol protocol) {
        return protocol.isFeatureSupported(IdentityColumnsTableFeature$.MODULE$);
    }

    public boolean columnHasDefaultExpr(Protocol protocol, StructField col) {
        return GeneratedColumn$.MODULE$.isGeneratedColumn(protocol, col);
    }

    public boolean tableHasDefaultExpr(Protocol protocol, Metadata metadata) {
        return GeneratedColumn$.MODULE$.enforcesGeneratedColumns(protocol, metadata);
    }

    public Tuple3<Dataset<Row>, Seq<Constraint>, scala.collection.immutable.Set<String>> addDefaultExprsOrReturnConstraints(DeltaLog deltaLog, QueryExecution queryExecution, StructType schema, Dataset<Row> data) {
        Dataset<Row> dataset;
        LazyRef metadataOutputNames$lzy = new LazyRef();
        CaseInsensitiveMap topLevelOutputNames = CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)data.schema().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        ArrayBuffer constraints = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set track = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq selectExprs = (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Iterable iterable;
            Option<Expression> option = GeneratedColumn$.MODULE$.getGenerationExpression((StructField)f);
            if (option instanceof Some) {
                Iterable iterable2;
                Some some = (Some)option;
                Expression expr = (Expression)some.value();
                if (topLevelOutputNames.contains(f.name())) {
                    Column column = SchemaUtils$.MODULE$.fieldToColumn((StructField)f);
                    constraints.$plus$eq((Object)new Constraints.Check("Generated Column", (Expression)new EqualNullSafe(column.expr(), expr)));
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)column.alias(f.name())));
                } else {
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Column(expr).alias(f.name())));
                }
                iterable = iterable2;
            } else if (None$.MODULE$.equals(option)) {
                iterable = topLevelOutputNames.contains(f.name()) || !BoxesRunTime.unboxToBoolean((Object)data.sparkSession().conf().get(DeltaSQLConf$.MODULE$.GENERATED_COLUMN_ALLOW_NULLABLE())) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)SchemaUtils$.MODULE$.fieldToColumn((StructField)f).alias(f.name()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        Seq cdcSelectExprs = (Seq)CDCReader$.MODULE$.CDC_COLUMNS_IN_DATA().flatMap((Function1 & Serializable & scala.Serializable)cdcColumnName -> Option$.MODULE$.option2Iterable(topLevelOutputNames.get(cdcColumnName).flatMap((Function1 & Serializable & scala.Serializable)cdcField -> ColumnWithDefaultExprUtils$.metadataOutputNames$1(metadataOutputNames$lzy, schema).contains(cdcColumnName) ? None$.MODULE$ : new Some((Object)SchemaUtils$.MODULE$.fieldToColumn((StructField)cdcField).alias(cdcField.name())))), Seq$.MODULE$.canBuildFrom());
        selectExprs = (Seq)selectExprs.$plus$plus((GenTraversableOnce)cdcSelectExprs, Seq$.MODULE$.canBuildFrom());
        QueryExecution queryExecution2 = queryExecution;
        if (queryExecution2 instanceof IncrementalExecution) {
            IncrementalExecution incrementalExecution = (IncrementalExecution)queryExecution2;
            dataset = this.selectFromStreamingDataFrame(incrementalExecution, data, (Seq<Column>)selectExprs);
        } else {
            dataset = data.select(selectExprs);
        }
        Dataset<Row> newData = dataset;
        this.recordDeltaEvent(deltaLog, "delta.generatedColumns.write", this.recordDeltaEvent$default$3(), this.recordDeltaEvent$default$4(), this.recordDeltaEvent$default$5());
        return new Tuple3(newData, (Object)constraints.toSeq(), (Object)track.toSet());
    }

    public StructType removeDefaultExpressions(StructType schema, boolean keepGeneratedColumns, boolean keepIdentityColumns) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        Seq updatedSchema = (Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            if (!keepGeneratedColumns && GeneratedColumn$.MODULE$.isGeneratedColumn((StructField)field)) {
                org.apache.spark.sql.types.Metadata newMetadata;
                updated$1.elem = true;
                org.apache.spark.sql.types.Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).remove(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()).build();
                String x$2 = field.copy$default$1();
                DataType x$3 = field.copy$default$2();
                boolean x$4 = field.copy$default$3();
                structField = field.copy(x$2, x$3, x$4, x$1);
            } else if (!keepIdentityColumns && MODULE$.isIdentityColumn((StructField)field)) {
                org.apache.spark.sql.types.Metadata newMetadata;
                updated$1.elem = true;
                org.apache.spark.sql.types.Metadata x$5 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_HIGHWATERMARK()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_START()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP()).build();
                String x$6 = field.copy$default$1();
                DataType x$7 = field.copy$default$2();
                boolean x$8 = field.copy$default$3();
                structField = field.copy(x$6, x$7, x$8, x$5);
            } else {
                structField = field;
            }
            return structField;
        }, Seq$.MODULE$.canBuildFrom());
        return updated.elem ? StructType$.MODULE$.apply(updatedSchema) : schema;
    }

    public boolean removeDefaultExpressions$default$2() {
        return false;
    }

    public boolean removeDefaultExpressions$default$3() {
        return false;
    }

    private Dataset<Row> selectFromStreamingDataFrame(IncrementalExecution incrementalExecution, Dataset<Row> df, Seq<Column> cols) {
        Dataset newMicroBatch = df.select(cols);
        IncrementalExecution newIncrementalExecution = new IncrementalExecution(newMicroBatch.sparkSession(), newMicroBatch.queryExecution().logical(), incrementalExecution.outputMode(), incrementalExecution.checkpointLocation(), incrementalExecution.queryId(), incrementalExecution.runId(), incrementalExecution.currentBatchId(), incrementalExecution.offsetSeqMetadata());
        newIncrementalExecution.executedPlan();
        Constructor constructor = Dataset.class.getConstructor(QueryExecution.class, Encoder.class);
        return (Dataset)constructor.newInstance(newIncrementalExecution, RowEncoder$.MODULE$.apply(newIncrementalExecution.analyzed().schema()));
    }

    private static final /* synthetic */ CaseInsensitiveMap metadataOutputNames$lzycompute$1(LazyRef metadataOutputNames$lzy$1, StructType schema$1) {
        CaseInsensitiveMap caseInsensitiveMap;
        LazyRef lazyRef = metadataOutputNames$lzy$1;
        synchronized (lazyRef) {
            caseInsensitiveMap = metadataOutputNames$lzy$1.initialized() ? (CaseInsensitiveMap)metadataOutputNames$lzy$1.value() : (CaseInsensitiveMap)metadataOutputNames$lzy$1.initialize((Object)CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)schema$1.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        }
        return caseInsensitiveMap;
    }

    private static final CaseInsensitiveMap metadataOutputNames$1(LazyRef metadataOutputNames$lzy$1, StructType schema$1) {
        return metadataOutputNames$lzy$1.initialized() ? (CaseInsensitiveMap)metadataOutputNames$lzy$1.value() : ColumnWithDefaultExprUtils$.metadataOutputNames$lzycompute$1(metadataOutputNames$lzy$1, schema$1);
    }

    private ColumnWithDefaultExprUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

