/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import io.delta.tables.execution.CreateTableOptions;
import io.delta.tables.execution.DeltaTableBuilderOptions;
import io.delta.tables.execution.ReplaceTableOptions;
import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedDBObjectName;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u0013&\u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"1a\t\u0001C\u0001K\u001dCq\u0001\u0014\u0001A\u0002\u0013%Q\nC\u0004Z\u0001\u0001\u0007I\u0011\u0002.\t\r\u0001\u0004\u0001\u0015)\u0003O\u0011\u001d\t\u0007\u00011A\u0005\n\tDqa\u001c\u0001A\u0002\u0013%\u0001\u000f\u0003\u0004s\u0001\u0001\u0006Ka\u0019\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B;\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0001\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011!\tI\u0002\u0001Q!\n\u0005E\u0001\"CA\u000e\u0001\u0001\u0007I\u0011BA\b\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\t\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00028!A\u00111\b\u0001!B\u0013\tI\u0003\u0003\u0005\u0002>\u0001\u0011\r\u0011\"\u0003N\u0011\u001d\ty\u0004\u0001Q\u0001\n9Cq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u00055\u0001\u0001\"\u0001\u0002^!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA2\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003G\u0002A\u0011AA@\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003#Cq!a\u0019\u0001\t\u0003\tY\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0002\u0012\t\u0016dG/\u0019+bE2,')^5mI\u0016\u0014(B\u0001\u0014(\u0003\u0019!\u0018M\u00197fg*\u0011\u0001&K\u0001\u0006I\u0016dG/\u0019\u0006\u0002U\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001Q\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\u0006gB\f'o\u001b\t\u0003kuj\u0011A\u000e\u0006\u0003oa\n1a]9m\u0015\t\u0019\u0014H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 7\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00035\u0011W/\u001b7eKJ|\u0005\u000f^5p]B\u0011\u0011\tR\u0007\u0002\u0005*\u00111)J\u0001\nKb,7-\u001e;j_:L!!\u0012\"\u00031\u0011+G\u000e^1UC\ndWMQ;jY\u0012,'o\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011*[\u0005CA%\u0001\u001b\u0005)\u0003\"B\u001a\u0004\u0001\u0004!\u0004\"B \u0004\u0001\u0004\u0001\u0015AC5eK:$\u0018NZ5feV\ta\n\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#>j\u0011A\u0015\u0006\u0003'.\na\u0001\u0010:p_Rt\u0014BA+0\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U{\u0013AD5eK:$\u0018NZ5fe~#S-\u001d\u000b\u00037z\u0003\"A\f/\n\u0005u{#\u0001B+oSRDqaX\u0003\u0002\u0002\u0003\u0007a*A\u0002yIE\n1\"\u001b3f]RLg-[3sA\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7ogV\t1\rE\u0002/I\u001aL!!Z\u0018\u0003\r=\u0003H/[8o!\r9GN\u0014\b\u0003Q*t!!U5\n\u0003AJ!a[\u0018\u0002\u000fA\f7m[1hK&\u0011QN\u001c\u0002\u0004'\u0016\f(BA60\u0003]\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8t?\u0012*\u0017\u000f\u0006\u0002\\c\"9q\fCA\u0001\u0002\u0004\u0019\u0017\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b%A\u0004d_2,XN\\:\u0016\u0003U\u00042A^>}\u001b\u00059(B\u0001=z\u0003\u001diW\u000f^1cY\u0016T!A_\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002noB\u0019Q0!\u0001\u000e\u0003yT!a \u001c\u0002\u000bQL\b/Z:\n\u0007\u0005\raPA\u0006TiJ,8\r\u001e$jK2$\u0017aC2pYVlgn]0%KF$2aWA\u0005\u0011\u001dy6\"!AA\u0002U\f\u0001bY8mk6t7\u000fI\u0001\tY>\u001c\u0017\r^5p]V\u0011\u0011\u0011\u0003\t\u0004]\u0011t\u0015\u0001\u00047pG\u0006$\u0018n\u001c8`I\u0015\fHcA.\u0002\u0018!AqLDA\u0001\u0002\u0004\t\t\"A\u0005m_\u000e\fG/[8oA\u0005QAO\u00197D_6lWM\u001c;\u0002\u001dQ\u0014GnQ8n[\u0016tGo\u0018\u0013fcR\u00191,!\t\t\u0011}\u000b\u0012\u0011!a\u0001\u0003#\t1\u0002\u001e2m\u0007>lW.\u001a8uA\u0005Q\u0001O]8qKJ$\u0018.Z:\u0016\u0005\u0005%\u0002CBA\u0016\u0003cqe*\u0004\u0002\u0002.)\u0019\u0011qF=\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA\u001a\u0003[\u00111!T1q\u00039\u0001(o\u001c9feRLWm]0%KF$2aWA\u001d\u0011!yF#!AA\u0002\u0005%\u0012a\u00039s_B,'\u000f^5fg\u0002\n1BR(S\u001b\u0006#vLT!N\u000b\u0006aai\u0014*N\u0003R{f*Q'FA\u0005IA/\u00192mK:\u000bW.\u001a\u000b\u0004\u0011\u0006\u0015\u0003\"\u0002'\u0019\u0001\u0004q\u0005f\u0001\r\u0002JA!\u00111JA)\u001b\t\tiEC\u0002\u0002Pa\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019&!\u0014\u0003\u0011\u00153x\u000e\u001c<j]\u001e\fqaY8n[\u0016tG\u000fF\u0002I\u00033Ba!!\u0016\u001a\u0001\u0004q\u0005fA\r\u0002JQ\u0019\u0001*a\u0018\t\r\u00055!\u00041\u0001OQ\rQ\u0012\u0011J\u0001\nC\u0012$7i\u001c7v[:$R\u0001SA4\u0003WBa!!\u001b\u001c\u0001\u0004q\u0015aB2pY:\u000bW.\u001a\u0005\u0007\u0003[Z\u0002\u0019\u0001(\u0002\u0011\u0011\fG/\u0019+za\u0016D3aGA%)\u0015A\u00151OA;\u0011\u0019\tI\u0007\ba\u0001\u001d\"9\u0011Q\u000e\u000fA\u0002\u0005]\u0004cA?\u0002z%\u0019\u00111\u0010@\u0003\u0011\u0011\u000bG/\u0019+za\u0016D3\u0001HA%)\u001dA\u0015\u0011QAB\u0003\u000bCa!!\u001b\u001e\u0001\u0004q\u0005BBA7;\u0001\u0007a\nC\u0004\u0002\bv\u0001\r!!#\u0002\u00119,H\u000e\\1cY\u0016\u00042ALAF\u0013\r\tii\f\u0002\b\u0005>|G.Z1oQ\ri\u0012\u0011\n\u000b\b\u0011\u0006M\u0015QSAL\u0011\u0019\tIG\ba\u0001\u001d\"9\u0011Q\u000e\u0010A\u0002\u0005]\u0004bBAD=\u0001\u0007\u0011\u0011\u0012\u0015\u0004=\u0005%Cc\u0001%\u0002\u001e\"1\u0011qT\u0010A\u0002q\f1aY8mQ\ry\u0012\u0011J\u0001\u000bC\u0012$7i\u001c7v[:\u001cHc\u0001%\u0002(\"9\u0011\u0011\u0016\u0011A\u0002\u0005-\u0016\u0001B2pYN\u00042!`AW\u0013\r\tyK \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007f\u0001\u0011\u0002J\u0005i\u0001/\u0019:uSRLwN\\3e\u0005f$2\u0001SA\\\u0011\u001d\tI,\ta\u0001\u0003w\u000b\u0001bY8m\u001d\u0006lWm\u001d\t\u0005]\u0005uf*C\u0002\u0002@>\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\r\t\u00131\u0019\t\u0005\u0003\u000b\fI-\u0004\u0002\u0002H*\u0019\u0011qJ\u0018\n\t\u0005-\u0017q\u0019\u0002\bm\u0006\u0014\u0018M]4tQ\r\t\u0013\u0011J\u0001\taJ|\u0007/\u001a:usR)\u0001*a5\u0002X\"1\u0011Q\u001b\u0012A\u00029\u000b1a[3z\u0011\u0019\tIN\ta\u0001\u001d\u0006)a/\u00197vK\"\u001a!%!\u0013\u0002\u000f\u0015DXmY;uKR\u0011\u0011\u0011\u001d\t\u0004\u0013\u0006\r\u0018bAAsK\tQA)\u001a7uCR\u000b'\r\\3)\u0007\r\nI\u0005K\u0002\u0001\u0003\u0013\u0002")
public class DeltaTableBuilder {
    private final SparkSession spark;
    private final DeltaTableBuilderOptions builderOption;
    private String identifier;
    private Option<Seq<String>> partitioningColumns;
    private scala.collection.mutable.Seq<StructField> columns;
    private Option<String> location;
    private Option<String> tblComment;
    private Map<String, String> properties;
    private final String FORMAT_NAME;

    public DeltaTableBuilder partitionedBy(String ... colNames) {
        return this.partitionedBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private String identifier() {
        return this.identifier;
    }

    private void identifier_$eq(String x$1) {
        this.identifier = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private scala.collection.mutable.Seq<StructField> columns() {
        return this.columns;
    }

    private void columns_$eq(scala.collection.mutable.Seq<StructField> x$1) {
        this.columns = x$1;
    }

    private Option<String> location() {
        return this.location;
    }

    private void location_$eq(Option<String> x$1) {
        this.location = x$1;
    }

    private Option<String> tblComment() {
        return this.tblComment;
    }

    private void tblComment_$eq(Option<String> x$1) {
        this.tblComment = x$1;
    }

    private Map<String, String> properties() {
        return this.properties;
    }

    private void properties_$eq(Map<String, String> x$1) {
        this.properties = x$1;
    }

    private String FORMAT_NAME() {
        return this.FORMAT_NAME;
    }

    @Evolving
    public DeltaTableBuilder tableName(String identifier) {
        this.identifier_$eq(identifier);
        return this;
    }

    @Evolving
    public DeltaTableBuilder comment(String comment) {
        this.tblComment_$eq((Option<String>)Option$.MODULE$.apply((Object)comment));
        return this;
    }

    @Evolving
    public DeltaTableBuilder location(String location) {
        this.location_$eq((Option<String>)Option$.MODULE$.apply((Object)location));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(StructField col) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$colon$plus((Object)col, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumns(StructType cols) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$plus$plus((GenTraversableOnce)cols.toSeq(), Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    @Evolving
    public DeltaTableBuilder partitionedBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    @Evolving
    public DeltaTableBuilder property(String key, String value) {
        this.properties_$eq((Map<String, String>)this.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    @Evolving
    public DeltaTable execute() {
        CreateTable createTable;
        TableIdentifier tableId;
        if (this.identifier() == null && this.location().isEmpty()) {
            throw DeltaErrors$.MODULE$.analysisException("Table name or location has to be specified", DeltaErrors$.MODULE$.analysisException$default$2(), DeltaErrors$.MODULE$.analysisException$default$3(), DeltaErrors$.MODULE$.analysisException$default$4(), DeltaErrors$.MODULE$.analysisException$default$5());
        }
        if (this.identifier() == null) {
            this.identifier_$eq(new StringBuilder(8).append("delta.`").append(this.location().get()).append("`").toString());
        }
        if (DeltaTableUtils$.MODULE$.isValidPath(tableId = this.spark.sessionState().sqlParser().parseTableIdentifier(this.identifier())) && this.location().nonEmpty()) {
            String string = tableId.table();
            Object object = this.location().get();
            if (string == null ? object != null : !string.equals(object)) {
                throw DeltaErrors$.MODULE$.analysisException(new StringBuilder(99).append("Creating path-based Delta table with a different location isn't supported. ").append("Identifier: ").append(this.identifier()).append(", Location: ").append(this.location().get()).toString(), DeltaErrors$.MODULE$.analysisException$default$2(), DeltaErrors$.MODULE$.analysisException$default$3(), DeltaErrors$.MODULE$.analysisException$default$4(), DeltaErrors$.MODULE$.analysisException$default$5());
            }
        }
        Seq table = this.spark.sessionState().sqlParser().parseMultipartIdentifier(this.identifier());
        Seq partitioning = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> DeltaTableUtils$.MODULE$.parseColToTransform((String)name), scala.collection.Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Map<String, String> x$1 = this.properties();
        Some x$2 = new Some((Object)this.FORMAT_NAME());
        Map x$3 = Predef$.MODULE$.Map().empty();
        Option<String> x$4 = this.location();
        None$ x$5 = None$.MODULE$;
        Option<String> x$6 = this.tblComment();
        boolean x$7 = false;
        TableSpec tableSpec = new TableSpec(x$1, (Option)x$2, x$3, x$4, x$6, (Option)x$5, x$7);
        DeltaTableBuilderOptions deltaTableBuilderOptions = this.builderOption;
        if (deltaTableBuilderOptions instanceof CreateTableOptions) {
            CreateTableOptions createTableOptions = (CreateTableOptions)deltaTableBuilderOptions;
            boolean ifNotExists = createTableOptions.ifNotExists();
            UnresolvedDBObjectName unresolvedTable = new UnresolvedDBObjectName(table, false);
            createTable = new CreateTable((LogicalPlan)unresolvedTable, StructType$.MODULE$.apply(this.columns().toSeq()), partitioning, tableSpec, ifNotExists);
        } else if (deltaTableBuilderOptions instanceof ReplaceTableOptions) {
            ReplaceTableOptions replaceTableOptions = (ReplaceTableOptions)deltaTableBuilderOptions;
            boolean orCreate = replaceTableOptions.orCreate();
            UnresolvedDBObjectName unresolvedTable = new UnresolvedDBObjectName(table, false);
            createTable = new ReplaceTable((LogicalPlan)unresolvedTable, StructType$.MODULE$.apply(this.columns().toSeq()), partitioning, tableSpec, orCreate);
        } else {
            throw new MatchError((Object)deltaTableBuilderOptions);
        }
        CreateTable stmt = createTable;
        QueryExecution qe = this.spark.sessionState().executePlan((LogicalPlan)stmt, this.spark.sessionState().executePlan$default$2());
        SQLExecution$.MODULE$.withNewExecutionId(qe, (Option)new Some((Object)"create delta table"), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
        return DeltaTableUtils$.MODULE$.isValidPath(tableId) ? DeltaTable$.MODULE$.forPath(this.spark, (String)this.location().get()) : DeltaTable$.MODULE$.forName(this.spark, this.identifier());
    }

    public DeltaTableBuilder(SparkSession spark, DeltaTableBuilderOptions builderOption) {
        this.spark = spark;
        this.builderOption = builderOption;
        this.identifier = null;
        this.partitioningColumns = None$.MODULE$;
        this.columns = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        this.location = None$.MODULE$;
        this.tblComment = None$.MODULE$;
        this.properties = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.TABLE_BUILDER_FORCE_TABLEPROPERTY_LOWERCASE())) ? CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty()) : Predef$.MODULE$.Map().empty();
        this.FORMAT_NAME = "delta";
    }
}

