/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.metadata.asynctask.MetadataRestoreTask;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.DiagPackageRequest;
import org.apache.kylin.rest.request.DiagProgressRequest;
import org.apache.kylin.rest.request.MaintenanceModeRequest;
import org.apache.kylin.rest.request.QueryDiagPackageRequest;
import org.apache.kylin.rest.response.DiagStatusResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.MaintenanceModeResponse;
import org.apache.kylin.rest.response.ServerExtInfoResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.response.ServersResponse;
import org.apache.kylin.rest.service.MetadataBackupService;
import org.apache.kylin.rest.service.OpsService;
import org.apache.kylin.rest.service.ScheduleService;
import org.apache.kylin.rest.service.SystemService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.tool.HDFSMetadataTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/system"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class OpsController
extends NBasicController {
    private static String DEPRECATED_MAINTENANCE_MODE = "Maintenance mode has been deprecated.";
    @Autowired
    @Qualifier(value="systemService")
    private SystemService systemService;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private MetadataBackupService metadataBackupService;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    @Qualifier(value="opsService")
    private OpsService opsService;
    private MetadataToolHelper metadataToolHelper = new MetadataToolHelper();

    @VisibleForTesting
    public void setAclEvaluate(AclEvaluate aclEvaluate) {
        this.aclEvaluate = aclEvaluate;
    }

    @VisibleForTesting
    public AclEvaluate getAclEvaluate() {
        return this.aclEvaluate;
    }

    @ApiOperation(value="dump ke inner metadata responding to system kylinconfig")
    @GetMapping(value={"/metadata/dump"})
    @ResponseBody
    public EnvelopeResponse<String> dumpMetadata(@RequestParam(value="dump_path") String dumpPath) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        HDFSMetadataTool.cleanBeforeBackup((KylinConfig)kylinConfig);
        KylinConfig backupConfig = kylinConfig.getMetadataBackupFromSystem() ? kylinConfig : KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        this.metadataToolHelper.backup(backupConfig, null, dumpPath, null, true, false);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="/diag", tags={"SM"})
    @PostMapping(value={"/diag"})
    @ResponseBody
    public EnvelopeResponse<String> getRemoteDumpDiagPackage(@RequestParam(value="host", required=false) String host, @RequestBody DiagPackageRequest diagPackageRequest, @RequestHeader HttpHeaders headers, HttpServletRequest request) throws Exception {
        host = this.decodeHost(host);
        AddressUtil.validateHost((String)host);
        if (StringUtils.isNotBlank((CharSequence)diagPackageRequest.getJobId())) {
            diagPackageRequest.setStart("");
            diagPackageRequest.setEnd("");
        } else if (StringUtils.isBlank((CharSequence)diagPackageRequest.getStart()) || StringUtils.isBlank((CharSequence)diagPackageRequest.getEnd())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_NOT_CONSISTENT, new Object[0]);
        }
        this.validateDataRange(diagPackageRequest.getStart(), diagPackageRequest.getEnd());
        if (StringUtils.isEmpty((CharSequence)host) || KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null) {
            String uuid = this.systemService.dumpLocalDiagPackage(diagPackageRequest.getStart(), diagPackageRequest.getEnd(), diagPackageRequest.getJobId(), diagPackageRequest.getProject(), headers);
            return new EnvelopeResponse("000", (Object)uuid, "");
        }
        String url = host + "/kylin/api/system/diag";
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="queryDiag", tags={"QE"})
    @PostMapping(value={"/diag/query"})
    @ResponseBody
    public EnvelopeResponse<String> getRemoteDumpQueryDiagPackage(@RequestParam(value="host", required=false) String host, @RequestBody QueryDiagPackageRequest queryDiagPackageRequest, @RequestHeader HttpHeaders headers, HttpServletRequest request) throws Exception {
        host = this.decodeHost(host);
        AddressUtil.validateHost((String)host);
        if (StringUtils.isEmpty((CharSequence)host) || KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null) {
            String uuid = this.systemService.dumpLocalQueryDiagPackage(queryDiagPackageRequest.getQueryId(), queryDiagPackageRequest.getProject(), headers);
            return new EnvelopeResponse("000", (Object)uuid, "");
        }
        String url = host + "/kylin/api/system/diag/query";
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="diagProgress", tags={"SM"})
    @PutMapping(value={"/diag/progress"})
    @ResponseBody
    public EnvelopeResponse<String> updateDiagProgress(@RequestBody DiagProgressRequest diagProgressRequest) {
        this.systemService.updateDiagProgress(diagProgressRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="diagStatus", tags={"SM"})
    @GetMapping(value={"/diag/status"})
    @ResponseBody
    public EnvelopeResponse<DiagStatusResponse> getRemotePackageStatus(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, @RequestParam(value="project", required=false) String project, HttpServletRequest request) throws Exception {
        host = this.decodeHost(host);
        AddressUtil.validateHost((String)host);
        if (StringUtils.isEmpty((CharSequence)host) || KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null) {
            return this.systemService.getExtractorStatus(id, project);
        }
        String url = host + "/kylin/api/system/diag/status?id=" + id;
        if (StringUtils.isNotEmpty((CharSequence)project)) {
            url = url + "&project=" + project;
        }
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="diagDownload", tags={"SM"})
    @GetMapping(value={"/diag"})
    @ResponseBody
    public void remoteDownloadPackage(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, @RequestParam(value="project", required=false) String project, HttpServletRequest request, HttpServletResponse response) throws IOException {
        host = this.decodeHost(host);
        AddressUtil.validateHost((String)host);
        if (StringUtils.isEmpty((CharSequence)host) || KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null) {
            this.setDownloadResponse(this.systemService.getDiagPackagePath(id, project), "application/octet-stream", response);
        } else {
            String url = host + "/kylin/api/system/diag?id=" + id;
            if (StringUtils.isNotEmpty((CharSequence)project)) {
                url = url + "&project=" + project;
            }
            this.downloadFromRemoteHost(request, url, response);
        }
    }

    @ApiOperation(value="cancelDiag", tags={"SM"})
    @DeleteMapping(value={"/diag"})
    @ResponseBody
    public EnvelopeResponse<String> remoteStopPackage(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, HttpServletRequest request) throws Exception {
        host = this.decodeHost(host);
        AddressUtil.validateHost((String)host);
        if (StringUtils.isEmpty((CharSequence)host) || KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null) {
            this.systemService.stopDiagTask(id);
            return new EnvelopeResponse("000", (Object)"", "");
        }
        String url = host + "/kylin/api/system/diag?id=" + id;
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="enterMaintenance", tags={"DW"})
    @PostMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> setMaintenanceMode(@RequestBody MaintenanceModeRequest maintenanceModeRequest) {
        return new EnvelopeResponse("000", (Object)"", DEPRECATED_MAINTENANCE_MODE);
    }

    @ApiOperation(value="exitMaintenance", tags={"DW"})
    @DeleteMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> unsetReadMode(@RequestParam(value="reason") String reason) {
        return new EnvelopeResponse("000", (Object)"", DEPRECATED_MAINTENANCE_MODE);
    }

    @ApiOperation(value="getMaintenance", tags={"DW"})
    @GetMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<MaintenanceModeResponse> getMaintenanceMode() {
        return new EnvelopeResponse("000", (Object)new MaintenanceModeResponse(false, DEPRECATED_MAINTENANCE_MODE), DEPRECATED_MAINTENANCE_MODE);
    }

    @ApiOperation(value="servers", tags={"DW"})
    @GetMapping(value={"/servers"})
    @ResponseBody
    public EnvelopeResponse<ServersResponse> getServers(@RequestParam(value="ext", required=false, defaultValue="false") boolean ext) {
        ServersResponse response = new ServersResponse();
        List servers = this.clusterManager.getServers();
        response.setStatus(new MaintenanceModeResponse(false, DEPRECATED_MAINTENANCE_MODE));
        if (ext) {
            response.setServers(servers.stream().map(server -> new ServerExtInfoResponse().setServer(server).setSecretName(this.encodeHost(server.getHost()))).collect(Collectors.toList()));
        } else {
            response.setServers(servers.stream().map(ServerInfoResponse::getHost).collect(Collectors.toList()));
        }
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="cleanup garbage", tags={"MID"})
    @PostMapping(value={"/cleanup_garbage"})
    @ResponseBody
    public EnvelopeResponse<String> cleanupGarbage(HttpServletRequest request) throws Exception {
        Pair result = this.scheduleService.triggerAllCleanupGarbage(request);
        return new EnvelopeResponse((String)result.getFirst(), result.getSecond(), "");
    }

    @ApiOperation(value="backup metadata", tags={"SM"})
    @PostMapping(value={"/do_metadata_backup"})
    @ResponseBody
    public EnvelopeResponse<String> backupMetadata(@RequestBody HashMap request) {
        String project = this.getProjectStrAndCheckPermission(request);
        String resPath = this.opsService.backupMetadata(project);
        return new EnvelopeResponse("000", (Object)resPath, "");
    }

    @ApiOperation(value="get metadata backup", tags={"SM"})
    @GetMapping(value={"/get_metadata_backup_list"})
    @ResponseBody
    public EnvelopeResponse<String> getMetadataBackupList(@RequestParam(value="project", required=false) String project) {
        project = this.getProjectStrAndCheckPermission(project);
        HashMap res = Maps.newHashMap();
        try {
            res.put("metadata_backup_list", OpsService.getMetadataBackupList((String)project));
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.GET_METADATA_BACKUP_LIST_FAILED, (Throwable)e, new Object[0]);
        }
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="cancel backup metadata", tags={"SM"})
    @PostMapping(value={"/cancel_metadata_backup"})
    @ResponseBody
    public EnvelopeResponse<String> cancelBackupMetadata(@RequestBody HashMap request) throws IOException {
        String path = (String)request.get("path");
        String project = this.getProjectStrAndCheckPermission(request);
        this.opsService.cancelAndDeleteMetadataBackup(path, project);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="delete metadata backup", tags={"SM"})
    @PostMapping(value={"/delete_metadata_backup"})
    @ResponseBody
    public EnvelopeResponse<String> deleteMetadataBackup(@RequestBody HashMap request) throws Exception {
        List pathList = (List)request.get("path");
        String project = this.getProjectStrAndCheckPermission(request);
        String msg = OpsService.deleteMetadataBackup((List)pathList, (String)project);
        return new EnvelopeResponse("000", null, msg);
    }

    @ApiOperation(value="restore metadata", tags={"SM"})
    @PostMapping(value={"/do_restore_metadata"})
    @ResponseBody
    public EnvelopeResponse<Map> restoreMetadata(@RequestBody HashMap request) {
        String path = (String)request.get("path");
        String project = this.getProjectStrAndCheckPermission(request);
        boolean is_truncate = (Boolean)request.get("is_truncate");
        String uuid = this.opsService.restoreMetadata(path, project, is_truncate);
        HashMap res = Maps.newHashMap();
        res.put("restore_task_id", uuid);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="get metadata backup store dir", tags={"SM"})
    @GetMapping(value={"/metadata_backup_store_dir"})
    @ResponseBody
    public EnvelopeResponse<String> getMetadataBackupStoreDir(@RequestParam(value="project", required=false) String project) {
        project = this.getProjectStrAndCheckPermission(project);
        String path = OpsService.getMetaBackupStoreDir((String)project);
        HashMap res = Maps.newHashMap();
        res.put("path", path);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="get metadata restore task status", tags={"SM"})
    @GetMapping(value={"/metadata_restore_task_status"})
    @ResponseBody
    public EnvelopeResponse<String> getMetadataRestoreTaskStatus(@RequestParam(value="project", required=false) String project, @RequestParam(value="restore_task_id", required=true) String uuid) {
        project = this.getProjectStrAndCheckPermission(project);
        MetadataRestoreTask.MetadataRestoreStatus status = this.opsService.getMetadataRestoreStatus(uuid, project);
        HashMap res = Maps.newHashMap();
        res.put("status", status);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="get has metadata restore task in progress", tags={"SM"})
    @GetMapping(value={"/has_metadata_restore_in_progress"})
    @ResponseBody
    public EnvelopeResponse<String> getHasMetadataRestoreTaskInProgress() {
        boolean running = OpsService.MetadataRestore.hasMetadataRestoreRunning();
        HashMap res = Maps.newHashMap();
        res.put("has_metadata_restore_in_progress", running);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    public String getProjectStrAndCheckPermission(HashMap map) {
        String project = (String)map.get("project");
        return this.getProjectStrAndCheckPermission(project);
    }

    public String getProjectStrAndCheckPermission(String project) {
        if (project == null || project.equals("_global")) {
            project = "_global";
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            ProjectInstance projectInstance = this.getProject(project);
            project = projectInstance.getName();
            this.aclEvaluate.checkProjectAdminPermission(project);
        }
        return project;
    }
}

