/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.cache.RemovalListener;
import org.apache.kylin.guava30.shaded.common.cache.RemovalNotification;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestLimits
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryRequestLimits.class);
    private static LoadingCache<String, AtomicInteger> runningStats = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, AtomicInteger>(){

        public void onRemoval(RemovalNotification<String, AtomicInteger> notification) {
            logger.info("Current running query number " + ((AtomicInteger)notification.getValue()).get() + " for project " + (String)notification.getKey() + " is removed due to " + notification.getCause());
        }
    }).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String s) throws Exception {
            return new AtomicInteger(0);
        }
    });
    private final String project;
    private final int maxConcurrentQuery;

    static boolean openQueryRequest(String project, int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return true;
        }
        try {
            int nRunning;
            AtomicInteger nRunningQueries = (AtomicInteger)runningStats.get((Object)project);
            while ((nRunning = nRunningQueries.get()) < maxConcurrentQuery) {
                if (!nRunningQueries.compareAndSet(nRunning, nRunning + 1)) continue;
                return true;
            }
            logger.warn("Can\u2019t submit query at the moment as there are {} ongoing queries.", (Object)nRunning);
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static void closeQueryRequest(String project, int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return;
        }
        AtomicInteger nRunningQueries = (AtomicInteger)runningStats.getIfPresent((Object)project);
        if (nRunningQueries != null) {
            nRunningQueries.decrementAndGet();
        }
    }

    public static Integer getCurrentRunningQuery(String project) {
        AtomicInteger nRunningQueries = (AtomicInteger)runningStats.getIfPresent((Object)project);
        if (nRunningQueries != null) {
            return nRunningQueries.get();
        }
        return null;
    }

    public QueryRequestLimits(String project) {
        this.project = project;
        NProjectManager mgr = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prj = mgr.getProject(project);
        this.maxConcurrentQuery = prj.getConfig().getQueryConcurrentRunningThresholdForProject();
        boolean ok = QueryRequestLimits.openQueryRequest(project, this.maxConcurrentQuery);
        QueryRequestLimits.checkRequest(ok);
    }

    private static void checkRequest(boolean ok) {
        if (!ok) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getQueryTooManyRunning());
        }
    }

    @Override
    public void close() {
        QueryRequestLimits.closeQueryRequest(this.project, this.maxConcurrentQuery);
    }
}

