/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.forward;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.PortForwardingTracker;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ExplicitPortForwardingTracker
extends PortForwardingTracker {
    private final boolean localForwarding;
    private final SshdSocketAddress remoteAddress;

    public ExplicitPortForwardingTracker(ClientSession session, boolean localForwarding, SshdSocketAddress localAddress, SshdSocketAddress remoteAddress, SshdSocketAddress boundAddress) {
        super(session, localAddress, boundAddress);
        this.localForwarding = localForwarding;
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "No remote address specified");
    }

    public boolean isLocalForwarding() {
        return this.localForwarding;
    }

    public SshdSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            ClientSession manager = this.getClientSession();
            if (this.isLocalForwarding()) {
                manager.stopLocalPortForwarding(this.getLocalAddress());
            } else {
                manager.stopRemotePortForwarding(this.getRemoteAddress());
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[localForwarding=" + this.isLocalForwarding() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

