/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;
import org.apache.kafka.coordinator.group.streams.StreamsCoordinatorRecordHelpers;

public record StreamsTopology(int topologyEpoch, Map<String, StreamsGroupTopologyValue.Subtopology> subtopologies, Map<String, StreamsGroupTopologyValue.Subtopology> sourceTopicMap) {
    public StreamsTopology(int topologyEpoch, Map<String, StreamsGroupTopologyValue.Subtopology> subtopologies) {
        this(topologyEpoch, subtopologies, StreamsTopology.computeSourceTopicMap(subtopologies));
    }

    public StreamsTopology {
        if (topologyEpoch < 0) {
            throw new IllegalArgumentException("Topology epoch must be non-negative.");
        }
        subtopologies = Collections.unmodifiableMap(Objects.requireNonNull(subtopologies, "Subtopologies cannot be null."));
        sourceTopicMap = Collections.unmodifiableMap(Objects.requireNonNull(sourceTopicMap, "Source topic map cannot be null."));
    }

    private static Map<String, StreamsGroupTopologyValue.Subtopology> computeSourceTopicMap(Map<String, StreamsGroupTopologyValue.Subtopology> subtopologies) {
        Objects.requireNonNull(subtopologies, "Subtopologies cannot be null.");
        HashMap<String, StreamsGroupTopologyValue.Subtopology> computedMap = new HashMap<String, StreamsGroupTopologyValue.Subtopology>();
        for (StreamsGroupTopologyValue.Subtopology subtopology : subtopologies.values()) {
            for (String sourceTopic : subtopology.sourceTopics()) {
                computedMap.put(sourceTopic, subtopology);
            }
            for (StreamsGroupTopologyValue.TopicInfo repartitionSourceTopic : subtopology.repartitionSourceTopics()) {
                computedMap.put(repartitionSourceTopic.name(), subtopology);
            }
        }
        return computedMap;
    }

    public Set<String> requiredTopics() {
        return this.subtopologies.values().stream().flatMap(x -> Stream.concat(Stream.concat(x.sourceTopics().stream(), x.repartitionSourceTopics().stream().map(StreamsGroupTopologyValue.TopicInfo::name)), x.stateChangelogTopics().stream().map(StreamsGroupTopologyValue.TopicInfo::name))).collect(Collectors.toSet());
    }

    public static StreamsTopology fromRecord(StreamsGroupTopologyValue record) {
        return new StreamsTopology(record.epoch(), record.subtopologies().stream().collect(Collectors.toMap(StreamsGroupTopologyValue.Subtopology::subtopologyId, x -> x)));
    }

    public static StreamsTopology fromHeartbeatRequest(StreamsGroupHeartbeatRequestData.Topology topology) {
        StreamsGroupTopologyValue recordValue = StreamsCoordinatorRecordHelpers.convertToStreamsGroupTopologyRecord(topology);
        Map<String, StreamsGroupTopologyValue.Subtopology> subtopologyMap = recordValue.subtopologies().stream().collect(Collectors.toMap(StreamsGroupTopologyValue.Subtopology::subtopologyId, x -> x));
        return new StreamsTopology(topology.epoch(), subtopologyMap);
    }

    public StreamsGroupDescribeResponseData.Topology asStreamsGroupDescribeTopology() {
        return new StreamsGroupDescribeResponseData.Topology().setEpoch(this.topologyEpoch).setSubtopologies(this.subtopologies.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> this.asStreamsGroupDescribeSubtopology((String)entry.getKey(), (StreamsGroupTopologyValue.Subtopology)entry.getValue())).toList());
    }

    private StreamsGroupDescribeResponseData.Subtopology asStreamsGroupDescribeSubtopology(String subtopologyId, StreamsGroupTopologyValue.Subtopology subtopology) {
        return new StreamsGroupDescribeResponseData.Subtopology().setSubtopologyId(subtopologyId).setSourceTopics(subtopology.sourceTopics().stream().sorted().toList()).setRepartitionSinkTopics(subtopology.repartitionSinkTopics().stream().sorted().toList()).setRepartitionSourceTopics(subtopology.repartitionSourceTopics().stream().map(this::asStreamsGroupDescribeTopicInfo).sorted(Comparator.comparing(StreamsGroupDescribeResponseData.TopicInfo::name)).toList()).setStateChangelogTopics(subtopology.stateChangelogTopics().stream().map(this::asStreamsGroupDescribeTopicInfo).sorted(Comparator.comparing(StreamsGroupDescribeResponseData.TopicInfo::name)).toList());
    }

    private StreamsGroupDescribeResponseData.TopicInfo asStreamsGroupDescribeTopicInfo(StreamsGroupTopologyValue.TopicInfo topicInfo) {
        return new StreamsGroupDescribeResponseData.TopicInfo().setName(topicInfo.name()).setPartitions(topicInfo.partitions()).setReplicationFactor(topicInfo.replicationFactor()).setTopicConfigs(topicInfo.topicConfigs().stream().map(topicConfig -> new StreamsGroupDescribeResponseData.KeyValue().setKey(topicConfig.key()).setValue(topicConfig.value())).toList());
    }
}

